/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.authspprotocol.handler;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.server.authspprotocol.IAuthSPProtocolHandler;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.session.SessionManager;
import org.aselect.system.exception.ASelectAuthSPException;
import org.aselect.system.exception.ASelectConfigException;

public class IP
implements IAuthSPProtocolHandler {
    private static final String MODULE = "IP";
    private static final String IP_ACCESS_DENIED = "800";
    private static final String IP_NO_ERROR = "000";
    private ASelectConfigManager _oASelectConfigManager;
    private SessionManager _oSessionManager;
    private ASelectSystemLogger _oASelectSystemLogger;
    private ASelectAuthenticationLogger _oASelectAuthenticationLogger;
    private CryptoEngine _oCryptoEngine;
    private String _sAuthsp;
    private String _sAuthspUrl;
    private String _sASelectID;
    private Hashtable _htIPRangesCGI;
    private Hashtable _htIPRanges;

    public void init(Object object, Object object2) throws ASelectAuthSPException {
        String string = "init()";
        this._htIPRanges = new Hashtable();
        this._htIPRangesCGI = new Hashtable();
        try {
            this._oASelectConfigManager = ASelectConfigManager.getHandle();
            this._oSessionManager = SessionManager.getHandle();
            this._oASelectAuthenticationLogger = ASelectAuthenticationLogger.getHandle();
            this._oASelectSystemLogger = ASelectSystemLogger.getHandle();
            this._oCryptoEngine = CryptoEngine.getHandle();
            Object object3 = null;
            try {
                object3 = this._oASelectConfigManager.getSection(null, "aselect");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No valid 'aselect' config section found", (Throwable)aSelectConfigException);
                throw new ASelectAuthSPException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._sASelectID = this._oASelectConfigManager.getParam(object3, "server_id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No valid 'server_id' config item in 'aselect' section found", (Throwable)aSelectConfigException);
                throw new ASelectAuthSPException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._sAuthsp = this._oASelectConfigManager.getParam(object, "id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No valid 'id' config item found", (Throwable)aSelectConfigException);
                throw new ASelectAuthSPException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._sAuthspUrl = this._oASelectConfigManager.getParam(object2, "url");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No valid 'url' config item found", (Throwable)aSelectConfigException);
                throw new ASelectAuthSPException("4009", (Throwable)aSelectConfigException);
            }
            Object object4 = null;
            try {
                object4 = this._oASelectConfigManager.getSection(object, "applications");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No valid 'applications' config section found", (Throwable)aSelectConfigException);
                throw new ASelectAuthSPException("4009", (Throwable)aSelectConfigException);
            }
            Object object5 = null;
            try {
                object5 = this._oASelectConfigManager.getSection(object4, "application");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No valid 'application' config section found", (Throwable)aSelectConfigException);
                throw new ASelectAuthSPException("4009", (Throwable)aSelectConfigException);
            }
            while (object5 != null) {
                CharSequence charSequence;
                String string2 = null;
                try {
                    string2 = this._oASelectConfigManager.getParam(object5, "app_id");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No valid 'app_id' config item found in 'application' section", (Throwable)aSelectConfigException);
                    throw new ASelectAuthSPException("4009", (Throwable)aSelectConfigException);
                }
                Object object6 = null;
                try {
                    object6 = this._oASelectConfigManager.getSection(object5, "iprange");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "No valid 'iprange' config section found", (Throwable)aSelectConfigException);
                    throw new ASelectAuthSPException("4009", (Throwable)aSelectConfigException);
                }
                Vector<CharSequence> vector = new Vector<CharSequence>();
                while (object6 != null) {
                    charSequence = null;
                    try {
                        charSequence = this._oASelectConfigManager.getParam(object6, "id");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        StringBuffer stringBuffer = new StringBuffer("No valid 'id' config item found in 'application' section with 'app_id':");
                        stringBuffer.append(string2);
                        this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), (Throwable)aSelectConfigException);
                        throw new ASelectAuthSPException("4009", (Throwable)aSelectConfigException);
                    }
                    if (((String)charSequence).length() > 0) {
                        vector.add(charSequence);
                    }
                    object6 = this._oASelectConfigManager.getNextSection(object6);
                }
                charSequence = new StringBuffer();
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < vector.size(); ++i) {
                    String string3 = (String)vector.get(i);
                    ((StringBuffer)charSequence).append("&");
                    ((StringBuffer)charSequence).append("ip_range");
                    ((StringBuffer)charSequence).append(i + 1);
                    ((StringBuffer)charSequence).append("=");
                    ((StringBuffer)charSequence).append(string3);
                    stringBuffer.append(string3);
                }
                if (stringBuffer.length() > 0) {
                    this._htIPRangesCGI.put(string2, ((StringBuffer)charSequence).toString());
                    this._htIPRanges.put(string2, stringBuffer.toString());
                }
                object5 = this._oASelectConfigManager.getNextSection(object5);
            }
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            throw aSelectAuthSPException;
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize IP AuthSP Handler", (Throwable)exception);
            throw new ASelectAuthSPException("0001", (Throwable)exception);
        }
    }

    public Hashtable computeAuthenticationRequest(String string) {
        String string2 = "computeAuthenticationRequest()";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("result", "0001");
        try {
            String string3;
            String string4;
            Hashtable hashtable2 = this._oSessionManager.getSessionContext(string);
            if (hashtable2 == null) {
                StringBuffer stringBuffer = new StringBuffer("could not fetch session context for rid: ");
                stringBuffer.append(string);
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
                throw new ASelectAuthSPException("0003");
            }
            String string5 = (String)hashtable2.get("app_id");
            if (string5 == null) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string2, "No 'app_id' found in session");
                throw new ASelectAuthSPException("0003");
            }
            String string6 = (String)hashtable2.get("user_id");
            String string7 = (String)this._htIPRangesCGI.get(string5);
            if (string7 == null) {
                StringBuffer stringBuffer = new StringBuffer("no ip ranges defined for app_id: ");
                stringBuffer.append(string5);
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
                throw new ASelectAuthSPException("0003");
            }
            String string8 = (String)this._htIPRanges.get(string5);
            if (string8 == null) {
                StringBuffer stringBuffer = new StringBuffer("no ip ranges defined for app_id: ");
                stringBuffer.append(string5);
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
                throw new ASelectAuthSPException("0003");
            }
            String string9 = (String)hashtable2.get("my_url");
            StringBuffer stringBuffer = new StringBuffer(string9);
            stringBuffer.append("?authsp=");
            stringBuffer.append(this._sAuthsp);
            String string10 = stringBuffer.toString();
            String string11 = (String)hashtable2.get("country");
            if (string11 == null || string11.trim().length() < 1) {
                string11 = null;
            }
            if ((string4 = (String)hashtable2.get("language")) == null || string4.trim().length() < 1) {
                string4 = null;
            }
            StringBuffer stringBuffer2 = new StringBuffer(string);
            stringBuffer2.append(string6);
            stringBuffer2.append(string10);
            stringBuffer2.append(string8);
            stringBuffer2.append(this._sASelectID);
            if (string11 != null) {
                stringBuffer2.append(string11);
            }
            if (string4 != null) {
                stringBuffer2.append(string4);
            }
            if ((string3 = this._oCryptoEngine.generateSignature(this._sAuthsp, stringBuffer2.toString())) == null) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string2, "Could not generate signature");
                throw new ASelectAuthSPException("0003");
            }
            string3 = URLEncoder.encode(string3, "UTF-8");
            string10 = URLEncoder.encode(string10, "UTF-8");
            string6 = URLEncoder.encode(string6, "UTF-8");
            StringBuffer stringBuffer3 = new StringBuffer(this._sAuthspUrl);
            stringBuffer3.append("?as_url=").append(string10);
            stringBuffer3.append("&rid=").append(string);
            stringBuffer3.append("&uid=").append(string6);
            stringBuffer3.append("&a-select-server=").append(this._sASelectID);
            if (string11 != null) {
                stringBuffer3.append("&country=").append(string11);
            }
            if (string4 != null) {
                stringBuffer3.append("&language=").append(string4);
            }
            stringBuffer3.append(string7);
            stringBuffer3.append("&signature=").append(string3);
            hashtable.put("result", "0000");
            hashtable.put("redirect_url", stringBuffer3.toString());
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            hashtable.put("result", aSelectAuthSPException.getMessage());
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string2, "Could not compute authentication request due to internal error", (Throwable)exception);
            hashtable.put("result", "0003");
        }
        return hashtable;
    }

    public Hashtable verifyAuthenticationResponse(Hashtable hashtable) {
        String string = "verifyAuthenticationResponse()";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        hashtable2.put("result", "0001");
        try {
            String string5 = (String)hashtable.get("rid");
            String string6 = (String)hashtable.get("my_url");
            String string7 = (String)hashtable.get("result_code");
            String string8 = (String)hashtable.get("signature");
            if (string5 == null || string7 == null || string8 == null) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "Incorrect AuthSP response: one or more parameters missing.");
                throw new ASelectAuthSPException("000a");
            }
            StringBuffer stringBuffer = new StringBuffer(string6);
            stringBuffer.append("?authsp=");
            stringBuffer.append(this._sAuthsp);
            string6 = stringBuffer.toString();
            StringBuffer stringBuffer2 = new StringBuffer(string5);
            stringBuffer2.append(string6);
            stringBuffer2.append(string7);
            string8 = URLDecoder.decode(string8, "UTF-8");
            if (!this._oCryptoEngine.verifySignature(this._sAuthsp, stringBuffer2.toString(), string8)) {
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, "Invalid signature in response from AuthSP");
                throw new ASelectAuthSPException("000a");
            }
            Hashtable hashtable3 = this._oSessionManager.getSessionContext(string5);
            if (hashtable3 == null) {
                StringBuffer stringBuffer3 = new StringBuffer("Session expired -> SessionContext not available for rid: ");
                stringBuffer3.append(string5);
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer3.toString());
                throw new ASelectAuthSPException("0102");
            }
            string2 = (String)hashtable3.get("user_id");
            string3 = (String)hashtable3.get("organization");
            string4 = (String)hashtable3.get("app_id");
            if (!string7.equalsIgnoreCase(IP_NO_ERROR)) {
                if (string7.equalsIgnoreCase(IP_ACCESS_DENIED)) {
                    this._oASelectAuthenticationLogger.log(new Object[]{MODULE, string2, hashtable.get("client_ip"), string3, string4, "denied"});
                    throw new ASelectAuthSPException("000b");
                }
                StringBuffer stringBuffer4 = new StringBuffer("AuthSP returned errorcode: ");
                stringBuffer4.append(string7);
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer4.toString());
                throw new ASelectAuthSPException("0003");
            }
            this._oASelectAuthenticationLogger.log(new Object[]{MODULE, string2, hashtable.get("client_ip"), string3, string4, "granted"});
            hashtable2.put("rid", string5);
            hashtable2.put("result", "0000");
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            hashtable2.put("result", aSelectAuthSPException.getMessage());
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string, "Could not verify authentication response due to internal error", (Throwable)exception);
            hashtable2.put("result", "0003");
        }
        return hashtable2;
    }
}

