/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.ntservice;

import java.util.logging.Level;
import org.aselect.agent.ASelectAgent;
import org.aselect.agent.log.ASelectAgentSystemLogger;
import org.aselect.agent.ntservice.AgentEvent;
import org.aselect.agent.ntservice.AgentEventManager;
import org.aselect.agent.ntservice.IAgentEventListener;
import org.aselect.system.logging.SystemLogger;

public class AgentNTService
implements IAgentEventListener {
    public static final String MODULE = "AgentNTService";
    private SystemLogger _systemLogger;
    private ASelectAgent _oASelectAgent = null;

    public static void main(String[] stringArray) {
        new AgentNTService();
    }

    public AgentNTService() {
        String string = "AgentNTService()";
        try {
            this._systemLogger = ASelectAgentSystemLogger.getHandle();
            this._oASelectAgent = new ASelectAgent();
            this._oASelectAgent.init();
            this._oASelectAgent.startServices();
            AgentEventManager.getInstance().addAgentEventListener(this);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Failed to start the AgentNTService", exception);
            if (this._oASelectAgent != null) {
                this._oASelectAgent.destroy();
            }
            System.exit(1);
        }
    }

    public void handleAgentEvent(AgentEvent agentEvent) {
        String string = "handleAgentEvent()";
        if (agentEvent.getId() == 1) {
            this._systemLogger.log(Level.INFO, MODULE, string, "received STOP event; stopping");
            if (this._oASelectAgent != null) {
                this.stopAgent();
            }
        } else if (agentEvent.getId() == 2) {
            this._systemLogger.log(Level.INFO, MODULE, string, "received SHUTDOWN event; stopping");
            if (this._oASelectAgent != null) {
                this.stopAgent();
            }
        }
    }

    private void stopAgent() {
        String string = "stopAgent()";
        try {
            this._systemLogger.log(Level.INFO, MODULE, string, "Stopping Agent...");
            this._oASelectAgent.destroy();
            this._oASelectAgent.destroyGui();
            this._oASelectAgent = null;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.INFO, MODULE, string, "Could not stop Agent", exception);
            System.exit(1);
        }
    }
}

