/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.handler;

import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.agent.handler.RequestHandler;
import org.aselect.system.communication.client.IClientCommunicator;
import org.aselect.system.exception.ASelectCommunicationException;

public class TraceRequestHandler
extends RequestHandler {
    public TraceRequestHandler(Socket socket, IClientCommunicator iClientCommunicator, boolean bl) {
        super(socket, iClientCommunicator, bl);
        this.MODULE = "TraceRequestHandler";
    }

    protected Hashtable sendRequestToASelectServer(String string, Hashtable hashtable) {
        String string2 = "sendRequestToASelectServer()";
        this._systemLogger.log(Level.FINE, this.MODULE, string2, "Sending API request");
        this._systemLogger.log(Level.FINE, this.MODULE, string2, "Destination : " + string);
        this._systemLogger.log(Level.FINE, this.MODULE, string2, "Parameters and values:\n" + this.dumpHashtable(hashtable));
        Hashtable hashtable2 = new Hashtable();
        try {
            hashtable2 = super.getClientCommunicator().sendMessage(hashtable, string);
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            StringBuffer stringBuffer = new StringBuffer("error while sending request to A-Select Server at \"");
            stringBuffer.append(string);
            stringBuffer.append("\"");
            this._systemLogger.log(Level.WARNING, this.MODULE, string2, stringBuffer.toString(), aSelectCommunicationException);
            this._sErrorCode = "010c";
            return hashtable2;
        }
        if (!hashtable2.isEmpty()) {
            this._systemLogger.log(Level.FINE, this.MODULE, string2, "Response parameters and values: " + this.dumpHashtable(hashtable2));
        }
        return hashtable2;
    }

    private String dumpHashtable(Hashtable hashtable) {
        String string = new String();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            string = string + "\t" + string2 + "=" + (String)hashtable.get(string2) + "\n";
        }
        return string;
    }
}

