/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.handler;

import java.io.IOException;
import java.net.Socket;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Signature;
import java.text.DateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.agent.authorization.AuthorizationEngine;
import org.aselect.agent.config.ASelectAgentConfigManager;
import org.aselect.agent.log.ASelectAgentSystemLogger;
import org.aselect.agent.sam.ASelectAgentSAMAgent;
import org.aselect.agent.session.SessionManager;
import org.aselect.agent.ticket.TicketManager;
import org.aselect.system.communication.client.IClientCommunicator;
import org.aselect.system.communication.server.Communicator;
import org.aselect.system.communication.server.IInputMessage;
import org.aselect.system.communication.server.IMessageCreatorInterface;
import org.aselect.system.communication.server.IOutputMessage;
import org.aselect.system.communication.server.TCPProtocolRequest;
import org.aselect.system.communication.server.TCPProtocolResponse;
import org.aselect.system.communication.server.raw.RawMessageCreator;
import org.aselect.system.communication.server.soap11.SOAP11MessageCreator;
import org.aselect.system.communication.server.soap12.SOAP12MessageCreator;
import org.aselect.system.exception.ASelectAuthorizationException;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMResource;
import org.aselect.system.utils.BASE64Decoder;
import org.aselect.system.utils.BASE64Encoder;
import org.aselect.system.utils.Base64;
import org.aselect.system.utils.Utils;

public class RequestHandler
extends Thread {
    public String MODULE = "RequestHandler";
    private final String CURRENT_TIME_ATTRIBUTE = "current_time";
    private final String IP_ATTRIBUTE = "ip";
    protected SystemLogger _systemLogger;
    protected String _sErrorCode;
    private TicketManager _ticketManager;
    private ASelectAgentConfigManager _configManager;
    private Socket _socket;
    private SessionManager _sessionManager;
    private IClientCommunicator _clientCommunicator;
    private boolean _bAuthorization = false;

    public RequestHandler(Socket socket, IClientCommunicator iClientCommunicator, boolean bl) {
        this._socket = socket;
        this._ticketManager = TicketManager.getHandle();
        this._configManager = ASelectAgentConfigManager.getHandle();
        this._sessionManager = SessionManager.getHandle();
        this._systemLogger = ASelectAgentSystemLogger.getHandle();
        this._clientCommunicator = iClientCommunicator;
        this._bAuthorization = bl;
    }

    public IClientCommunicator getClientCommunicator() {
        return this._clientCommunicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String string = "run()";
        try {
            Communicator communicator;
            TCPProtocolRequest tCPProtocolRequest = new TCPProtocolRequest(this._socket);
            TCPProtocolResponse tCPProtocolResponse = new TCPProtocolResponse(this._socket, tCPProtocolRequest.getProtocolName());
            IMessageCreatorInterface iMessageCreatorInterface = null;
            String string2 = tCPProtocolRequest.getProperty("Content-Type");
            if (string2 == null) {
                string2 = "";
            }
            if ((communicator = new Communicator(iMessageCreatorInterface = string2.indexOf("text/xml") > -1 ? new SOAP11MessageCreator(tCPProtocolRequest.getTarget(), "ASelect", ASelectAgentSystemLogger.getHandle()) : (string2.indexOf("application/soap+xml") > -1 ? new SOAP12MessageCreator(tCPProtocolRequest.getTarget(), "ASelect", ASelectAgentSystemLogger.getHandle()) : new RawMessageCreator(ASelectAgentSystemLogger.getHandle())))).init(tCPProtocolRequest, tCPProtocolResponse)) {
                this.processRequest(communicator);
                if (!communicator.send()) {
                    this._systemLogger.log(Level.WARNING, this.MODULE, string, "Could not send response to caller.");
                }
            } else {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "Could not initialize request.");
            }
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this.MODULE, string, "Could not initialize request.", aSelectCommunicationException);
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Exception: \"");
            stringBuffer.append(exception);
            stringBuffer.append("\"");
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, stringBuffer.toString(), exception);
        }
        finally {
            if (this._socket != null) {
                try {
                    this._socket.close();
                    this._socket = null;
                }
                catch (IOException iOException) {
                    this._systemLogger.log(Level.WARNING, this.MODULE, string, "Error closing socket.", iOException);
                }
            }
        }
    }

    protected void processRequest(Communicator communicator) {
        String string = "processRequest()";
        try {
            IInputMessage iInputMessage = communicator.getInputMessage();
            IOutputMessage iOutputMessage = communicator.getOutputMessage();
            String string2 = null;
            try {
                string2 = iInputMessage.getParam("request");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string2 == null) {
                iOutputMessage.setParam("result_code", "0130");
            } else if (string2.equals("authenticate")) {
                this.processAuthenticateRequest(iInputMessage, iOutputMessage);
            } else if (string2.equals("verify_credentials")) {
                this.processVerifyCredentialsRequest(iInputMessage, iOutputMessage);
            } else if (string2.equals("verify_ticket")) {
                this.processVerifyTicketRequest(iInputMessage, iOutputMessage);
            } else if (string2.equals("kill_ticket")) {
                this.processKillTicketRequest(iInputMessage, iOutputMessage);
            } else if (string2.equals("attributes")) {
                this.processAttributesRequest(iInputMessage, iOutputMessage);
            } else if (string2.equals("set_authorization_rules")) {
                this.processSetAuthorizationRulesRequest(iInputMessage, iOutputMessage);
            } else {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "Unknown or unsupported request received.");
                iOutputMessage.setParam("result_code", "0130");
            }
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this.MODULE, string, "Communication with A-Select Server failed.", aSelectCommunicationException);
        }
    }

    protected Hashtable sendRequestToASelectServer(String string, Hashtable hashtable) {
        String string2 = "sendRequestToASelectServer()";
        Hashtable hashtable2 = new Hashtable();
        try {
            hashtable2 = this._clientCommunicator.sendMessage(hashtable, string);
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.SEVERE, this.MODULE, string2, "The A-Select server could not be reached.", aSelectCommunicationException);
            this._sErrorCode = "010c";
        }
        return hashtable2;
    }

    private void processAuthenticateRequest(IInputMessage iInputMessage, IOutputMessage iOutputMessage) throws ASelectCommunicationException {
        String string = "processAuthenticateRequest()";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            try {
                string2 = iInputMessage.getParam("app_url");
                if (!string2.startsWith("http")) {
                    this._systemLogger.log(Level.WARNING, this.MODULE, string, "invalid 'app_url'");
                    iOutputMessage.setParam("result_code", "0130");
                    return;
                }
                string3 = iInputMessage.getParam("app_id");
                if (string3.length() == 0) {
                    this._systemLogger.log(Level.WARNING, this.MODULE, string, "invalid 'app_id'");
                    iOutputMessage.setParam("result_code", "0130");
                    return;
                }
            }
            catch (ASelectCommunicationException aSelectCommunicationException) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "Invalid request received.", aSelectCommunicationException);
                iOutputMessage.setParam("result_code", "0130");
                return;
            }
            try {
                string4 = iInputMessage.getParam("uid");
                if (string4.length() == 0) {
                    this._systemLogger.log(Level.FINE, this.MODULE, string, "Ignoring empty 'uid'.");
                    string4 = null;
                }
            }
            catch (ASelectCommunicationException aSelectCommunicationException) {
                this._systemLogger.log(Level.FINE, this.MODULE, string, "No optional parameter 'uid' found.");
                string4 = null;
            }
            try {
                string5 = iInputMessage.getParam("forced_logon");
            }
            catch (ASelectCommunicationException aSelectCommunicationException) {
                this._systemLogger.log(Level.FINE, this.MODULE, string, "No optional parameter 'forced_logon' found.");
            }
            try {
                string6 = iInputMessage.getParam("remote_organization");
                if (string6.length() == 0) {
                    this._systemLogger.log(Level.FINE, this.MODULE, string, "Ignoring empty 'remote_organization'.");
                    string6 = null;
                }
            }
            catch (ASelectCommunicationException aSelectCommunicationException) {
                this._systemLogger.log(Level.FINE, this.MODULE, string, "No optional parameter 'remote_organization' found.");
                string6 = null;
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("request", "authenticate");
            hashtable.put("app_url", string2);
            hashtable.put("app_id", string3);
            if (string4 != null) {
                hashtable.put("uid", string4);
            }
            if (string6 != null) {
                hashtable.put("remote_organization", string6);
            }
            if (string5 != null) {
                hashtable.put("forced_logon", string5);
            }
            String string7 = null;
            try {
                string7 = iInputMessage.getParam("country");
                if (string7.trim().length() > 0) {
                    hashtable.put("country", string7);
                }
            }
            catch (ASelectCommunicationException aSelectCommunicationException) {
                string7 = null;
            }
            String string8 = null;
            try {
                string8 = iInputMessage.getParam("language");
                if (string8.trim().length() > 0) {
                    hashtable.put("language", string8);
                }
            }
            catch (ASelectCommunicationException aSelectCommunicationException) {
                string8 = null;
            }
            Hashtable hashtable2 = this.sendToASelectServer(hashtable);
            if (hashtable2.isEmpty()) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "Could not reach A-Select Server.");
                iOutputMessage.setParam("result_code", "010c");
                return;
            }
            String string9 = (String)hashtable2.get("result_code");
            if (string9 == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "Invalid response from A-Select Server.");
                iOutputMessage.setParam("result_code", "010c");
                return;
            }
            if (!string9.equals("0000")) {
                stringBuffer = new StringBuffer("A-Select Server returned error: '");
                stringBuffer.append(string9);
                stringBuffer.append("'.");
                this._systemLogger.log(Level.WARNING, this.MODULE, string, stringBuffer.toString());
                iOutputMessage.setParam("result_code", string9);
                return;
            }
            String string10 = (String)hashtable2.get("rid");
            if (string10 == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "A-Select Server did not return 'rid'.");
                iOutputMessage.setParam("result_code", "010c");
                return;
            }
            String string11 = (String)hashtable2.get("as_url");
            if (string11 == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "A-Select Server did not return 'as_url'.");
                iOutputMessage.setParam("result_code", "010c");
                return;
            }
            String string12 = (String)hashtable2.get("a-select-server");
            if (string12 == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "A-Select Server did not return 'a-select-server'.");
                iOutputMessage.setParam("result_code", "010c");
                return;
            }
            Hashtable<String, String> hashtable3 = new Hashtable<String, String>();
            hashtable3.put("rid", string10);
            hashtable3.put("a-select-server", string12);
            hashtable3.put("user_type", "Local");
            hashtable3.put("app_id", string3);
            hashtable3.put("as_url", string11);
            if (!this._sessionManager.createSession(string10, hashtable3)) {
                this._systemLogger.log(Level.SEVERE, this.MODULE, string, "could not create session.");
                iOutputMessage.setParam("result_code", "0101");
                return;
            }
            iOutputMessage.setParam("as_url", string11);
            iOutputMessage.setParam("a-select-server", string12);
            iOutputMessage.setParam("rid", string10);
            iOutputMessage.setParam("result_code", "0000");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, "Could not create response message.", aSelectCommunicationException);
            iOutputMessage.setParam("result_code", "0101");
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer("Exception while processing request: \"");
            stringBuffer.append(exception.getMessage());
            stringBuffer.append("\"");
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, stringBuffer.toString(), exception);
            iOutputMessage.setParam("result_code", "0101");
        }
    }

    private void processVerifyCredentialsRequest(IInputMessage iInputMessage, IOutputMessage iOutputMessage) throws ASelectCommunicationException {
        String string = "processVerifyCredentialsRequest()";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            Object object;
            Hashtable<String, String> hashtable;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            try {
                string2 = iInputMessage.getParam("rid");
                string3 = iInputMessage.getParam("aselect_credentials");
                hashtable = this._sessionManager.getSessionContext(string2);
                if (hashtable == null) {
                    this._systemLogger.log(Level.WARNING, this.MODULE, string, "invalid session");
                    iOutputMessage.setParam("result_code", "0102");
                    return;
                }
                string4 = (String)hashtable.get("a-select-server");
                if (string4 == null) {
                    this._systemLogger.log(Level.WARNING, this.MODULE, string, "Missing 'a-select-server' in session.");
                    iOutputMessage.setParam("result_code", "0130");
                    return;
                }
            }
            catch (ASelectCommunicationException aSelectCommunicationException) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "Invalid request received.", aSelectCommunicationException);
                iOutputMessage.setParam("result_code", "0130");
                return;
            }
            hashtable = new Hashtable<String, String>();
            hashtable.put("request", "verify_credentials");
            hashtable.put("rid", string2);
            hashtable.put("aselect_credentials", string3);
            Hashtable hashtable2 = this.sendToASelectServer(hashtable);
            if (hashtable2.isEmpty()) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "Could not reach A-Select Server.");
                iOutputMessage.setParam("result_code", "010c");
                return;
            }
            String string5 = (String)hashtable2.get("result_code");
            if (string5 == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "Invalid response from A-Select Server.");
                iOutputMessage.setParam("result_code", "010c");
                return;
            }
            if (!string5.equals("0000")) {
                stringBuffer = new StringBuffer("A-Select Server returned error: '");
                stringBuffer.append(string5);
                stringBuffer.append("'.");
                this._systemLogger.log(Level.WARNING, this.MODULE, string, stringBuffer.toString());
                iOutputMessage.setParam("result_code", string5);
                return;
            }
            String string6 = (String)hashtable2.get("uid");
            if (string6 == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "A-Select Server did not return 'uid'");
                iOutputMessage.setParam("result_code", "010c");
                return;
            }
            string6 = URLDecoder.decode(string6, "UTF-8");
            string6 = URLDecoder.decode(string6, "UTF-8");
            String string7 = (String)hashtable2.get("organization");
            if (string7 == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "A-Select Server did not return 'organization'");
                iOutputMessage.setParam("result_code", "010c");
                return;
            }
            String string8 = (String)hashtable2.get("authsp_level");
            if (string8 == null) {
                string8 = (String)hashtable2.get("asp_level");
            }
            if (string8 == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "A-Select Server did not return 'authsp_level'");
                iOutputMessage.setParam("result_code", "010c");
                return;
            }
            String string9 = (String)hashtable2.get("authsp");
            if (string9 == null) {
                string9 = (String)hashtable2.get("asp");
            }
            if (string9 == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "A-Select Server did not return 'authsp'");
                iOutputMessage.setParam("result_code", "010c");
                return;
            }
            String string10 = (String)hashtable2.get("app_id");
            if (string10 == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "A-Select Server did not return 'app_id'");
                iOutputMessage.setParam("result_code", "010c");
                return;
            }
            String string11 = (String)hashtable2.get("app_level");
            if (string11 == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "A-Select Server did not return 'app_level'");
                iOutputMessage.setParam("result_code", "010c");
                return;
            }
            String string12 = (String)hashtable2.get("tgt_exp_time");
            if (string12 == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "A-Select Server did not return 'tgt_exp_time'");
                iOutputMessage.setParam("result_code", "010c");
                return;
            }
            Hashtable<String, Object> hashtable3 = new Hashtable<String, Object>();
            hashtable3.put("uid", string6);
            hashtable3.put("organization", string7);
            hashtable3.put("authsp_level", string8);
            hashtable3.put("authsp", string9);
            hashtable3.put("app_id", string10);
            hashtable3.put("app_level", string11);
            hashtable3.put("a-select-server", string4);
            hashtable3.put("tgt_exp_time", new Long(string12));
            String string13 = (String)hashtable2.get("attributes");
            if (string13 != null) {
                hashtable3.put("attributes", string13);
                object = new BASE64Decoder();
                MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
                messageDigest.update(((BASE64Decoder)object).decodeBuffer(string13));
                hashtable3.put("attributes_hash", Utils.toHexString(messageDigest.digest()));
            } else {
                hashtable3.put("attributes_hash", new String(""));
            }
            object = this._ticketManager.createTicket(hashtable3);
            if (object == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "TicketManager could not create ticket");
                iOutputMessage.setParam("result_code", "010d");
                return;
            }
            iOutputMessage.setParam("ticket", (String)object);
            iOutputMessage.setParam("ticket_start_time", new Long(this._ticketManager.getTicketStartTime((String)object)).toString());
            iOutputMessage.setParam("ticket_exp_time", new Long(this._ticketManager.getTicketTimeout((String)object)).toString());
            iOutputMessage.setParam("uid", string6);
            iOutputMessage.setParam("organization", string7);
            iOutputMessage.setParam("authsp_level", string8);
            iOutputMessage.setParam("authsp", string9);
            iOutputMessage.setParam("asp_level", string8);
            iOutputMessage.setParam("asp", string9);
            if (string13 != null) {
                iOutputMessage.setParam("attributes", string13);
            }
            iOutputMessage.setParam("result_code", "0000");
            this._sessionManager.killSession(string2);
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, "Could not create response message.", aSelectCommunicationException);
            iOutputMessage.setParam("result_code", "0101");
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer("Exception while processing request: \"");
            stringBuffer.append(exception.getMessage());
            stringBuffer.append("\"");
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, stringBuffer.toString(), exception);
            iOutputMessage.setParam("result_code", "0101");
        }
    }

    private void processVerifyTicketRequest(IInputMessage iInputMessage, IOutputMessage iOutputMessage) throws ASelectCommunicationException {
        String string = "processVerifyTicketRequest()";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            String string7 = null;
            try {
                string2 = iInputMessage.getParam("ticket");
                string3 = iInputMessage.getParam("uid");
                string4 = iInputMessage.getParam("organization");
            }
            catch (ASelectCommunicationException aSelectCommunicationException) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "Invalid request received.", aSelectCommunicationException);
                iOutputMessage.setParam("result_code", "0130");
                return;
            }
            try {
                string5 = iInputMessage.getParam("attributes_hash");
                string6 = iInputMessage.getParam("request_uri");
                string7 = iInputMessage.getParam("ip");
            }
            catch (ASelectCommunicationException aSelectCommunicationException) {
                // empty catch block
            }
            Hashtable hashtable = this._ticketManager.getTicketContext(string2);
            if (hashtable == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "Invalid request: unknown ticket.");
                iOutputMessage.setParam("result_code", "010b");
                return;
            }
            String string8 = (String)hashtable.get("uid");
            String string9 = (String)hashtable.get("organization");
            String string10 = (String)hashtable.get("attributes_hash");
            if (!string8.equals(string3)) {
                stringBuffer = new StringBuffer("Invalid request: uid mismatch: expected ");
                stringBuffer.append(string8).append(" but got ").append(string3);
                this._systemLogger.log(Level.WARNING, this.MODULE, string, stringBuffer.toString());
                iOutputMessage.setParam("result_code", "0109");
                return;
            }
            if (!string9.equals(string4)) {
                stringBuffer = new StringBuffer("Invalid request: organization mismatch: ");
                stringBuffer.append("expected ").append(string9);
                stringBuffer.append(" but got ").append(string4);
                this._systemLogger.log(Level.WARNING, this.MODULE, string, stringBuffer.toString());
                iOutputMessage.setParam("result_code", "0109");
                return;
            }
            if (string5 != null && !string10.equalsIgnoreCase(string5)) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "Received attributes do not match stored attributes.");
                string10 = (String)hashtable.get("attributes");
                if (string10 == null) {
                    string10 = "";
                }
                iOutputMessage.setParam("attributes", string10);
                iOutputMessage.setParam("result_code", "010e");
                return;
            }
            if (this._bAuthorization) {
                String string11 = (String)hashtable.get("app_id");
                Hashtable hashtable2 = this.deserializeAttributes((String)hashtable.get("attributes"));
                if (string7 != null) {
                    hashtable2.put("ip", string7);
                }
                DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
                hashtable2.put("current_time", dateFormat.format(new Date(System.currentTimeMillis())));
                hashtable2.putAll(hashtable);
                hashtable2.remove("attributes");
                if (!AuthorizationEngine.getHandle().isUserAuthorized(string11, string6, hashtable2)) {
                    this._systemLogger.log(Level.WARNING, this.MODULE, string, "User not authorized to access application " + string11);
                    iOutputMessage.setParam("result_code", "0140");
                    return;
                }
            }
            iOutputMessage.setParam("result_code", "0000");
        }
        catch (NumberFormatException numberFormatException) {
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, "Could not create response message.", numberFormatException);
            iOutputMessage.setParam("result_code", "0101");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            stringBuffer = new StringBuffer("Could not create response message.");
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, stringBuffer.toString(), aSelectCommunicationException);
            iOutputMessage.setParam("result_code", "0101");
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, "Error while processing request", aSelectException);
            iOutputMessage.setParam("result_code", "0101");
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, "Internal error while processing request", exception);
            iOutputMessage.setParam("result_code", "0101");
        }
    }

    private void processAttributesRequest(IInputMessage iInputMessage, IOutputMessage iOutputMessage) throws ASelectCommunicationException {
        String string = "processAttributesRequest()";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2 = null;
            String string3 = null;
            String string4 = null;
            try {
                string2 = iInputMessage.getParam("ticket");
                string3 = iInputMessage.getParam("uid");
                string4 = iInputMessage.getParam("organization");
            }
            catch (ASelectCommunicationException aSelectCommunicationException) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "Invalid request received.", aSelectCommunicationException);
                iOutputMessage.setParam("result_code", "0130");
                return;
            }
            Hashtable hashtable = this._ticketManager.getTicketContext(string2);
            if (hashtable == null) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "Invalid request: unknown ticket.");
                iOutputMessage.setParam("result_code", "010b");
                return;
            }
            String string5 = (String)hashtable.get("authsp");
            String string6 = (String)hashtable.get("app_level");
            iOutputMessage.setParam("ticket_start_time", new Long(this._ticketManager.getTicketStartTime(string2)).toString());
            iOutputMessage.setParam("ticket_exp_time", new Long(this._ticketManager.getTicketTimeout(string2)).toString());
            iOutputMessage.setParam("uid", string3);
            iOutputMessage.setParam("organization", string4);
            iOutputMessage.setParam("authsp_level", string6);
            iOutputMessage.setParam("authsp", string5);
            iOutputMessage.setParam("asp_level", string6);
            iOutputMessage.setParam("asp", string5);
            String string7 = (String)hashtable.get("attributes");
            if (string7 != null) {
                iOutputMessage.setParam("attributes", string7);
            } else {
                iOutputMessage.setParam("attributes", "");
            }
            iOutputMessage.setParam("result_code", "0000");
        }
        catch (NumberFormatException numberFormatException) {
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, "Could not create response message.", numberFormatException);
            iOutputMessage.setParam("result_code", "0101");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, "Could not create response message.", aSelectCommunicationException);
            iOutputMessage.setParam("result_code", "0101");
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer("Exception while processing request: \"");
            stringBuffer.append(exception.getMessage());
            stringBuffer.append("\"");
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, stringBuffer.toString(), exception);
            iOutputMessage.setParam("result_code", "0101");
        }
    }

    private void processKillTicketRequest(IInputMessage iInputMessage, IOutputMessage iOutputMessage) throws ASelectCommunicationException {
        String string = "processKillTicketRequest()";
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = null;
        try {
            string2 = iInputMessage.getParam("ticket");
            if (!this._ticketManager.killTicket(string2)) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string, "could not kill ticket");
                iOutputMessage.setParam("result_code", "010b");
                return;
            }
            iOutputMessage.setParam("result_code", "0000");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this.MODULE, string, "Invalid request received.", aSelectCommunicationException);
            iOutputMessage.setParam("result_code", "0130");
            return;
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer("Exception while processing request: \"");
            stringBuffer.append(exception.getMessage());
            stringBuffer.append("\"");
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, stringBuffer.toString(), exception);
            iOutputMessage.setParam("result_code", "0101");
        }
    }

    private void processSetAuthorizationRulesRequest(IInputMessage iInputMessage, IOutputMessage iOutputMessage) throws ASelectCommunicationException {
        if (!this._bAuthorization) {
            this._systemLogger.log(Level.WARNING, this.MODULE, "processSetAuthorizationRulesRequest()", "Invalid request received: authorization is not enabled.");
            iOutputMessage.setParam("result_code", "0141");
            return;
        }
        try {
            String string = iInputMessage.getParam("app_id");
            String[] stringArray = iInputMessage.getArray("rules");
            String[] stringArray2 = new String[stringArray.length];
            String[] stringArray3 = new String[stringArray.length];
            String[] stringArray4 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray5 = stringArray[i].split(";", 3);
                if (stringArray5.length == 3) {
                    stringArray2[i] = stringArray5[0];
                    stringArray3[i] = !stringArray5[1].equals("") ? stringArray5[1] : null;
                    stringArray4[i] = stringArray5[2];
                    continue;
                }
                if (stringArray5.length == 2) {
                    stringArray2[i] = stringArray5[0];
                    stringArray4[i] = stringArray5[1];
                    stringArray3[i] = null;
                    continue;
                }
                this._systemLogger.log(Level.WARNING, this.MODULE, "processSetAuthorizationRulesRequest()", "Invalid request received: invalid rules[].");
                iOutputMessage.setParam("result_code", "0130");
                return;
            }
            AuthorizationEngine.getHandle().setAuthorizationRules(string, stringArray2, stringArray4, stringArray3);
            this._systemLogger.log(Level.CONFIG, this.MODULE, "processSetAuthorizationRulesRequest()", "Authorization rules set for application " + string);
            iOutputMessage.setParam("result_code", "0000");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this.MODULE, "processSetAuthorizationRulesRequest()", "Invalid request received.", aSelectCommunicationException);
            iOutputMessage.setParam("result_code", "0130");
        }
        catch (ASelectAuthorizationException aSelectAuthorizationException) {
            this._systemLogger.log(Level.WARNING, this.MODULE, "processSetAuthorizationRulesRequest()", "Invalid request received: one or more rules are invalid", aSelectAuthorizationException);
            iOutputMessage.setParam("result_code", "0130");
            return;
        }
    }

    private Hashtable sendToASelectServer(Hashtable hashtable) {
        String string = "sendToASelectServer()";
        Hashtable hashtable2 = new Hashtable();
        ASelectAgentSAMAgent aSelectAgentSAMAgent = ASelectAgentSAMAgent.getHandle();
        try {
            SAMResource sAMResource = aSelectAgentSAMAgent.getActiveResource("aselectserver");
            Object object = sAMResource.getAttributes();
            String string2 = this._configManager.getParam(object, "aselect-server-id");
            String string3 = this._configManager.getParam(object, "url");
            hashtable.put("a-select-server", string2);
            this.signRequest(hashtable);
            hashtable2 = this.sendRequestToASelectServer(string3, hashtable);
        }
        catch (ASelectSAMException aSelectSAMException) {
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, "Error retrieving A-Select Server resource.", aSelectSAMException);
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, "Mandatory A-Select Server configuration parameter not found", aSelectConfigException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, this.MODULE, string, "Unknown error reading A-Select server configuration.", exception);
        }
        return hashtable2;
    }

    private void signRequest(Hashtable hashtable) throws Exception {
        if (!this._configManager.isSigningEnabled()) {
            return;
        }
        try {
            Object object;
            String string = this._configManager.getSignatureAlgorithm();
            Provider provider = this._configManager.getSignatureProvider();
            Signature signature = null;
            signature = provider != null ? Signature.getInstance(string, provider) : Signature.getInstance(string);
            StringBuffer stringBuffer = new StringBuffer();
            TreeSet treeSet = new TreeSet(hashtable.keySet());
            Object object2 = treeSet.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (((String)object).equals("request")) continue;
                stringBuffer.append(hashtable.get(object));
            }
            signature.initSign(this._configManager.getSigningKey());
            signature.update(stringBuffer.toString().getBytes());
            object2 = signature.sign();
            object = new BASE64Encoder();
            String string2 = ((BASE64Encoder)object).encode((byte[])object2);
            hashtable.put("signature", string2);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, this.MODULE, "signRequest()", "Could not sign request:", exception);
            throw new Exception("Unable to sign request.");
        }
    }

    protected Hashtable deserializeAttributes(String string) throws ASelectException {
        String string2 = "deSerializeAttributes()";
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (string != null) {
            try {
                String string3 = new String(Base64.decode(string));
                String[] stringArray = string3.split("&");
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = stringArray[i].indexOf("=");
                    String string4 = "";
                    String string5 = "";
                    Vector<String> vector = null;
                    if (n > 0) {
                        string4 = URLDecoder.decode(stringArray[i].substring(0, n), "UTF-8");
                        string5 = URLDecoder.decode(stringArray[i].substring(n + 1), "UTF-8");
                        if (string4.endsWith("[]")) {
                            vector = (Vector<String>)hashtable.get(string4 = string4.substring(0, string4.length() - 2));
                            if (vector == null) {
                                vector = new Vector<String>();
                            }
                            vector.add(string5);
                        }
                    } else {
                        string4 = URLDecoder.decode(stringArray[i], "UTF-8");
                    }
                    if (vector != null) {
                        hashtable.put(string4, vector);
                        continue;
                    }
                    hashtable.put(string4, string5);
                }
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, this.MODULE, string2, "Error during deserialization of attributes", exception);
                throw new ASelectException("0001", exception);
            }
        }
        return hashtable;
    }
}

