/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.authorization.parsing.types;

import java.util.StringTokenizer;

public class IPv6Address
implements Comparable {
    public static final String IPV6_REGEX = "(([0-9a-fA-F]{1,4}\\:){7}[0-9a-fA-F]{1,4})(\\/[0-9a-fA-F]{1,4}(\\:[0-9a-fA-F]{1,4}){0,7})?";
    private final int[] DEFAULT_MASK = new int[]{65535, 65535, 65535, 65535, 65535, 65535, 65535, 65535};
    private final int[] EMPTY_MASK = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private int[] _iaAddress;
    private int[] _iaMask;

    public IPv6Address(String string) throws Exception {
        String string2 = null;
        if (!string.matches(IPV6_REGEX)) {
            throw new Exception("Not a valid IP v6 address");
        }
        int n = string.indexOf(47);
        if (n > 0) {
            string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            this._iaMask = this.convertAddress(string3, true);
        } else {
            string2 = string;
            this._iaMask = this.DEFAULT_MASK;
        }
        this._iaAddress = this.convertAddress(string2, false);
    }

    public int compareTo(Object object) throws ClassCastException {
        int n = 0;
        if (object instanceof IPv6Address) {
            IPv6Address iPv6Address = (IPv6Address)object;
            boolean bl = true;
            for (int i = 0; i < 8 && bl; ++i) {
                bl = (iPv6Address._iaAddress[i] & this._iaMask[i]) == this._iaAddress[i];
            }
            n = bl ? 0 : -1;
        } else {
            throw new ClassCastException("IPv6Address objects are only comparable to other IPv6Address objects");
        }
        return n;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this._iaAddress.length; ++n) {
            stringBuffer.append(Integer.toHexString(this._iaAddress[n]));
            if (n >= this._iaAddress.length - 1) continue;
            stringBuffer.append(":");
        }
        if (this._iaMask.length > 0) {
            stringBuffer.append("/");
            for (n = 0; n < this._iaMask.length; ++n) {
                stringBuffer.append(Integer.toHexString(this._iaMask[n]));
                if (n >= this._iaMask.length - 1) continue;
                stringBuffer.append(":");
            }
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int[] convertAddress(String string, boolean bl) throws NumberFormatException {
        int[] nArray = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = stringTokenizer.countTokens();
        if (n == 1 && bl) {
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            if (n2 < 0 || n2 > 128) throw new NumberFormatException("Invalid IP v6 address");
            nArray = this.EMPTY_MASK;
            int n3 = 0;
            while (n2 >= 16) {
                nArray[n3] = 65535;
                n2 -= 16;
                ++n3;
            }
            if (n2 <= 0) return nArray;
            nArray[n3] = 65535 << 16 - n2;
            return nArray;
        } else {
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                nArray[i] = Integer.parseInt(string2, 16);
            }
        }
        return nArray;
    }
}

