/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.authorization.parsing;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import org.aselect.agent.authorization.parsing.types.IPv4Address;
import org.aselect.agent.authorization.parsing.types.IPv6Address;

public class AuthorizationRuleToken {
    public static final int DATA_GROUP = 0;
    public static final int OPERATOR_GROUP = 1;
    public static final int LOGIC_OPERATOR_GROUP = 2;
    public static final int STRING = 0;
    public static final int QUOTED_STRING = 1;
    public static final int SINGLE_QUOTED_STRING = 2;
    public static final int UNQUOTED_STRING = 3;
    public static final int LIST = 4;
    public static final int GREATER_THEN = 5;
    public static final int LESS_THEN = 6;
    public static final int GREATER_THEN_OR_EQUAL_TO = 7;
    public static final int LESS_THEN_OR_EQUAL_TO = 8;
    public static final int EQUAL_TO = 9;
    public static final int NOT_EQUAL_TO = 10;
    public static final int IN = 11;
    public static final int MATCH_REGULAR_EXPRESSION = 12;
    public static final int MATCH_WILDCARD_EXPRESSION = 13;
    public static final int AND = 14;
    public static final int OR = 15;
    public static final int NOT = 16;
    public static final int GROUP_START = 17;
    public static final int GROUP_END = 18;
    public int _iGroup;
    public int _iKind;
    private Object _oValue;

    public AuthorizationRuleToken(int n, int n2, Object object) {
        this._iGroup = n;
        this._iKind = n2;
        this._oValue = object;
    }

    public int getGroup() {
        return this._iGroup;
    }

    public int getKind() {
        return this._iKind;
    }

    public void setValue(Object object) {
        this._oValue = object;
    }

    public Object getValue() {
        return this._oValue;
    }

    public int hashCode() {
        return this._iKind;
    }

    public boolean equals(Object object) {
        if (object instanceof AuthorizationRuleToken) {
            AuthorizationRuleToken authorizationRuleToken = (AuthorizationRuleToken)object;
            return authorizationRuleToken._iKind == this._iKind && authorizationRuleToken._iGroup == this._iGroup;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{token(");
        stringBuffer.append(this._iGroup).append(", ");
        stringBuffer.append(this._iKind).append(") '");
        stringBuffer.append(this._oValue).append("'}");
        return stringBuffer.toString();
    }

    public static Object convertToKnownType(Object object) {
        Object object2 = object;
        if (object instanceof String) {
            DateFormat dateFormat;
            int n;
            String string = (String)object;
            if (string.matches("([0-9]+\\.){3}([0-9]+)(\\/([0-9]+)(\\.[0-9]+){0,3})?")) {
                try {
                    return new IPv4Address(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string.matches("(([0-9a-fA-F]{1,4}\\:){7}[0-9a-fA-F]{1,4})(\\/[0-9a-fA-F]{1,4}(\\:[0-9a-fA-F]{1,4}){0,7})?")) {
                try {
                    return new IPv6Address(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Locale[] localeArray = DateFormat.getAvailableLocales();
            for (n = 0; n < localeArray.length; ++n) {
                dateFormat = DateFormat.getDateTimeInstance(3, 3, localeArray[n]);
                try {
                    return dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
            for (n = 0; n < localeArray.length; ++n) {
                dateFormat = DateFormat.getDateInstance(3, localeArray[n]);
                try {
                    return dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
            for (n = 0; n < localeArray.length; ++n) {
                dateFormat = DateFormat.getTimeInstance(3, localeArray[n]);
                try {
                    return dateFormat.parse(string);
                }
                catch (ParseException parseException) {
                    continue;
                }
            }
            if (string.matches("[0-9]+")) {
                try {
                    return new Integer(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return object2;
    }
}

