/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.authorization.parsing;

import java.io.IOException;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.aselect.agent.authorization.parsing.AuthorizationRuleScanner;
import org.aselect.agent.authorization.parsing.AuthorizationRuleToken;
import org.aselect.agent.authorization.parsing.EvaluationTree;
import org.aselect.agent.authorization.parsing.types.IPv4Address;
import org.aselect.agent.authorization.parsing.types.IPv6Address;
import org.aselect.system.exception.ASelectAuthorizationException;
import org.aselect.system.logging.SystemLogger;

public class AuthorizationRuleParser {
    public static final String MODULE = "AuthorizationRuleParser";
    private SystemLogger _systemLoger;
    private AuthorizationRuleScanner _oScanner;
    private AuthorizationRuleToken _oCurrentToken;
    private EvaluationTree _tEvaluation;

    public AuthorizationRuleParser(AuthorizationRuleScanner authorizationRuleScanner, SystemLogger systemLogger) {
        this._systemLoger = systemLogger;
        this._oScanner = authorizationRuleScanner;
        this._tEvaluation = new EvaluationTree(null, null, null);
    }

    public void parse() throws ASelectAuthorizationException {
        try {
            this._oCurrentToken = this._oScanner.scan();
            this._tEvaluation = this.parseExpression();
        }
        catch (ASelectAuthorizationException aSelectAuthorizationException) {
            throw aSelectAuthorizationException;
        }
        catch (IOException iOException) {
            this._systemLoger.log(Level.WARNING, MODULE, "parse()", "Error scanning authorization rule", iOException);
            throw new ASelectAuthorizationException("4006");
        }
    }

    public EvaluationTree getEvaluationTree() {
        return this._tEvaluation;
    }

    private EvaluationTree parseExpression() throws ASelectAuthorizationException {
        EvaluationTree evaluationTree = this.parseSimpleExpression();
        if (this._oCurrentToken != null && this._oCurrentToken._iKind != 18) {
            if (this._oCurrentToken._iKind == 14) {
                evaluationTree = this.parseLogicExpression(evaluationTree);
            } else if (this._oCurrentToken._iKind == 15) {
                evaluationTree = this.parseLogicExpression(evaluationTree);
            } else {
                StringBuffer stringBuffer = new StringBuffer("Unexpected token: '");
                stringBuffer.append(this._oCurrentToken).append("' expected was '&', '|', or ')'.");
                this._systemLoger.log(Level.WARNING, MODULE, "parseExpression()", stringBuffer.toString());
                throw new ASelectAuthorizationException("0101");
            }
        }
        return evaluationTree;
    }

    private EvaluationTree parseSimpleExpression() throws ASelectAuthorizationException {
        StringBuffer stringBuffer = null;
        EvaluationTree evaluationTree = null;
        AuthorizationRuleToken authorizationRuleToken = this.acceptIt();
        if (authorizationRuleToken._iKind == 16) {
            evaluationTree = new EvaluationTree(this.parseSimpleExpression(), null, authorizationRuleToken);
        } else if (authorizationRuleToken._iKind == 17) {
            evaluationTree = this.parseExpression();
            this.acceptKind(18);
        } else if (authorizationRuleToken._iKind == 3) {
            EvaluationTree evaluationTree2 = new EvaluationTree(null, null, authorizationRuleToken);
            if (this._oCurrentToken != null && this._oCurrentToken._iGroup == 1) {
                Object object;
                AuthorizationRuleToken authorizationRuleToken2 = this.acceptIt();
                AuthorizationRuleToken authorizationRuleToken3 = this.acceptGroup(0);
                if (authorizationRuleToken2._iKind == 11) {
                    if (authorizationRuleToken3._iKind != 4) {
                        stringBuffer = new StringBuffer("Unexpected token after 'in' operator: '");
                        stringBuffer.append(authorizationRuleToken).append("', in operator can only be followed by a value list.");
                        this._systemLoger.log(Level.WARNING, MODULE, "parseSimpleExpression()", stringBuffer.toString());
                        throw new ASelectAuthorizationException("0101");
                    }
                } else if (authorizationRuleToken2._iKind == 12) {
                    try {
                        object = (String)authorizationRuleToken3.getValue();
                        Pattern pattern = Pattern.compile((String)object);
                        authorizationRuleToken3.setValue(pattern);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        stringBuffer = new StringBuffer("Unexpected token: '");
                        stringBuffer.append(authorizationRuleToken3);
                        stringBuffer.append("'. Invalid regular expression");
                        this._systemLoger.log(Level.WARNING, MODULE, "parseSimpleExpression()", stringBuffer.toString(), illegalArgumentException);
                        throw new ASelectAuthorizationException("0101");
                    }
                } else {
                    authorizationRuleToken3.setValue(AuthorizationRuleToken.convertToKnownType(authorizationRuleToken3.getValue()));
                    if ((authorizationRuleToken3.getValue() instanceof IPv4Address || authorizationRuleToken3.getValue() instanceof IPv6Address) && authorizationRuleToken2._iKind != 9 && authorizationRuleToken2._iKind != 10) {
                        Object object2 = authorizationRuleToken2.getValue();
                        stringBuffer = new StringBuffer("Unexpected token: '");
                        stringBuffer.append(authorizationRuleToken3).append("'. ");
                        stringBuffer.append(object2);
                        stringBuffer.append(" operator is not applicable for IP adresses.");
                        this._systemLoger.log(Level.WARNING, MODULE, "parseSimpleExpression()", stringBuffer.toString());
                        throw new ASelectAuthorizationException("0101");
                    }
                }
                object = new EvaluationTree(null, null, authorizationRuleToken3);
                evaluationTree = new EvaluationTree(evaluationTree2, (EvaluationTree)object, authorizationRuleToken2);
            } else {
                evaluationTree = evaluationTree2;
            }
        } else {
            stringBuffer = new StringBuffer("Unexpected token kind: '");
            stringBuffer.append(authorizationRuleToken).append("' start of a simple expression expected.");
            this._systemLoger.log(Level.WARNING, MODULE, "parseSimpleExpression()", stringBuffer.toString());
            throw new ASelectAuthorizationException("0101");
        }
        return evaluationTree;
    }

    private EvaluationTree parseLogicExpression(EvaluationTree evaluationTree) throws ASelectAuthorizationException {
        AuthorizationRuleToken authorizationRuleToken = this.acceptIt();
        EvaluationTree evaluationTree2 = this.parseSimpleExpression();
        EvaluationTree evaluationTree3 = new EvaluationTree(evaluationTree, evaluationTree2, authorizationRuleToken);
        if (this._oCurrentToken != null && this._oCurrentToken._iKind != 18) {
            if (this._oCurrentToken._iKind == authorizationRuleToken._iKind) {
                evaluationTree3 = this.parseLogicExpression(evaluationTree3);
            } else {
                StringBuffer stringBuffer = new StringBuffer("Unexpected token: '");
                stringBuffer.append(this._oCurrentToken).append("' expected '");
                stringBuffer.append(authorizationRuleToken).append("' or ')'.");
                this._systemLoger.log(Level.WARNING, MODULE, "parseLogicExpression()", stringBuffer.toString());
                throw new ASelectAuthorizationException("0101");
            }
        }
        return evaluationTree3;
    }

    private AuthorizationRuleToken acceptIt() throws ASelectAuthorizationException {
        AuthorizationRuleToken authorizationRuleToken = this._oCurrentToken;
        if (this._oCurrentToken != null) {
            try {
                this._oCurrentToken = this._oScanner.scan();
            }
            catch (IOException iOException) {
                this._systemLoger.log(Level.WARNING, MODULE, "acceptIt()", "Error scanning authorization rule", iOException);
                throw new ASelectAuthorizationException("4006");
            }
        } else {
            this._systemLoger.log(Level.WARNING, MODULE, "acceptIt()", "Unexpected end of authorization rule.");
            throw new ASelectAuthorizationException("0101");
        }
        return authorizationRuleToken;
    }

    private AuthorizationRuleToken acceptKind(int n) throws ASelectAuthorizationException {
        AuthorizationRuleToken authorizationRuleToken = this._oCurrentToken;
        if (this._oCurrentToken != null && this._oCurrentToken._iKind == n) {
            try {
                this._oCurrentToken = this._oScanner.scan();
            }
            catch (IOException iOException) {
                this._systemLoger.log(Level.WARNING, MODULE, "acceptKind()", "Error scanning authorization rule", iOException);
                throw new ASelectAuthorizationException("4006");
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer("Unexpected token: '");
            stringBuffer.append(authorizationRuleToken).append("' expected kind was: '");
            stringBuffer.append(n).append("'.");
            this._systemLoger.log(Level.WARNING, MODULE, "acceptKind()", stringBuffer.toString());
            throw new ASelectAuthorizationException("0101");
        }
        return authorizationRuleToken;
    }

    private AuthorizationRuleToken acceptGroup(int n) throws ASelectAuthorizationException {
        AuthorizationRuleToken authorizationRuleToken = this._oCurrentToken;
        if (this._oCurrentToken != null && this._oCurrentToken._iGroup == n) {
            try {
                this._oCurrentToken = this._oScanner.scan();
            }
            catch (IOException iOException) {
                this._systemLoger.log(Level.WARNING, MODULE, "acceptGroup()", "Error scanning authorization rule", iOException);
                throw new ASelectAuthorizationException("4006");
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer("Unexpected token: '");
            stringBuffer.append(authorizationRuleToken).append("' expected group was: '");
            stringBuffer.append(n).append("'.");
            this._systemLoger.log(Level.WARNING, MODULE, "acceptGroup()", stringBuffer.toString());
            throw new ASelectAuthorizationException("0101");
        }
        return authorizationRuleToken;
    }
}

