/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.authorization.evaluation;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aselect.agent.authorization.parsing.AuthorizationRuleToken;
import org.aselect.agent.authorization.parsing.EvaluationTree;
import org.aselect.agent.authorization.parsing.types.IPv4Address;
import org.aselect.agent.authorization.parsing.types.IPv6Address;
import org.aselect.system.exception.ASelectAuthorizationException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.utils.Utils;

public class AuthorizationRuleEvaluator {
    public static final String MODULE = "AuthorizationRuleEvaluator";
    private SystemLogger _systemLogger;

    public AuthorizationRuleEvaluator(SystemLogger systemLogger) {
        this._systemLogger = systemLogger;
    }

    public boolean evaluate(Hashtable hashtable, EvaluationTree evaluationTree) throws ASelectAuthorizationException {
        boolean bl = false;
        if (evaluationTree == null || evaluationTree.isEmpty()) {
            this._systemLogger.log(Level.WARNING, MODULE, "evaluate()", "Evaluation tree not available or empty.");
            throw new ASelectAuthorizationException("0101");
        }
        AuthorizationRuleToken authorizationRuleToken = (AuthorizationRuleToken)evaluationTree._oNode;
        switch (authorizationRuleToken._iGroup) {
            case 2: {
                bl = this.evaluateLogic(hashtable, evaluationTree);
                break;
            }
            case 1: {
                bl = this.evaluateSimple(hashtable, evaluationTree);
                break;
            }
            case 0: {
                bl = this.evaluateSimple(hashtable, evaluationTree);
                break;
            }
            default: {
                this._systemLogger.log(Level.WARNING, MODULE, "evaluate()", "Invalid evaluation tree: unknown token group.");
                throw new ASelectAuthorizationException("0101");
            }
        }
        return bl;
    }

    private boolean evaluateSimple(Hashtable hashtable, EvaluationTree evaluationTree) throws ASelectAuthorizationException {
        boolean bl = false;
        AuthorizationRuleToken authorizationRuleToken = (AuthorizationRuleToken)evaluationTree._oNode;
        if (evaluationTree.isLeaf()) {
            bl = hashtable.containsKey(authorizationRuleToken.getValue());
        } else {
            AuthorizationRuleToken authorizationRuleToken2 = (AuthorizationRuleToken)evaluationTree._tLeft._oNode;
            String string = (String)authorizationRuleToken2.getValue();
            Object v = hashtable.get(string);
            if (v == null) {
                bl = false;
            } else {
                AuthorizationRuleToken authorizationRuleToken3 = (AuthorizationRuleToken)evaluationTree._tRight._oNode;
                if (v instanceof Vector) {
                    bl = this.evaluateSimpleMultiValuedAttribute(authorizationRuleToken, authorizationRuleToken3, (Vector)v);
                } else if (v instanceof String) {
                    String string2 = (String)v;
                    switch (authorizationRuleToken._iKind) {
                        case 9: {
                            Comparable comparable = (Comparable)authorizationRuleToken3.getValue();
                            Comparable comparable2 = this.convertAttributeValue(comparable, string2);
                            bl = comparable.compareTo(comparable2) == 0;
                            break;
                        }
                        case 10: {
                            Comparable comparable = (Comparable)authorizationRuleToken3.getValue();
                            Comparable comparable3 = this.convertAttributeValue(comparable, string2);
                            bl = comparable.compareTo(comparable3) != 0;
                            break;
                        }
                        case 5: {
                            Comparable comparable = (Comparable)authorizationRuleToken3.getValue();
                            Comparable comparable4 = this.convertAttributeValue(comparable, string2);
                            bl = comparable.compareTo(comparable4) < 0;
                            break;
                        }
                        case 7: {
                            Comparable comparable = (Comparable)authorizationRuleToken3.getValue();
                            Comparable comparable5 = this.convertAttributeValue(comparable, string2);
                            bl = comparable.compareTo(comparable5) <= 0;
                            break;
                        }
                        case 6: {
                            Comparable comparable = (Comparable)authorizationRuleToken3.getValue();
                            Comparable comparable6 = this.convertAttributeValue(comparable, string2);
                            bl = comparable.compareTo(comparable6) > 0;
                            break;
                        }
                        case 8: {
                            Comparable comparable = (Comparable)authorizationRuleToken3.getValue();
                            Comparable comparable7 = this.convertAttributeValue(comparable, string2);
                            bl = comparable.compareTo(comparable7) >= 0;
                            break;
                        }
                        case 11: {
                            List list = (List)authorizationRuleToken3.getValue();
                            bl = list.contains(string2);
                            break;
                        }
                        case 12: {
                            Pattern pattern = (Pattern)authorizationRuleToken3.getValue();
                            Matcher matcher = pattern.matcher(string2);
                            bl = matcher.matches();
                            break;
                        }
                        case 13: {
                            String string3 = (String)authorizationRuleToken3.getValue();
                            bl = Utils.matchWildcardMask(string2, string3);
                            break;
                        }
                        default: {
                            this._systemLogger.log(Level.WARNING, MODULE, "evaluateSimple()", "Invalid evaluation tree: invalid token kind.");
                            throw new ASelectAuthorizationException("0101");
                        }
                    }
                }
            }
        }
        return bl;
    }

    private boolean evaluateSimpleMultiValuedAttribute(AuthorizationRuleToken authorizationRuleToken, AuthorizationRuleToken authorizationRuleToken2, Vector vector) throws ASelectAuthorizationException {
        boolean bl = false;
        Enumeration enumeration = vector.elements();
        String string = "";
        switch (authorizationRuleToken._iKind) {
            case 9: {
                while (enumeration.hasMoreElements() && !bl) {
                    Comparable comparable;
                    string = (String)enumeration.nextElement();
                    Comparable comparable2 = (Comparable)authorizationRuleToken2.getValue();
                    bl = comparable2.compareTo(comparable = this.convertAttributeValue(comparable2, string)) == 0;
                }
                break;
            }
            case 10: {
                while (enumeration.hasMoreElements() && !bl) {
                    Comparable comparable;
                    string = (String)enumeration.nextElement();
                    Comparable comparable3 = (Comparable)authorizationRuleToken2.getValue();
                    bl = comparable3.compareTo(comparable = this.convertAttributeValue(comparable3, string)) != 0;
                }
                break;
            }
            case 5: {
                while (enumeration.hasMoreElements() && !bl) {
                    Comparable comparable;
                    string = (String)enumeration.nextElement();
                    Comparable comparable4 = (Comparable)authorizationRuleToken2.getValue();
                    bl = comparable4.compareTo(comparable = this.convertAttributeValue(comparable4, string)) < 0;
                }
                break;
            }
            case 7: {
                while (enumeration.hasMoreElements() && !bl) {
                    Comparable comparable;
                    string = (String)enumeration.nextElement();
                    Comparable comparable5 = (Comparable)authorizationRuleToken2.getValue();
                    bl = comparable5.compareTo(comparable = this.convertAttributeValue(comparable5, string)) <= 0;
                }
                break;
            }
            case 6: {
                while (enumeration.hasMoreElements() && !bl) {
                    Comparable comparable;
                    string = (String)enumeration.nextElement();
                    Comparable comparable6 = (Comparable)authorizationRuleToken2.getValue();
                    bl = comparable6.compareTo(comparable = this.convertAttributeValue(comparable6, string)) > 0;
                }
                break;
            }
            case 8: {
                while (enumeration.hasMoreElements() && !bl) {
                    Comparable comparable;
                    string = (String)enumeration.nextElement();
                    Comparable comparable7 = (Comparable)authorizationRuleToken2.getValue();
                    bl = comparable7.compareTo(comparable = this.convertAttributeValue(comparable7, string)) >= 0;
                }
                break;
            }
            case 11: {
                while (enumeration.hasMoreElements() && !bl) {
                    string = (String)enumeration.nextElement();
                    List list = (List)authorizationRuleToken2.getValue();
                    bl = list.contains(string);
                }
                break;
            }
            case 12: {
                while (enumeration.hasMoreElements() && !bl) {
                    string = (String)enumeration.nextElement();
                    Pattern pattern = (Pattern)authorizationRuleToken2.getValue();
                    Matcher matcher = pattern.matcher(string);
                    bl = matcher.matches();
                }
                break;
            }
            case 13: {
                while (enumeration.hasMoreElements() && !bl) {
                    string = (String)enumeration.nextElement();
                    String string2 = (String)authorizationRuleToken2.getValue();
                    bl = Utils.matchWildcardMask(string, string2);
                }
                break;
            }
            default: {
                this._systemLogger.log(Level.WARNING, MODULE, "evaluateSimpleMultiValuedAttribute()", "Invalid evaluation tree: invalid token kind for multi-attribute.");
                throw new ASelectAuthorizationException("0101");
            }
        }
        return bl;
    }

    private boolean evaluateLogic(Hashtable hashtable, EvaluationTree evaluationTree) throws ASelectAuthorizationException {
        boolean bl = false;
        AuthorizationRuleToken authorizationRuleToken = (AuthorizationRuleToken)evaluationTree._oNode;
        switch (authorizationRuleToken._iKind) {
            case 16: {
                bl = !this.evaluate(hashtable, evaluationTree._tLeft);
                break;
            }
            case 14: {
                bl = this.evaluate(hashtable, evaluationTree._tLeft) && this.evaluate(hashtable, evaluationTree._tRight);
                break;
            }
            case 15: {
                bl = this.evaluate(hashtable, evaluationTree._tLeft) || this.evaluate(hashtable, evaluationTree._tRight);
                break;
            }
            default: {
                this._systemLogger.log(Level.WARNING, MODULE, "evaluateLogic()", "Invalid evaluation tree: invalid token kind.");
                throw new ASelectAuthorizationException("0101");
            }
        }
        return bl;
    }

    private Comparable convertAttributeValue(Comparable comparable, String string) throws ASelectAuthorizationException {
        StringBuffer stringBuffer = null;
        Object object = null;
        try {
            if (comparable instanceof IPv4Address) {
                object = new IPv4Address(string);
            } else if (comparable instanceof IPv6Address) {
                object = new IPv6Address(string);
            } else if (comparable instanceof Date) {
                DateFormat dateFormat;
                int n;
                Locale[] localeArray = DateFormat.getAvailableLocales();
                boolean bl = false;
                for (n = 0; n < localeArray.length && !bl; ++n) {
                    dateFormat = DateFormat.getDateTimeInstance(3, 3, localeArray[n]);
                    try {
                        object = dateFormat.parse(string);
                        bl = true;
                        continue;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                for (n = 0; n < localeArray.length && !bl; ++n) {
                    dateFormat = DateFormat.getDateInstance(3, localeArray[n]);
                    try {
                        object = dateFormat.parse(string);
                        bl = true;
                        continue;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                for (n = 0; n < localeArray.length && !bl; ++n) {
                    dateFormat = DateFormat.getTimeInstance(3, localeArray[n]);
                    try {
                        object = dateFormat.parse(string);
                        bl = true;
                        continue;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
                if (!bl) {
                    throw new Exception("Not a valid date or time format.");
                }
            } else {
                object = comparable instanceof Integer ? new Integer(string) : string;
            }
        }
        catch (NumberFormatException numberFormatException) {
            stringBuffer = new StringBuffer("Invalid attribute value: '");
            stringBuffer.append(string).append("'. Could not compare to a number.");
            this._systemLogger.log(Level.WARNING, MODULE, "convertAttributeValue()", stringBuffer.toString());
            throw new ASelectAuthorizationException("0101", numberFormatException);
        }
        catch (Exception exception) {
            stringBuffer = new StringBuffer("Invalid attribute value: '");
            stringBuffer.append(string).append("'. Could not compare to a an '");
            stringBuffer.append(comparable.getClass().getName()).append("' value");
            this._systemLogger.log(Level.WARNING, MODULE, "convertAttributeValue()", stringBuffer.toString(), exception);
            throw new ASelectAuthorizationException("0101", exception);
        }
        return object;
    }
}

