/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.admin;

import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.swing.table.AbstractTableModel;
import org.aselect.agent.config.ASelectAgentConfigManager;
import org.aselect.agent.log.ASelectAgentSystemLogger;
import org.aselect.agent.ticket.TicketManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectStorageException;

public class TicketMonitorModel
extends AbstractTableModel
implements Runnable {
    private Thread _runner;
    private String[] _ticketsStrings;
    private String[] _headersStrings = new String[]{"Issued to", "From Organization", "By A-Select Server", "Issued at", "Expires at", "AuthSP Used", "Level"};
    private int _iCheckInterval;
    private Hashtable _ticketContexts;
    private TicketManager _ticketManager = TicketManager.getHandle();
    private ASelectAgentConfigManager _configManager = ASelectAgentConfigManager.getHandle();
    private boolean _active;
    public static final String MODULE = "TicketMonitorModel";

    public TicketMonitorModel(int n) throws NumberFormatException, ASelectConfigException {
        this._iCheckInterval = n;
        Object object = this._configManager.getSection(null, "storagemanager", "id=ticket");
        String string = this._configManager.getParam(object, "max");
        Integer n2 = Integer.valueOf(string);
        this._ticketsStrings = new String[n2.intValue()];
        this.getAgentStatus();
        this._active = true;
        this._runner = new Thread(this);
        this._runner.start();
        this.fireTableDataChanged();
    }

    public void stop() {
        this._active = false;
        this._runner.interrupt();
    }

    public long getTicketsCounter() {
        return this._ticketManager.getTicketsCounter();
    }

    public int getRowCount() {
        return this._ticketContexts.size();
    }

    public int getColumnCount() {
        return this._headersStrings.length;
    }

    public Object getValueAt(int n, int n2) {
        String string = this._ticketsStrings[n];
        Hashtable hashtable = (Hashtable)this._ticketContexts.get(string);
        if (n2 == 0) {
            return (String)hashtable.get("uid");
        }
        if (n2 == 1) {
            return (String)hashtable.get("organization");
        }
        if (n2 == 2) {
            return (String)hashtable.get("a-select-server");
        }
        if (n2 == 3) {
            try {
                long l = this._ticketManager.getTicketStartTime(string);
                return new Date(l).toString();
            }
            catch (ASelectStorageException aSelectStorageException) {
                return "unknown";
            }
        }
        if (n2 == 4) {
            try {
                long l = this._ticketManager.getTicketTimeout(string);
                return new Date(l).toString();
            }
            catch (ASelectStorageException aSelectStorageException) {
                return "unknown";
            }
        }
        if (n2 == 5) {
            return (String)hashtable.get("authsp");
        }
        if (n2 == 6) {
            return (String)hashtable.get("authsp_level");
        }
        if (n2 == 7) {
            return string;
        }
        return null;
    }

    public String getColumnName(int n) {
        return this._headersStrings[n];
    }

    public void run() {
        String string = "run()";
        while (this._active) {
            try {
                Thread.sleep(this._iCheckInterval * 1000);
                this.getAgentStatus();
                this.fireTableDataChanged();
            }
            catch (Exception exception) {}
        }
        ASelectAgentSystemLogger.getHandle().log(Level.INFO, MODULE, string, "TicketMonitorModel stopped.");
    }

    private void getAgentStatus() {
        this._ticketContexts = this._ticketManager.getTicketContexts();
        int n = 0;
        Enumeration enumeration = this._ticketContexts.keys();
        while (enumeration.hasMoreElements()) {
            this._ticketsStrings[n++] = (String)enumeration.nextElement();
        }
    }
}

