/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.agent.admin;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.util.Date;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.aselect.agent.admin.SessionMonitorModel;
import org.aselect.agent.admin.TicketMonitorModel;
import org.aselect.agent.config.ASelectAgentConfigManager;
import org.aselect.agent.log.ASelectAgentSystemLogger;
import org.aselect.agent.ticket.TicketManager;

public class AdminMonitor
extends JFrame
implements TableModelListener {
    private JTable _ticketsTable;
    private JLabel _ticketsLabel = null;
    private TicketMonitorModel _ticketsMonitorModel = null;
    private JScrollPane xTicketsScrollPane = null;
    private JTable _sessionsTable;
    private JLabel _sessionsLabel = null;
    private JScrollPane xSessionsScrollPane = null;
    private SessionMonitorModel _sessionsMonitorModel = null;
    private JButton _killTicketButton = null;
    private JButton _killAllTicketsButton = null;
    private JButton _stopAgentButton = null;
    private int _buttonWidth = 130;
    private int _buttonHeight = 24;
    private JButton _line1;
    private JButton _line2;
    private JButton _line3;
    private JLabel _numberOfTicketsLabel;
    private JLabel _numberOfSessionsLabel;
    private JLabel _totalSessionsLabel;
    private JLabel _totalTicketsLabel;
    private JLabel _timeLabel;
    private TicketManager xTicketManager = TicketManager.getHandle();
    public static final String MODULE = "AdminMonitor";

    public void start(int n) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        StringBuffer stringBuffer = new StringBuffer("ASelectAgent");
        stringBuffer.append(" ").append("1.5.7");
        stringBuffer.append(" Admin Monitor");
        this.setTitle(stringBuffer.toString());
        this.setSize(800, 600);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new BasicWindowAdapter());
        this.getContentPane().setLayout(null);
        this._ticketsMonitorModel = new TicketMonitorModel(n);
        this._ticketsMonitorModel.addTableModelListener(this);
        this._ticketsTable = new JTable(this._ticketsMonitorModel);
        this.xTicketsScrollPane = new JScrollPane(this._ticketsTable);
        this.getContentPane().add(this.xTicketsScrollPane);
        this._ticketsLabel = new JLabel("Issued tickets");
        this.getContentPane().add(this._ticketsLabel);
        this._sessionsMonitorModel = new SessionMonitorModel(n);
        this._sessionsMonitorModel.addTableModelListener(this);
        this._sessionsTable = new JTable(this._sessionsMonitorModel);
        this.xSessionsScrollPane = new JScrollPane(this._sessionsTable);
        this.getContentPane().add(this.xSessionsScrollPane);
        this._sessionsLabel = new JLabel("Pending sessions");
        this.getContentPane().add(this._sessionsLabel);
        this._killAllTicketsButton = new JButton("Kill All Tickets");
        this.getContentPane().add(this._killAllTicketsButton);
        this._killAllTicketsButton.addActionListener(new KillAllButtonListener());
        this._stopAgentButton = new JButton("Stop Agent");
        this.getContentPane().add(this._stopAgentButton);
        this._stopAgentButton.addActionListener(new StopAgentButtonListener());
        this._line1 = new JButton();
        this._line1.setEnabled(false);
        this.getContentPane().add(this._line1);
        this._line2 = new JButton();
        this._line2.setEnabled(false);
        this.getContentPane().add(this._line2);
        this._line3 = new JButton();
        this._line3.setEnabled(false);
        this.getContentPane().add(this._line3);
        this._numberOfSessionsLabel = new JLabel("");
        this.getContentPane().add(this._numberOfSessionsLabel);
        this._numberOfTicketsLabel = new JLabel("");
        this.getContentPane().add(this._numberOfTicketsLabel);
        this._totalSessionsLabel = new JLabel("");
        this.getContentPane().add(this._totalSessionsLabel);
        this._totalTicketsLabel = new JLabel("");
        this.getContentPane().add(this._totalTicketsLabel);
        this._timeLabel = new JLabel("Started at " + new Date().toString());
        this.getContentPane().add(this._timeLabel);
        this._killTicketButton = new JButton("Kill Ticket");
        this.getContentPane().add(this._killTicketButton);
        this._killTicketButton.addActionListener(new KillButtonListener());
        this.getRootPane().setDefaultButton(this._killTicketButton);
        this.setLocation(1, 1);
        this.setVisible(true);
        this.toFront();
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        StringBuffer stringBuffer = new StringBuffer("Number of pending sessions: ");
        stringBuffer.append(this._sessionsMonitorModel.getRowCount());
        this._numberOfSessionsLabel.setText(stringBuffer.toString());
        stringBuffer = new StringBuffer("Number of issued tickets: ");
        stringBuffer.append(this._ticketsMonitorModel.getRowCount());
        this._numberOfTicketsLabel.setText(stringBuffer.toString());
        stringBuffer = new StringBuffer("Total sessions handled since startup: ");
        stringBuffer.append(this._sessionsMonitorModel.getSessionsCounter());
        this._totalSessionsLabel.setText(stringBuffer.toString());
        stringBuffer = new StringBuffer("Total tickets issued since startup: ");
        stringBuffer.append(this._ticketsMonitorModel.getTicketsCounter());
        this._totalTicketsLabel.setText(stringBuffer.toString());
    }

    public void stop() {
        String string = "stop()";
        if (this._ticketsMonitorModel != null) {
            this._ticketsMonitorModel.stop();
        }
        if (this._sessionsMonitorModel != null) {
            this._sessionsMonitorModel.stop();
        }
        ASelectAgentSystemLogger.getHandle().log(Level.INFO, MODULE, string, "AdminMonitor stopped.");
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getContentPane().getSize();
        int n = 4;
        int n2 = 16;
        int n3 = dimension.width - 8;
        this._sessionsLabel.setBounds(n + 10, n2, n3, 20);
        this.xSessionsScrollPane.setBounds(n, n2 + 24, n3, 120);
        n2 = this.xSessionsScrollPane.getY() + this.xSessionsScrollPane.getHeight() + 20;
        this._line1.setBounds(n, n2, n3, 2);
        this._ticketsLabel.setBounds(n + 10, n2 += 12, n3, 20);
        this.xTicketsScrollPane.setBounds(n, n2 + 24, n3, dimension.height - 400);
        n2 = this.xTicketsScrollPane.getY() + this.xTicketsScrollPane.getHeight() + 4;
        this._killTicketButton.setBounds((n3 - this._buttonWidth) / 2, n2, this._buttonWidth, this._buttonHeight);
        n = 4;
        n2 = this._killTicketButton.getY() + this._killTicketButton.getHeight() + 20;
        this._line2.setBounds(n, n2, n3, 2);
        this._line3.setBounds(n3 - this._buttonWidth - 20, n2, 2, dimension.height - n2);
        this._killAllTicketsButton.setBounds(n3 - this._buttonWidth - 8, n2 += 30, this._buttonWidth, this._buttonHeight);
        this._stopAgentButton.setBounds(n3 - this._buttonWidth - 8, n2 + this._buttonHeight + 20, this._buttonWidth, this._buttonHeight);
        n = 8;
        this._numberOfSessionsLabel.setBounds(n, n2 -= 20, this._stopAgentButton.getX() - 10, 20);
        this._totalSessionsLabel.setBounds(n, n2 += 24, this._stopAgentButton.getX() - 10, 20);
        this._numberOfTicketsLabel.setBounds(n, n2 += 24, this._stopAgentButton.getX() - 10, 20);
        this._totalTicketsLabel.setBounds(n, n2 += 24, this._stopAgentButton.getX() - 10, 20);
        this._timeLabel.setBounds(n, n2 += 24, this._stopAgentButton.getX() - 10, 20);
        super.paint(graphics);
    }

    private class BasicWindowAdapter
    extends WindowAdapter {
        private BasicWindowAdapter() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object == AdminMonitor.this) {
                // empty if block
            }
        }
    }

    private class StopAgentButtonListener
    implements ActionListener {
        private StopAgentButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                ASelectAgentConfigManager aSelectAgentConfigManager = ASelectAgentConfigManager.getHandle();
                Object object = aSelectAgentConfigManager.getSection(null, "agent");
                String string = aSelectAgentConfigManager.getParam(object, "adminport");
                Socket socket = new Socket("127.0.0.1", Integer.parseInt(string));
                PrintStream printStream = new PrintStream(socket.getOutputStream());
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                printStream.println("request=stop");
                String string2 = bufferedReader.readLine();
                System.out.println(string2);
                socket.close();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    private class KillAllButtonListener
    implements ActionListener {
        private KillAllButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                AdminMonitor.this.xTicketManager.killAllTickets();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class KillButtonListener
    implements ActionListener {
        KillButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                int[] nArray = AdminMonitor.this._ticketsTable.getSelectedRows();
                if (nArray == null) {
                    return;
                }
                for (int i = 0; i < nArray.length; ++i) {
                    AdminMonitor.this.xTicketManager.killTicket((String)AdminMonitor.this._ticketsMonitorModel.getValueAt(nArray[i], AdminMonitor.this._ticketsMonitorModel.getColumnCount()));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

