/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.authspprotocol.handler;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.server.authspprotocol.IAuthSPProtocolHandler;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.session.SessionManager;
import org.aselect.system.exception.ASelectAuthSPException;
import org.aselect.system.exception.ASelectConfigException;

public class PKI
implements IAuthSPProtocolHandler {
    private static final String MODULE = "PKI";
    private static final String PKI_NO_ERROR = "000";
    private static final String PKI_INVALID_REQUEST = "009";
    private static final String PKI_INTERNAL_SERVER_ERROR = "010";
    private static final String PKI_ERROR_PREFIX = "PKI";
    private ASelectConfigManager _oConfigManager;
    private SessionManager _oSessionManager;
    private ASelectSystemLogger _systemLogger;
    private ASelectAuthenticationLogger _authenticationLogger;
    private String _sAuthsp;
    private String _sAuthspUrl;
    private String _sTwoFactorAuthSp;
    private String _sTwoFactorAuthSpUrl;
    private String _sTwoFactorAuthSpRetries;

    public void init(Object object, Object object2) throws ASelectAuthSPException {
        String string = "init()";
        Object object3 = null;
        try {
            this._oConfigManager = ASelectConfigManager.getHandle();
            this._oSessionManager = SessionManager.getHandle();
            this._authenticationLogger = ASelectAuthenticationLogger.getHandle();
            this._systemLogger = ASelectSystemLogger.getHandle();
            StringBuffer stringBuffer = new StringBuffer("Starting : ");
            stringBuffer.append("PKI");
            this._systemLogger.log(Level.INFO, "PKI", string, stringBuffer.toString());
            try {
                this._sAuthsp = this._oConfigManager.getParam(object, "id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, "PKI", string, "No valid 'id' config item found in authsp section");
                throw new ASelectAuthSPException("4009");
            }
            try {
                this._sAuthspUrl = this._oConfigManager.getParam(object2, "url");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, "PKI", string, "No valid 'id' config item found in authsp resource section");
                throw new ASelectAuthSPException("4009");
            }
            try {
                object3 = this._oConfigManager.getSection(null, "aselect");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, "PKI", string, "No main 'aselect' config section found", (Throwable)aSelectConfigException);
                throw new ASelectAuthSPException("4009");
            }
            try {
                Object object4 = this._oConfigManager.getSection(object, "two_factor_authentication");
                this._sTwoFactorAuthSp = this._oConfigManager.getParam(object4, "id");
                this._sTwoFactorAuthSpUrl = this._oConfigManager.getParam(object4, "url");
                this._sTwoFactorAuthSpRetries = this._oConfigManager.getParam(object4, "retries");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, "PKI", string, "No valid two factor configuration found; two factor authentication disabled.");
            }
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            this._systemLogger.log(Level.SEVERE, "PKI", string, "Could not initialize", (Throwable)aSelectAuthSPException);
            throw aSelectAuthSPException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "PKI", string, "Could not initialize due to internal error", (Throwable)exception);
            throw new ASelectAuthSPException("0001", (Throwable)exception);
        }
    }

    public Hashtable computeAuthenticationRequest(String string) {
        String string2 = "computeAuthenticationRequest()";
        String string3 = null;
        String string4 = null;
        StringBuffer stringBuffer = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("result", "0000");
        try {
            Hashtable hashtable2 = this._oSessionManager.getSessionContext(string);
            if (hashtable2 == null) {
                stringBuffer = new StringBuffer("Could not fetch session context for rid='");
                stringBuffer.append(string).append("'.");
                this._systemLogger.log(Level.WARNING, "PKI", string2, stringBuffer.toString());
                throw new ASelectAuthSPException("0003");
            }
            Hashtable hashtable3 = (Hashtable)hashtable2.get("allowed_user_authsps");
            if (hashtable3 == null) {
                this._systemLogger.log(Level.WARNING, "PKI", string2, "Allowed user AuthSPs missing in session context.");
                throw new ASelectAuthSPException("0003");
            }
            String string5 = null;
            if (this._sTwoFactorAuthSp != null && this._sTwoFactorAuthSpUrl != null) {
                string5 = (String)hashtable3.get(this._sTwoFactorAuthSp);
            }
            String string6 = (String)hashtable3.get(this._sAuthsp);
            stringBuffer = new StringBuffer((String)hashtable2.get("my_url"));
            stringBuffer.append("?authsp=").append(this._sAuthsp);
            String string7 = stringBuffer.toString();
            try {
                string4 = this._oConfigManager.getParam(this._oConfigManager.getSection(null, "aselect"), "server_id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                stringBuffer = new StringBuffer(string2);
                stringBuffer.append(aSelectConfigException.getMessage());
                this._systemLogger.log(Level.SEVERE, stringBuffer.toString(), (Throwable)aSelectConfigException);
                throw new ASelectAuthSPException("0003");
            }
            stringBuffer = new StringBuffer(string).append(string7).append(string6).append(string4);
            if (this._sTwoFactorAuthSp != null && this._sTwoFactorAuthSpUrl != null && this._sTwoFactorAuthSpRetries != null && string5 != null) {
                stringBuffer.append(this._sTwoFactorAuthSp);
                stringBuffer.append(this._sTwoFactorAuthSpUrl);
                stringBuffer.append(this._sTwoFactorAuthSpRetries);
                stringBuffer.append(string5);
            }
            if ((string3 = CryptoEngine.getHandle().generateSignature(this._sAuthsp, stringBuffer.toString())) == null) {
                hashtable.put("result", "0003");
                return hashtable;
            }
            try {
                string3 = URLEncoder.encode(string3, "UTF-8");
                string6 = URLEncoder.encode(string6, "UTF-8");
                string7 = URLEncoder.encode(string7, "UTF-8");
                if (this._sTwoFactorAuthSp != null && this._sTwoFactorAuthSpUrl != null && string5 != null) {
                    this._sTwoFactorAuthSp = URLEncoder.encode(this._sTwoFactorAuthSp, "UTF-8");
                    this._sTwoFactorAuthSpUrl = URLEncoder.encode(this._sTwoFactorAuthSpUrl, "UTF-8");
                    string5 = URLEncoder.encode(string5, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                stringBuffer = new StringBuffer(string2);
                stringBuffer.append(unsupportedEncodingException.getMessage());
                this._systemLogger.log(Level.SEVERE, stringBuffer.toString(), (Throwable)unsupportedEncodingException);
            }
            stringBuffer = new StringBuffer(this._sAuthspUrl);
            stringBuffer.append("?as_url=").append(string7);
            stringBuffer.append("&rid=").append(string);
            stringBuffer.append("&user_attribute=").append(string6);
            stringBuffer.append("&a-select-server=").append(string4);
            if (this._sTwoFactorAuthSp != null && this._sTwoFactorAuthSpUrl != null && string5 != null && this._sTwoFactorAuthSpRetries != null) {
                stringBuffer.append("&tf_authsp=").append(this._sTwoFactorAuthSp);
                stringBuffer.append("&tf_url=").append(this._sTwoFactorAuthSpUrl);
                stringBuffer.append("&tf_retries=").append(this._sTwoFactorAuthSpRetries);
                stringBuffer.append("&tf_uid=").append(string5);
            }
            stringBuffer.append("&signature=").append(string3);
            hashtable.put("redirect_url", stringBuffer.toString());
        }
        catch (ASelectAuthSPException aSelectAuthSPException) {
            hashtable.put("result", aSelectAuthSPException.getMessage());
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "PKI", string2, "Could not compute authentication request due to internal error", (Throwable)exception);
            hashtable.put("result", "0003");
        }
        return hashtable;
    }

    public Hashtable verifyAuthenticationResponse(Hashtable hashtable) {
        String string = "verifyAuthenticationRequest(): ";
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        hashtable2.put("result", "0000");
        try {
            String string2 = (String)hashtable.get("rid");
            String string3 = (String)hashtable.get("my_url");
            String string4 = (String)hashtable.get("result_code");
            String string5 = (String)hashtable.get("a-select-server");
            String string6 = (String)hashtable.get("signature");
            if (string2 == null || string4 == null || string6 == null || string5 == null) {
                StringBuffer stringBuffer = new StringBuffer(string);
                stringBuffer.append("incorrect AuthSP response");
                this._systemLogger.log(Level.WARNING, stringBuffer.toString());
                hashtable2.put("result", "000a");
                return hashtable2;
            }
            StringBuffer stringBuffer = new StringBuffer(string3);
            stringBuffer.append("?authsp=");
            stringBuffer.append(this._sAuthsp);
            string3 = stringBuffer.toString();
            Hashtable hashtable3 = this._oSessionManager.getSessionContext(string2);
            if (hashtable3 == null) {
                stringBuffer = new StringBuffer(string);
                stringBuffer.append("session for RID: " + string2 + " is invalid.");
                hashtable2.put("result", "0070");
                this._systemLogger.log(Level.WARNING, stringBuffer.toString());
                return hashtable2;
            }
            String string7 = (String)hashtable3.get("user_id");
            String string8 = (String)hashtable3.get("organization");
            string6 = URLDecoder.decode(string6, "UTF-8");
            stringBuffer = new StringBuffer(string2);
            stringBuffer.append(string3);
            stringBuffer.append(string4);
            stringBuffer.append(string5);
            boolean bl = false;
            bl = CryptoEngine.getHandle().verifySignature(this._sAuthsp, URLDecoder.decode(stringBuffer.toString(), "UTF-8"), string6);
            if (!bl) {
                stringBuffer = new StringBuffer(string);
                stringBuffer.append("invalid signature in response from AuthSP");
                this._systemLogger.log(Level.INFO, stringBuffer.toString());
                hashtable2.put("result", "000a");
                return hashtable2;
            }
            if (string4.equalsIgnoreCase(PKI_NO_ERROR)) {
                this._authenticationLogger.log(new Object[]{"PKI", string7, hashtable.get("client_ip"), string8, (String)hashtable3.get("app_id"), "granted"});
                hashtable2.put("rid", string2);
                return hashtable2;
            }
            this._authenticationLogger.log(new Object[]{"PKI", string7, hashtable.get("client_ip"), string8, (String)hashtable3.get("app_id"), "denied"});
            if (string4.equalsIgnoreCase(PKI_INVALID_REQUEST)) {
                stringBuffer = new StringBuffer(string);
                stringBuffer.append("error from from AuthSP: ").append(string4);
                hashtable2.put("result", "0030");
            } else if (string4.equalsIgnoreCase(PKI_INTERNAL_SERVER_ERROR)) {
                stringBuffer = new StringBuffer(string);
                stringBuffer.append("error from from AuthSP: ").append(string4);
                hashtable2.put("result", "0001");
            } else {
                hashtable2.put("result", "PKI" + string4);
                stringBuffer = new StringBuffer(string);
                stringBuffer.append("error from from AuthSP: ").append(string4);
            }
            this._systemLogger.log(Level.INFO, stringBuffer.toString());
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(exception.getMessage());
            this._systemLogger.log(Level.INFO, stringBuffer.toString());
            hashtable2.put("result", "0003");
        }
        return hashtable2;
    }
}

