/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.saml11.websso;

import java.net.URLDecoder;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.request.handler.saml11.websso.IWebSSOProfile;
import org.aselect.server.session.SessionManager;
import org.aselect.server.tgt.TGTManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Base64;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAuthenticationStatement;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLSubject;

public abstract class AbstractWebSSOProfile
implements IWebSSOProfile {
    protected static final String SESSION_ID_PREFIX = "saml11_";
    protected ASelectSystemLogger _systemLogger;
    protected ASelectConfigManager _configManager;
    protected long _lAssertionExpireTime;
    protected SessionManager _oSessionManager;
    protected TGTManager _oTGTManager;
    protected String _sASelectServerID;
    private String _sAttributeNamespace;
    private boolean _bSendAttributeStatement;
    private static final String MODULE = "AbstractWebSSOProfile";
    private String _sID;

    public void init(Object object, long l, String string, boolean bl) throws ASelectException {
        String string2 = "init()";
        try {
            this._systemLogger = ASelectSystemLogger.getHandle();
            this._configManager = ASelectConfigManager.getHandle();
            this._lAssertionExpireTime = l;
            this._oSessionManager = SessionManager.getHandle();
            this._oTGTManager = TGTManager.getHandle();
            this._sAttributeNamespace = string;
            this._bSendAttributeStatement = bl;
            try {
                this._sID = this._configManager.getParam(object, "id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No config item 'id' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            Object object2 = null;
            try {
                object2 = this._configManager.getSection(null, "aselect");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No config section 'aselect' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._sASelectServerID = this._configManager.getParam(object2, "server_id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "No config item 'server_id' in section 'aselect' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not initialize", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public String getID() {
        return this._sID;
    }

    public abstract void process(Hashtable var1, HttpServletResponse var2, String var3, String var4) throws ASelectException;

    public abstract void destroy();

    protected SAMLAssertion createSAMLAssertion(String string, String string2, Hashtable hashtable, String string3, String string4, String string5, String string6) throws ASelectException {
        String string7 = "createSAMLAssertion()";
        SAMLAssertion sAMLAssertion = null;
        SAMLAttributeStatement sAMLAttributeStatement = null;
        SAMLAuthenticationStatement sAMLAuthenticationStatement = null;
        Date date = new Date();
        Vector<Object> vector = new Vector<Object>();
        Hashtable hashtable2 = null;
        try {
            String string8 = (String)hashtable.get("authsp");
            if (string8 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string7, "No 'authsp' item in response from 'verify_credentials'");
                throw new ASelectException("0001");
            }
            String string9 = (String)hashtable.get("app_id");
            if (string9 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string7, "No 'app_id' item in response from 'verify_credentials'");
                throw new ASelectException("0001");
            }
            sAMLAuthenticationStatement = this.generateSAMLAuthenticationStatement(string, string3, string4, date, string5, string6);
            vector.add(sAMLAuthenticationStatement);
            String string10 = (String)hashtable.get("attributes");
            if (string10 == null) {
                this._systemLogger.log(Level.FINE, MODULE, string7, "No parameter 'attributes' found");
            } else {
                hashtable2 = this.deserializeAttributes(string10);
                if (this._bSendAttributeStatement) {
                    sAMLAttributeStatement = this.generateSAMLAttributeStatement(string, hashtable2, string5);
                    vector.add(sAMLAttributeStatement);
                }
            }
            Date date2 = new Date(System.currentTimeMillis() + this._lAssertionExpireTime);
            sAMLAssertion = new SAMLAssertion(string6, date, date2, null, null, vector);
            this.storeSessionInformation(string, string2, string9, string8, hashtable2);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string7, "Could not create SAMLAssertion", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return sAMLAssertion;
    }

    private void storeSessionInformation(String string, String string2, String string3, String string4, Hashtable hashtable) throws ASelectException {
        String string5 = "storeAttributesSession()";
        try {
            String string6 = SESSION_ID_PREFIX + string;
            Hashtable hashtable2 = null;
            if (!this._oTGTManager.containsKey((Object)string6)) {
                Cloneable cloneable;
                hashtable2 = new Hashtable();
                if (string2 != null && string3 != null) {
                    cloneable = new Hashtable();
                    ((Hashtable)cloneable).put(string2, string3);
                    hashtable2.put("resources", cloneable);
                }
                if (string4 != null) {
                    cloneable = new Vector();
                    ((Vector)cloneable).add(string4);
                    hashtable2.put("authsps", cloneable);
                }
                if (string2 != null && hashtable != null) {
                    cloneable = new Hashtable();
                    ((Hashtable)cloneable).put(string2, hashtable);
                    hashtable2.put("attributes", cloneable);
                }
                this._oTGTManager.put((Object)string6, (Object)hashtable2);
            } else {
                Cloneable cloneable;
                hashtable2 = this._oTGTManager.getTGT(string6);
                if (string2 != null && string3 != null) {
                    cloneable = (Hashtable)hashtable2.get("resources");
                    ((Hashtable)cloneable).put(string2, string3);
                    hashtable2.put("resources", cloneable);
                }
                if (string4 != null) {
                    cloneable = (Vector)hashtable2.get("authsps");
                    ((Vector)cloneable).add(string4);
                    hashtable2.put("authsps", cloneable);
                }
                if (string2 != null && hashtable != null && (cloneable = (Hashtable)hashtable2.get("attributes")) != null) {
                    Hashtable hashtable3 = null;
                    hashtable3 = (Hashtable)((Hashtable)cloneable).get(string2);
                    if (hashtable3 == null) {
                        ((Hashtable)cloneable).put(string2, hashtable);
                    } else {
                        hashtable3.putAll(hashtable);
                        ((Hashtable)cloneable).put(string2, hashtable3);
                    }
                    hashtable2.put("attributes", cloneable);
                }
                this._oTGTManager.updateTGT(string6, hashtable2);
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string5, "Could not create SAMLAssertion", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private SAMLAuthenticationStatement generateSAMLAuthenticationStatement(String string, String string2, String string3, Date date, String string4, String string5) throws ASelectException {
        String string6 = "generateSAMLAuthenticationStatement()";
        SAMLAuthenticationStatement sAMLAuthenticationStatement = null;
        try {
            SAMLNameIdentifier sAMLNameIdentifier = new SAMLNameIdentifier(string, string5, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            SAMLSubject sAMLSubject = new SAMLSubject(sAMLNameIdentifier, null, null, null);
            sAMLSubject.addConfirmationMethod(string4);
            sAMLAuthenticationStatement = new SAMLAuthenticationStatement(sAMLSubject, date, string2, string3, null);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string6, "Could not create SAMLAuthenticationStatement", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return sAMLAuthenticationStatement;
    }

    private SAMLAttributeStatement generateSAMLAttributeStatement(String string, Hashtable hashtable, String string2) throws ASelectException {
        String string3 = "generateSAMLAttributeStatement()";
        SAMLAttributeStatement sAMLAttributeStatement = null;
        try {
            Object object;
            String string4;
            Vector<SAMLAttribute> vector = new Vector<SAMLAttribute>();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                string4 = (String)enumeration.nextElement();
                object = hashtable.get(string4);
                SAMLAttribute sAMLAttribute = this.createSAMLAttribute(string4, object);
                vector.add(sAMLAttribute);
            }
            string4 = new SAMLNameIdentifier(string, this._sASelectServerID, "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
            object = new SAMLSubject((SAMLNameIdentifier)string4, null, null, null);
            object.addConfirmationMethod(string2);
            sAMLAttributeStatement = new SAMLAttributeStatement(object, vector);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string3, "Could not create SAMLAttributeStatement", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return sAMLAttributeStatement;
    }

    private Hashtable deserializeAttributes(String string) throws ASelectException {
        String string2 = "deSerializeAttributes()";
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (string != null) {
            try {
                String string3 = new String(Base64.decode((String)string));
                String[] stringArray = string3.split("&");
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = stringArray[i].indexOf("=");
                    String string4 = "";
                    String string5 = "";
                    Vector<String> vector = null;
                    if (n > 0) {
                        string4 = URLDecoder.decode(stringArray[i].substring(0, n), "UTF-8");
                        string5 = URLDecoder.decode(stringArray[i].substring(n + 1), "UTF-8");
                        if (string4.endsWith("[]")) {
                            vector = (Vector<String>)hashtable.get(string4 = string4.substring(0, string4.length() - 2));
                            if (vector == null) {
                                vector = new Vector<String>();
                            }
                            vector.add(string5);
                        }
                    } else {
                        string4 = URLDecoder.decode(stringArray[i], "UTF-8");
                    }
                    if (vector != null) {
                        hashtable.put(string4, vector);
                        continue;
                    }
                    hashtable.put(string4, string5);
                }
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, MODULE, string2, "Error during deserialization of attributes", (Throwable)exception);
                throw new ASelectException("0001", (Throwable)exception);
            }
        }
        return hashtable;
    }

    private SAMLAttribute createSAMLAttribute(String string, Object object) throws ASelectException {
        String string2 = "generateSAMLAttribute()";
        SAMLAttribute sAMLAttribute = new SAMLAttribute();
        try {
            sAMLAttribute.setNamespace(this._sAttributeNamespace);
            sAMLAttribute.setName(string);
            if (object instanceof Vector) {
                Vector vector = (Vector)object;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    sAMLAttribute.addValue(enumeration.nextElement());
                }
            } else {
                sAMLAttribute.addValue(object);
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not create a SAML attribute object", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return sAMLAttribute;
    }
}

