/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.cross.selectorhandler;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.config.Version;
import org.aselect.server.cross.CrossASelectManager;
import org.aselect.server.cross.ISelectorHandler;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.session.SessionManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Utils;

public class SFSSelectorHandler
implements ISelectorHandler {
    private static final String MODULE = "SFSSelectorHandler";
    private String _sCrossRegexSelectorPage;
    private String _sFriendlyName;
    private ASelectConfigManager _configManager;
    private ASelectSystemLogger _systemLogger;
    private Hashtable _htSFSOrganizations = null;
    private Vector _vPatterns;
    private String _sMyServerId;
    private String _sMyOrgId;
    private static final String _sHtmlTemplateName = "sfscrossselect.html";
    private CrossASelectManager _crossAselectManager;
    private static final int COOKIE_AGE = 3153600;

    public void init(Object object) throws ASelectException {
        block28: {
            String string = "init()";
            try {
                Object object2;
                Object object3;
                Object object4;
                Object object5;
                this._systemLogger = ASelectSystemLogger.getHandle();
                this._configManager = ASelectConfigManager.getHandle();
                this._vPatterns = new Vector();
                Object object6 = null;
                Object object7 = null;
                this._htSFSOrganizations = new Hashtable();
                this._crossAselectManager = CrossASelectManager.getHandle();
                try {
                    object5 = this._configManager.getSection(null, "aselect");
                    this._sMyServerId = this._configManager.getParam(object5, "server_id");
                    this._sFriendlyName = this._configManager.getParam(object5, "organization_friendly_name");
                    this._sMyOrgId = this._configManager.getParam(object5, "organization");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Failed to load basic A-Select configuration", (Throwable)aSelectConfigException);
                    throw new ASelectConfigException("4009", (Throwable)aSelectConfigException);
                }
                try {
                    this.loadHTMLTemplates();
                }
                catch (ASelectException aSelectException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Failed to load SFS Cross Selector HTML templates.", (Throwable)aSelectException);
                    throw new ASelectConfigException("4009", (Throwable)aSelectException);
                }
                try {
                    object6 = this._configManager.getSection(object, "expressions");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'expressions' found.", (Throwable)aSelectConfigException);
                    throw new ASelectException("0001", (Throwable)aSelectConfigException);
                }
                try {
                    object7 = this._configManager.getSection(object6, "regex");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'regex found' in 'expressions'", (Throwable)aSelectConfigException);
                    throw new ASelectException("4011", (Throwable)aSelectConfigException);
                }
                while (object7 != null) {
                    object5 = new Hashtable();
                    object4 = null;
                    object3 = null;
                    try {
                        object4 = this._configManager.getParam(object7, "value");
                        object3 = this._configManager.getParam(object7, "remote_organization");
                    }
                    catch (ASelectConfigException aSelectConfigException) {
                        this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'value' or 'remote_organization' found.", (Throwable)aSelectConfigException);
                        throw new ASelectException("4011", (Throwable)aSelectConfigException);
                    }
                    try {
                        object2 = Pattern.compile((String)object4);
                        ((Hashtable)object5).put("pattern", object2);
                        ((Hashtable)object5).put("organization_id", object3);
                        this._vPatterns.add(object5);
                    }
                    catch (Exception exception) {
                        this._systemLogger.log(Level.WARNING, MODULE, string, "Pattern '" + (String)object4 + "' is not a valid regex", (Throwable)exception);
                        throw new ASelectConfigException("4011", (Throwable)exception);
                    }
                    object7 = this._configManager.getNextSection(object7);
                }
                object5 = null;
                try {
                    object5 = this._configManager.getSection(null, "sfs");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "No extra sfs configuration found, skipping.");
                }
                if (object5 == null) break block28;
                object4 = null;
                try {
                    object4 = this._configManager.getSection(object5, "idp");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.INFO, MODULE, string, "No \"idp\" entries configured in \"sfs\" section.");
                    object4 = null;
                }
                while (object4 != null) {
                    object3 = new Hashtable();
                    object2 = this._configManager.getParam(object4, "friendly_name");
                    ((Hashtable)object3).put("friendly_name", object2);
                    String string2 = this._configManager.getParam(object4, "organization");
                    ((Hashtable)object3).put("organization", string2);
                    String string3 = null;
                    try {
                        string3 = this._configManager.getParam(object4, "type");
                        if (string3 == null) {
                            string3 = "aselect";
                        }
                    }
                    catch (Exception exception) {
                        string3 = "aselect";
                    }
                    ((Hashtable)object3).put("type", string3);
                    if (string3.equals("aselect")) {
                        ((Hashtable)object3).put("relay", this._configManager.getParam(object4, "relay"));
                        if (!string2.equals(this._sMyOrgId)) {
                            this._htSFSOrganizations.put(object2, object3);
                        }
                    }
                    object4 = this._configManager.getNextSection(object4);
                }
            }
            catch (ASelectException aSelectException) {
                throw aSelectException;
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize the SFS selector handler", (Throwable)exception);
                throw new ASelectException("0001", (Throwable)exception);
            }
        }
    }

    private Hashtable getHomeOrganization(String string) {
        Hashtable<String, String> hashtable = null;
        Enumeration enumeration = this._htSFSOrganizations.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)this._htSFSOrganizations.get(string2);
            String string3 = (String)hashtable2.get("organization");
            if (!string3.equals(string)) continue;
            hashtable = new Hashtable<String, String>();
            String string4 = (String)hashtable2.get("relay");
            if (string4 != null) {
                hashtable.put("organization_id", string4);
            } else {
                hashtable.put("organization_id", string3);
            }
            hashtable.put("home_organization", string);
            break;
        }
        return hashtable;
    }

    public Hashtable getRemoteServerId(Hashtable hashtable, HttpServletResponse httpServletResponse, PrintWriter printWriter) throws ASelectException {
        Object object;
        String string = "getRemoteServerId()";
        String string2 = null;
        boolean bl = false;
        Hashtable<String, String> hashtable2 = null;
        String string3 = (String)hashtable.get("user_id");
        String string4 = (String)hashtable.get("remote_server");
        String string5 = (String)hashtable.get("home_organization");
        if (string3 != null && !string3.trim().equals("")) {
            try {
                for (int i = 0; i < this._vPatterns.size() && !bl; ++i) {
                    object = (Hashtable)this._vPatterns.get(i);
                    Pattern pattern = (Pattern)((Hashtable)object).get("pattern");
                    Matcher matcher = pattern.matcher(string3);
                    bl = matcher.matches();
                    if (!bl) continue;
                    String string6 = (String)((Hashtable)object).get("organization_id");
                    hashtable2 = new Hashtable<String, String>();
                    hashtable2.put("organization_id", string6);
                    hashtable2.put("user_id", string3);
                }
                if (hashtable2 == null) {
                    string2 = "4010";
                }
            }
            catch (Exception exception) {
                string2 = "4010";
                this._systemLogger.log(Level.WARNING, MODULE, string, "get remote server id failed. ", (Throwable)exception);
            }
        } else if (string5 != null && !string5.trim().equals("")) {
            hashtable2 = this.getHomeOrganization(string5);
            if (hashtable2 != null) {
                if (string3 != null && !string3.trim().equals("")) {
                    hashtable2.put("user_id", string3);
                }
            } else {
                string2 = "0034";
            }
        } else if (string4 != null && !string4.trim().equals("")) {
            object = this._crossAselectManager.getRemoteServers();
            if (((Hashtable)object).containsKey(string4.trim())) {
                hashtable2 = new Hashtable<String, String>();
                hashtable2.put("organization_id", string4);
                Cookie cookie = new Cookie("aselect_home_idp", string4);
                cookie.setMaxAge(3153600);
                httpServletResponse.addCookie(cookie);
            } else {
                hashtable2 = this.getHomeOrganization(string4);
                if (hashtable2 != null) {
                    if (string3 != null && !string3.trim().equals("")) {
                        hashtable2.put("user_id", string3);
                    }
                } else {
                    string2 = "0034";
                }
            }
        }
        if (hashtable2 == null) {
            object = (String)hashtable.get("aselect_home_idp");
            this.showAuthenticationForm(hashtable, printWriter, string2, (String)object);
        }
        return hashtable2;
    }

    private void loadHTMLTemplates() throws ASelectException {
        String string = this._configManager.getWorkingdir() + File.separator + "conf" + File.separator + "html" + File.separator;
        this._sCrossRegexSelectorPage = this.loadHTMLTemplate(string + _sHtmlTemplateName);
        this._sCrossRegexSelectorPage = Utils.replaceString((String)this._sCrossRegexSelectorPage, (String)"[version]", (String)Version.getVersion());
        this._sCrossRegexSelectorPage = Utils.replaceString((String)this._sCrossRegexSelectorPage, (String)"[organization_friendly]", (String)this._sFriendlyName);
    }

    private String loadHTMLTemplate(String string) throws ASelectException {
        String string2 = new String();
        BufferedReader bufferedReader = null;
        String string3 = "loadHTMLTemplate()";
        try {
            String string4;
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while ((string4 = bufferedReader.readLine()) != null) {
                string2 = string2 + string4 + "\n";
            }
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not load '");
            stringBuffer.append(string).append("'HTML template.");
            this._systemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString(), (Throwable)exception);
            throw new ASelectException("4009", (Throwable)exception);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                StringBuffer stringBuffer = new StringBuffer("Could not close '");
                stringBuffer.append(string).append("' FileInputStream.");
                this._systemLogger.log(Level.WARNING, MODULE, string3, stringBuffer.toString(), (Throwable)exception);
            }
        }
        return string2;
    }

    private void showAuthenticationForm(Hashtable hashtable, PrintWriter printWriter, String string, String string2) throws ASelectException {
        String string3 = "showAuthenticationForm()";
        try {
            String string4 = (String)hashtable.get("rid");
            if (string4 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "parameter 'rid' not found in service request");
                throw new ASelectException("0030");
            }
            String string5 = (String)hashtable.get("my_url");
            if (string5 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string3, "parameter 'my_url' not found in service request");
                throw new ASelectException("0030");
            }
            String string6 = this._sCrossRegexSelectorPage;
            string6 = Utils.replaceString((String)string6, (String)"[rid]", (String)string4);
            string6 = Utils.replaceString((String)string6, (String)"[aselect_url]", (String)string5);
            string6 = Utils.replaceString((String)string6, (String)"[request]", (String)"cross_login");
            string6 = Utils.replaceString((String)string6, (String)"[a-select-server]", (String)this._sMyServerId);
            string6 = string != null ? Utils.replaceString((String)string6, (String)"[error_message]", (String)this._configManager.getErrorMessage(string)) : Utils.replaceString((String)string6, (String)"[error_message]", (String)"");
            StringBuffer stringBuffer = new StringBuffer((String)hashtable.get("my_url")).append("?request=error").append("&result_code=").append("0040").append("&a-select-server=").append(this._sMyServerId).append("&rid=").append(string4);
            string6 = Utils.replaceString((String)string6, (String)"[cancel]", (String)stringBuffer.toString());
            string6 = Utils.replaceString((String)string6, (String)"[cross_request]", (String)"cross_login");
            Hashtable hashtable2 = this._crossAselectManager.getRemoteServers();
            string6 = Utils.replaceString((String)string6, (String)"[available_remote_servers]", (String)this.getRemoteServerHTML(hashtable2, string2));
            Hashtable hashtable3 = SessionManager.getHandle().getSessionContext(string4);
            if (hashtable3 != null) {
                string6 = this._configManager.updateTemplate(string6, hashtable3);
            }
            printWriter.println(string6);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string3, "Could not show select form", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    private String getRemoteServerHTML(Hashtable hashtable, String string) {
        Object object;
        String string2;
        Object object2;
        String string3;
        String string4 = "getRemoteServerHTML";
        String string5 = new String();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Enumeration enumeration = this._htSFSOrganizations.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            object2 = (Hashtable)this._htSFSOrganizations.get(string3);
            string2 = (String)((Hashtable)object2).get("organization");
            hashtable2.put(string3, string2);
        }
        object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            string2 = (String)object2.nextElement();
            string3 = (String)hashtable.get(string2);
            try {
                if (!hashtable2.containsKey(string3)) {
                    object = CrossASelectManager.getHandle().getRemoteParam(string2, "display");
                    if (object != null && !((String)object).equalsIgnoreCase("true")) continue;
                    hashtable2.put(string3, string2);
                    continue;
                }
                this._systemLogger.log(Level.CONFIG, MODULE, string4, "Server identification conflict in config: " + string3);
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, MODULE, string4, "Could not show select form", (Throwable)exception);
            }
        }
        object = hashtable2.keys();
        while (object.hasMoreElements()) {
            string3 = (String)object.nextElement();
            string2 = (String)hashtable2.get(string3);
            if (string != null && string.equals(string2)) {
                string5 = string5 + "<OPTION VALUE='" + string2 + "' selected=\"selected\">" + string3 + "</OPTION>\n";
                continue;
            }
            string5 = string5 + "<OPTION VALUE='" + string2 + "'>" + string3 + "</OPTION>\n";
        }
        return string5;
    }
}

