/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.shibboleth;

import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.application.ApplicationManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.request.RequestState;
import org.aselect.server.request.handler.AbstractRequestHandler;
import org.aselect.system.communication.client.IClientCommunicator;
import org.aselect.system.communication.client.raw.RawCommunicator;
import org.aselect.system.communication.client.soap11.SOAP11Communicator;
import org.aselect.system.communication.client.soap12.SOAP12Communicator;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.logging.SystemLogger;

public class ShibbolethAuthenticationProfile
extends AbstractRequestHandler {
    private static final String MODULE = "ShibbolethAuthenticationProfile";
    private static final String SESSION_ID_PREFIX = "saml11_";
    private IClientCommunicator _oClientCommunicator;
    private Hashtable _htApplications;
    private String _sASelectServerID;
    private String _sResponseURI;
    private long _lTimeOffset;

    public void init(ServletConfig servletConfig, Object object) throws ASelectException {
        String string = "init()";
        try {
            Object object2;
            super.init(servletConfig, object);
            String string2 = null;
            try {
                string2 = this._configManager.getParam(object, "clientcommunicator");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'clientcommunicator' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._sResponseURI = this._configManager.getParam(object, "response_uri");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'response_uri' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            Object object3 = null;
            try {
                object3 = this._configManager.getSection(object, "time");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'time' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            String string3 = null;
            try {
                string3 = this._configManager.getParam(object3, "offset");
                this._lTimeOffset = Long.parseLong(string3);
                this._lTimeOffset *= 1000L;
            }
            catch (NumberFormatException numberFormatException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Configured time offset isn't a number: " + string3, (Throwable)numberFormatException);
                throw new ASelectException("4009", (Throwable)numberFormatException);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'offset' found in section 'time'", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            if (this._lTimeOffset < 1L) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Config item 'offset' in 'time' section must be higher than 0 and not: " + string3);
                throw new ASelectException("4009");
            }
            this._htApplications = new Hashtable();
            Object object4 = null;
            try {
                object4 = this._configManager.getSection(object, "providers");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'providers' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            Object object5 = null;
            try {
                object5 = this._configManager.getSection(object4, "provider");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No config item 'provider' in section 'providers' found, not using any application id to provider id mapping", (Throwable)aSelectConfigException);
            }
            while (object5 != null) {
                object2 = null;
                try {
                    object2 = this._configManager.getParam(object5, "id");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'id' found in 'provider' section", (Throwable)aSelectConfigException);
                    throw new ASelectException("4009", (Throwable)aSelectConfigException);
                }
                String string4 = null;
                try {
                    string4 = this._configManager.getParam(object5, "app_id");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'app_id' found in 'provider' section", (Throwable)aSelectConfigException);
                    throw new ASelectException("4009", (Throwable)aSelectConfigException);
                }
                if (this._htApplications.containsKey(object2)) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Configured provider id isn't unique: " + (String)object2);
                    throw new ASelectException("4009");
                }
                this._htApplications.put(object2, string4);
                object5 = this._configManager.getNextSection(object5);
            }
            object2 = null;
            try {
                object2 = this._configManager.getSection(null, "aselect");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'aselect' found", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            try {
                this._sASelectServerID = this._configManager.getParam(object2, "server_id");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'server_id' found in 'aselect' section", (Throwable)aSelectConfigException);
                throw new ASelectException("4009", (Throwable)aSelectConfigException);
            }
            if (string2 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'clientcommunicator' found");
                throw new ASelectException("4009");
            }
            if (string2.equalsIgnoreCase("soap11")) {
                this._oClientCommunicator = new SOAP11Communicator("ASelect", (SystemLogger)this._systemLogger);
            } else if (string2.equalsIgnoreCase("soap12")) {
                this._oClientCommunicator = new SOAP12Communicator("ASelect", (SystemLogger)this._systemLogger);
            } else if (string2.equalsIgnoreCase("raw")) {
                this._oClientCommunicator = new RawCommunicator((SystemLogger)this._systemLogger);
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public RequestState process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "process()";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            String string2;
            Object object;
            String string3 = httpServletRequest.getParameter("providerId");
            if (string3 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Missing request parameter 'providerId'");
                throw new ASelectException("0030");
            }
            hashtable.put("providerId", string3);
            String string4 = httpServletRequest.getParameter("shire");
            if (string4 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Missing request parameter 'shire'");
                throw new ASelectException("0030");
            }
            hashtable.put("shire", string4);
            String string5 = httpServletRequest.getParameter("target");
            if (string5 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Missing request parameter 'target'");
                throw new ASelectException("0030");
            }
            hashtable.put("target", string5);
            String string6 = httpServletRequest.getParameter("time");
            if (string6 == null) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Missing optional request parameter 'time'");
            } else {
                long l = 0L;
                try {
                    long l2 = Long.parseLong(string6);
                    l = System.currentTimeMillis() - (l2 *= 1000L);
                    if (l < 0L) {
                        l *= -1L;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Request item 'time' isn't a number: " + string6);
                    throw new ASelectException("0030", (Throwable)numberFormatException);
                }
                if (l > this._lTimeOffset) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("Request not accepted; Time offset is '");
                    stringBuffer.append(l);
                    stringBuffer.append("' , it may be: ");
                    stringBuffer.append(this._lTimeOffset);
                    this._systemLogger.log(Level.FINE, MODULE, string, stringBuffer.toString());
                    throw new ASelectException("0030");
                }
                hashtable.put("time", string6);
            }
            String string7 = null;
            string7 = (String)this._htApplications.get(string3);
            if (string7 == null) {
                this._systemLogger.log(Level.FINE, MODULE, string, "No mapping found for app_id: " + string3);
                string7 = string3;
            }
            hashtable.put("app_id", string7);
            String string8 = httpServletRequest.getRequestURL().toString();
            String string9 = httpServletRequest.getContextPath();
            String string10 = httpServletRequest.getServletPath();
            int n = string8.indexOf(string9);
            String string11 = string8.substring(0, n);
            StringBuffer stringBuffer = new StringBuffer(string11);
            stringBuffer.append(string9);
            stringBuffer.append(string10);
            String string12 = stringBuffer.toString();
            stringBuffer.append(this._sResponseURI);
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            hashtable2.put("request", "authenticate");
            hashtable2.put("app_id", string7);
            hashtable2.put("app_url", stringBuffer.toString());
            hashtable2.put("a-select-server", this._sASelectServerID);
            String string13 = httpServletRequest.getPathInfo();
            if (!string13.endsWith("shib-idp")) {
                object = string13.split("/");
                string2 = object[((String[])object).length - 1];
                this._systemLogger.log(Level.FINER, MODULE, string, "set remote organization to: " + string2);
                if (string2 != null && string2.length() > 0) {
                    hashtable2.put("remote_organization", string2);
                }
            }
            if (ApplicationManager.getHandle().isSigningRequired()) {
                CryptoEngine.getHandle().signRequest(hashtable2);
            }
            object = null;
            try {
                object = this._oClientCommunicator.sendMessage(hashtable2, string12);
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Could not send authentication request to: " + string12);
                throw new ASelectException("4006");
            }
            string2 = (String)((Hashtable)object).get("result_code");
            if (!string2.equals("0000")) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Authentication request was not succesful, server returned 'result_code': " + string2);
                throw new ASelectException("4006");
            }
            string12 = (String)((Hashtable)object).get("as_url");
            String string14 = (String)((Hashtable)object).get("rid");
            hashtable.put("as_url", string12);
            this._oSessionManager.createSession(SESSION_ID_PREFIX + string14, hashtable);
            StringBuffer stringBuffer2 = new StringBuffer(string12);
            stringBuffer2.append("&rid=");
            stringBuffer2.append(string14);
            stringBuffer2.append("&a-select-server=");
            stringBuffer2.append(this._sASelectServerID);
            httpServletResponse.sendRedirect(stringBuffer2.toString());
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not process", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return new RequestState(null);
    }

    public void destroy() {
    }
}

