/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.attributes.requestors.flatfile;

import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.server.attributes.requestors.GenericAttributeRequestor;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectAttributesException;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMResource;

public class FlatFileAttributeRequestor
extends GenericAttributeRequestor {
    private static final String MODULE = "FlatFileAttributeRequestor";
    private ConfigManager _oFlatFileManager;
    private Hashtable _htGlobalAttributes;

    public void init(Object object) throws ASelectException {
        String string = "init()";
        SAMResource sAMResource = null;
        Object object2 = null;
        try {
            String string2 = null;
            try {
                string2 = this._configManager.getParam(object, "resourcegroup");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No valid 'resourcegroup' config item found", (Throwable)aSelectConfigException);
                throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
            }
            try {
                sAMResource = this._samAgent.getActiveResource(string2);
            }
            catch (ASelectSAMException aSelectSAMException) {
                StringBuffer stringBuffer = new StringBuffer("No active resource found in attributes resourcegroup: ");
                stringBuffer.append(string2);
                this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), (Throwable)aSelectSAMException);
                throw aSelectSAMException;
            }
            object2 = sAMResource.getAttributes();
            String string3 = null;
            try {
                string3 = this._configManager.getParam(object2, "file");
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'file' found", (Throwable)aSelectException);
                throw new ASelectAttributesException("4009", (Throwable)aSelectException);
            }
            File file = new File(string3);
            if (!file.exists()) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Configured 'file' item doesn't exist: " + string3);
                throw new ASelectAttributesException("4009");
            }
            this._oFlatFileManager = new ConfigManager();
            this._oFlatFileManager.init(string3, (SystemLogger)this._systemLogger);
            Object object3 = null;
            try {
                object3 = this._oFlatFileManager.getSection(null, "global");
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No config section 'global' found", (Throwable)aSelectException);
                throw new ASelectAttributesException("4009");
            }
            Object object4 = null;
            try {
                object4 = this._oFlatFileManager.getSection(object3, "attribute");
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.CONFIG, MODULE, string, "No global attributes configured, not using global attributes", (Throwable)aSelectException);
            }
            this._htGlobalAttributes = this.readAttributes(object4);
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Unable to generate flatfile handle", (Throwable)exception);
            throw new ASelectAttributesException("0001", (Throwable)exception);
        }
    }

    public Hashtable getAttributes(Hashtable hashtable, Vector vector) throws ASelectAttributesException {
        Hashtable hashtable2 = new Hashtable();
        String string = "getAttributes()";
        try {
            hashtable2.putAll(this._htGlobalAttributes);
            String string2 = (String)hashtable.get("uid");
            if (string2 == null) {
                this._systemLogger.log(Level.FINE, MODULE, string, "No user in attribute flatfile with id: " + string2);
                return hashtable2;
            }
            Object object = null;
            try {
                object = this._oFlatFileManager.getSection(null, "user", "id=" + string2);
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.FINE, MODULE, string, "No config section 'user' found", (Throwable)aSelectException);
                this._systemLogger.log(Level.FINE, MODULE, string, "No attributes found for user with id: " + string2);
                return hashtable2;
            }
            Object object2 = null;
            try {
                object2 = this._oFlatFileManager.getSection(object, "attribute");
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.FINE, MODULE, string, "Not one config section 'attribute' found", (Throwable)aSelectException);
                this._systemLogger.log(Level.FINE, MODULE, string, "No attributes found for user with id: " + string2);
                return hashtable2;
            }
            hashtable2.putAll(this.readAttributes(object2));
        }
        catch (ASelectAttributesException aSelectAttributesException) {
            throw aSelectAttributesException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Unable to resolve attributes", (Throwable)exception);
            throw new ASelectAttributesException("0001", (Throwable)exception);
        }
        return hashtable2;
    }

    public void destroy() {
    }

    private Hashtable readAttributes(Object object) throws ASelectException {
        String string = "readAttributes()";
        Hashtable hashtable = new Hashtable();
        try {
            while (object != null) {
                String string2 = null;
                try {
                    string2 = this._oFlatFileManager.getParam(object, "id");
                }
                catch (ASelectException aSelectException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'id' in 'attribute' section found", (Throwable)aSelectException);
                    throw new ASelectAttributesException("0001", (Throwable)aSelectException);
                }
                Object object2 = null;
                try {
                    object2 = this._oFlatFileManager.getSection(object, "value");
                }
                catch (ASelectException aSelectException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Not one config section 'value' in 'attribute' section found", (Throwable)aSelectException);
                    throw new ASelectAttributesException("0001", (Throwable)aSelectException);
                }
                Vector<String> vector = new Vector<String>();
                while (object2 != null) {
                    String string3 = null;
                    try {
                        string3 = this._oFlatFileManager.getParam(object2, "id");
                    }
                    catch (ASelectException aSelectException) {
                        this._systemLogger.log(Level.WARNING, MODULE, string, "No config item 'value' in section 'attribute' found", (Throwable)aSelectException);
                        throw new ASelectAttributesException("4009", (Throwable)aSelectException);
                    }
                    vector.add(string3);
                    object2 = this._oFlatFileManager.getNextSection(object2);
                }
                if (hashtable.containsKey(string2)) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Attribute isn't unique: " + string2);
                    throw new ASelectAttributesException("4009");
                }
                if (vector.size() > 1) {
                    hashtable.put(string2, vector);
                } else {
                    hashtable.put(string2, vector.firstElement());
                }
                object = this._oFlatFileManager.getNextSection(object);
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Unable to resolve attributes", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return hashtable;
    }
}

