/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.utils.Constants;
import org.apache.xml.security.utils.I18n;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    private XMLUtils() {
    }

    public static void getSet(Node rootNode, Set result, Node exclude, boolean com) {
        if (exclude != null && XMLUtils.isDescendantOrSelf(exclude, rootNode)) {
            return;
        }
        XMLUtils.getSetRec(rootNode, result, exclude, com);
    }

    static final void getSetRec(Node rootNode, Set result, Node exclude, boolean com) {
        if (rootNode == exclude) {
            return;
        }
        switch (rootNode.getNodeType()) {
            case 1: {
                result.add(rootNode);
                Element el = (Element)rootNode;
                if (el.hasAttributes()) {
                    NamedNodeMap nl = ((Element)rootNode).getAttributes();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        result.add(nl.item(i));
                    }
                }
            }
            case 9: {
                for (Node r = rootNode.getFirstChild(); r != null; r = r.getNextSibling()) {
                    if (r.getNodeType() == 3) {
                        result.add(r);
                        while (r != null && r.getNodeType() == 3) {
                            r = r.getNextSibling();
                        }
                        if (r == null) {
                            return;
                        }
                    }
                    XMLUtils.getSetRec(r, result, exclude, com);
                }
                return;
            }
            case 8: {
                if (com) {
                    result.add(rootNode);
                }
                return;
            }
            case 10: {
                return;
            }
        }
        result.add(rootNode);
    }

    public static void outputDOM(Node contextNode, OutputStream os) {
        XMLUtils.outputDOM(contextNode, os, false);
    }

    public static void outputDOM(Node contextNode, OutputStream os, boolean addPreamble) {
        try {
            if (addPreamble) {
                os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
            }
            os.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(contextNode));
        }
        catch (IOException ex) {
        }
        catch (InvalidCanonicalizerException ex) {
            ex.printStackTrace();
        }
        catch (CanonicalizationException ex) {
            ex.printStackTrace();
        }
    }

    public static void outputDOMc14nWithComments(Node contextNode, OutputStream os) {
        try {
            os.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(contextNode));
        }
        catch (IOException ex) {
        }
        catch (InvalidCanonicalizerException ex) {
        }
        catch (CanonicalizationException canonicalizationException) {
            // empty catch block
        }
    }

    public static String getFullTextChildrenFromElement(Element element) {
        StringBuffer sb = new StringBuffer();
        NodeList children = element.getChildNodes();
        int iMax = children.getLength();
        for (int i = 0; i < iMax; ++i) {
            Node curr = children.item(i);
            if (curr.getNodeType() != 3) continue;
            sb.append(((Text)curr).getData());
        }
        return sb.toString();
    }

    public static Element createElementInSignatureSpace(Document doc, String elementName) {
        if (doc == null) {
            throw new RuntimeException("Document is null");
        }
        String ds = Constants.getSignatureSpecNSprefix();
        if (ds == null || ds.length() == 0) {
            Element element = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", elementName);
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://www.w3.org/2000/09/xmldsig#");
            return element;
        }
        Element element = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", ds + ":" + elementName);
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + ds, "http://www.w3.org/2000/09/xmldsig#");
        return element;
    }

    public static boolean elementIsInSignatureSpace(Element element, String localName) {
        if (element == null || !"http://www.w3.org/2000/09/xmldsig#".equals(element.getNamespaceURI())) {
            return false;
        }
        return element.getLocalName().equals(localName);
    }

    public static boolean elementIsInEncryptionSpace(Element element, String localName) {
        if (element == null || !"http://www.w3.org/2001/04/xmlenc#".equals(element.getNamespaceURI())) {
            return false;
        }
        return element.getLocalName().equals(localName);
    }

    public static Document getOwnerDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        try {
            return node.getOwnerDocument();
        }
        catch (NullPointerException npe) {
            throw new NullPointerException(I18n.translate("endorsed.jdk1.4.0") + " Original message was \"" + npe.getMessage() + "\"");
        }
    }

    public static Document getOwnerDocument(Set xpathNodeSet) {
        NullPointerException npe = null;
        Iterator iterator = xpathNodeSet.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            short nodeType = node.getNodeType();
            if (nodeType == 9) {
                return (Document)node;
            }
            try {
                if (nodeType == 2) {
                    return ((Attr)node).getOwnerElement().getOwnerDocument();
                }
                return node.getOwnerDocument();
            }
            catch (NullPointerException e) {
                npe = e;
            }
        }
        throw new NullPointerException(I18n.translate("endorsed.jdk1.4.0") + " Original message was \"" + (npe == null ? "" : npe.getMessage()) + "\"");
    }

    public static Element createDSctx(Document doc, String prefix, String namespace) {
        if (prefix == null || prefix.trim().length() == 0) {
            throw new IllegalArgumentException("You must supply a prefix");
        }
        Element ctx = doc.createElementNS(null, "namespaceContext");
        ctx.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix.trim(), namespace);
        return ctx;
    }

    public static void addReturnToElement(Element e) {
        Document doc = e.getOwnerDocument();
        e.appendChild(doc.createTextNode("\n"));
    }

    public static Set convertNodelistToSet(NodeList xpathNodeSet) {
        if (xpathNodeSet == null) {
            return new HashSet();
        }
        int length = xpathNodeSet.getLength();
        HashSet<Node> set = new HashSet<Node>(length);
        for (int i = 0; i < length; ++i) {
            set.add(xpathNodeSet.item(i));
        }
        return set;
    }

    public static void circumventBug2650(Document doc) {
        Element documentElement = doc.getDocumentElement();
        Attr xmlnsAttr = documentElement.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        if (xmlnsAttr == null) {
            documentElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
        XMLUtils.circumventBug2650recurse(doc);
    }

    private static void circumventBug2650recurse(Node node) {
        Element element;
        if (node.getNodeType() == 1 && (element = (Element)node).hasChildNodes() && element.hasAttributes()) {
            NamedNodeMap attributes = element.getAttributes();
            int attributesLength = attributes.getLength();
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (child.getNodeType() != 1) continue;
                Element childElement = (Element)child;
                for (int i = 0; i < attributesLength; ++i) {
                    Attr currentAttr = (Attr)attributes.item(i);
                    if (!"http://www.w3.org/2000/xmlns/".equals(currentAttr.getNamespaceURI()) || childElement.hasAttributeNS("http://www.w3.org/2000/xmlns/", currentAttr.getLocalName())) continue;
                    childElement.setAttributeNS("http://www.w3.org/2000/xmlns/", currentAttr.getName(), currentAttr.getNodeValue());
                }
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            switch (child.getNodeType()) {
                case 1: 
                case 5: 
                case 9: {
                    XMLUtils.circumventBug2650recurse(child);
                }
            }
        }
    }

    public static Element selectDsNode(Node sibling, String nodeName, int number) {
        while (sibling != null) {
            if (nodeName.equals(sibling.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(sibling.getNamespaceURI())) {
                if (number == 0) {
                    return (Element)sibling;
                }
                --number;
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Element selectXencNode(Node sibling, String nodeName, int number) {
        while (sibling != null) {
            if (nodeName.equals(sibling.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(sibling.getNamespaceURI())) {
                if (number == 0) {
                    return (Element)sibling;
                }
                --number;
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Text selectDsNodeText(Node sibling, String nodeName, int number) {
        Node n = XMLUtils.selectDsNode(sibling, nodeName, number);
        if (n == null) {
            return null;
        }
        for (n = n.getFirstChild(); n != null && n.getNodeType() != 3; n = n.getNextSibling()) {
        }
        return (Text)n;
    }

    public static Text selectNodeText(Node sibling, String uri, String nodeName, int number) {
        Node n = XMLUtils.selectNode(sibling, uri, nodeName, number);
        if (n == null) {
            return null;
        }
        for (n = n.getFirstChild(); n != null && n.getNodeType() != 3; n = n.getNextSibling()) {
        }
        return (Text)n;
    }

    public static Element selectNode(Node sibling, String uri, String nodeName, int number) {
        while (sibling != null) {
            if (nodeName.equals(sibling.getLocalName()) && uri.equals(sibling.getNamespaceURI())) {
                if (number == 0) {
                    return (Element)sibling;
                }
                --number;
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Element[] selectDsNodes(Node sibling, String nodeName) {
        return XMLUtils.selectNodes(sibling, "http://www.w3.org/2000/09/xmldsig#", nodeName);
    }

    public static Element[] selectNodes(Node sibling, String uri, String nodeName) {
        int size = 20;
        Element[] a = new Element[size];
        int curr = 0;
        while (sibling != null) {
            if (nodeName.equals(sibling.getLocalName()) && uri.equals(sibling.getNamespaceURI())) {
                a[curr++] = (Element)sibling;
                if (size <= curr) {
                    int cursize = size << 2;
                    Element[] cp = new Element[cursize];
                    System.arraycopy(a, 0, cp, 0, size);
                    a = cp;
                    size = cursize;
                }
            }
            sibling = sibling.getNextSibling();
        }
        Element[] af = new Element[curr];
        System.arraycopy(a, 0, af, 0, curr);
        return af;
    }

    public static Set excludeNodeFromSet(Node signatureElement, Set inputSet) {
        HashSet<Node> resultSet = new HashSet<Node>();
        Iterator iterator = inputSet.iterator();
        while (iterator.hasNext()) {
            Node inputNode = (Node)iterator.next();
            if (XMLUtils.isDescendantOrSelf(signatureElement, inputNode)) continue;
            resultSet.add(inputNode);
        }
        return resultSet;
    }

    static boolean isDescendantOrSelf(Node ctx, Node descendantOrSelf) {
        if (ctx == descendantOrSelf) {
            return true;
        }
        Node parent = descendantOrSelf;
        while (parent != null) {
            if (parent == ctx) {
                return true;
            }
            if (parent.getNodeType() == 2) {
                parent = ((Attr)parent).getOwnerElement();
                continue;
            }
            parent = parent.getParentNode();
        }
        return false;
    }
}

