/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.transforms.params.XPath2FilterContainer04;
import org.apache.xml.security.utils.CachedXPathAPIHolder;
import org.apache.xml.security.utils.CachedXPathFuncHereAPI;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xpath.CachedXPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TransformXPath2Filter04
extends TransformSpi {
    static Log log = LogFactory.getLog((String)TransformXPath2Filter04.class.getName());
    public static final String implementedTransformURI = "http://www.w3.org/2002/04/xmldsig-filter2";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws TransformationException {
        CachedXPathAPIHolder.setDoc(this._transformObject.getElement().getOwnerDocument());
        try {
            Iterator inputSetIterator;
            Set inputSet = input.getNodeSet(true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("perform xfilter2 on " + inputSet.size() + " nodes"));
            }
            CachedXPathFuncHereAPI xPathFuncHereAPI = new CachedXPathFuncHereAPI(CachedXPathAPIHolder.getCachedXPathAPI());
            CachedXPathAPI myXPathAPI = new CachedXPathAPI(CachedXPathAPIHolder.getCachedXPathAPI());
            if (inputSet.size() == 0) {
                Object[] exArgs = new Object[]{"input node set contains no nodes"};
                throw new TransformationException("empty", exArgs);
            }
            Element xpathElement = XMLUtils.selectNode(this._transformObject.getElement().getFirstChild(), implementedTransformURI, "XPath", 0);
            if (xpathElement == null) {
                Object[] exArgs = new Object[]{"dsig-xpath:XPath", "Transform"};
                throw new TransformationException("xml.WrongContent", exArgs);
            }
            XPath2FilterContainer04 xpathContainer = XPath2FilterContainer04.newInstance(xpathElement, input.getSourceURI());
            Document doc = this._transformObject.getElement().getOwnerDocument();
            NodeList subtreeRoots = xPathFuncHereAPI.selectNodeList(doc, xpathContainer.getXPathFilterTextNode(), CachedXPathFuncHereAPI.getStrFromNode(xpathContainer.getXPathFilterTextNode()), xpathContainer.getElement());
            if (log.isDebugEnabled()) {
                log.debug((Object)("subtreeRoots contains " + subtreeRoots.getLength() + " nodes"));
            }
            HashSet<Node> selectedNodes = new HashSet<Node>();
            for (int i = 0; i < subtreeRoots.getLength(); ++i) {
                Node currentRootNode = subtreeRoots.item(i);
                short currentRootNodeType = currentRootNode.getNodeType();
                if (currentRootNodeType == 1 || currentRootNodeType == 9) {
                    NodeList nodesInSubtree = myXPathAPI.selectNodeList(currentRootNode, "(.//. | .//@* | .//namespace::*)");
                    int jMax = nodesInSubtree.getLength();
                    for (int j = 0; j < jMax; ++j) {
                        selectedNodes.add(nodesInSubtree.item(j));
                    }
                    continue;
                }
                if (currentRootNodeType == 2 || currentRootNodeType == 3 || currentRootNodeType == 4 || currentRootNodeType == 7) {
                    selectedNodes.add(currentRootNode);
                    continue;
                }
                throw new RuntimeException("unknown node type: " + currentRootNodeType + " " + currentRootNode);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("selection process identified " + selectedNodes.size() + " nodes"));
            }
            HashSet<Node> resultNodes = new HashSet<Node>();
            if (xpathContainer.isIntersect()) {
                inputSetIterator = inputSet.iterator();
                while (inputSetIterator.hasNext()) {
                    Node currentInputNode = (Node)inputSetIterator.next();
                    if (!selectedNodes.contains(currentInputNode)) continue;
                    resultNodes.add(currentInputNode);
                }
            } else if (xpathContainer.isSubtract()) {
                inputSetIterator = inputSet.iterator();
                while (inputSetIterator.hasNext()) {
                    Node currentInputNode = (Node)inputSetIterator.next();
                    if (selectedNodes.contains(currentInputNode)) continue;
                    resultNodes.add(currentInputNode);
                }
            } else if (xpathContainer.isUnion()) {
                inputSetIterator = inputSet.iterator();
                while (inputSetIterator.hasNext()) {
                    Node currentInputNode = (Node)inputSetIterator.next();
                    resultNodes.add(currentInputNode);
                }
                Iterator selectedSetIterator = selectedNodes.iterator();
                while (selectedSetIterator.hasNext()) {
                    Node currentSelectedNode = (Node)selectedSetIterator.next();
                    resultNodes.add(currentSelectedNode);
                }
            } else {
                throw new TransformationException("empty");
            }
            XMLSignatureInput result = new XMLSignatureInput(resultNodes);
            result.setSourceURI(input.getSourceURI());
            return result;
        }
        catch (TransformerException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (DOMException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (IOException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (InvalidCanonicalizerException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (XMLSecurityException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (SAXException ex) {
            throw new TransformationException("empty", ex);
        }
    }
}

