/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.IOException;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TransformEnvelopedSignature
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws TransformationException {
        try {
            Element transformElement;
            Node signatureElement = transformElement = this._transformObject.getElement();
            signatureElement = TransformEnvelopedSignature.searchSignatureElement(signatureElement);
            if (input.isElement()) {
                XMLSignatureInput result = new XMLSignatureInput(input.getSubNode());
                result.setExcludeNode(signatureElement);
                result.setExcludeComments(input.isExcludeComments());
                return result;
            }
            Set inputSet = input.getNodeSet();
            if (inputSet.isEmpty()) {
                Object[] exArgs = new Object[]{"input node set contains no nodes"};
                throw new TransformationException("generic.EmptyMessage", exArgs);
            }
            Set resultSet = XMLUtils.excludeNodeFromSet(signatureElement, inputSet);
            XMLSignatureInput result = new XMLSignatureInput(resultSet);
            return result;
        }
        catch (IOException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (SAXException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (ParserConfigurationException ex) {
            throw new TransformationException("empty", ex);
        }
        catch (CanonicalizationException ex) {
            throw new TransformationException("empty", ex);
        }
    }

    private static Node searchSignatureElement(Node signatureElement) throws TransformationException {
        boolean found = false;
        while (signatureElement != null && signatureElement.getNodeType() != 9) {
            Element el = (Element)signatureElement;
            if (el.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && el.getLocalName().equals("Signature")) {
                found = true;
                break;
            }
            signatureElement = signatureElement.getParentNode();
        }
        if (!found) {
            throw new TransformationException("envelopedSignatureTransformNotInSignatureElement");
        }
        return signatureElement;
    }
}

