/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms.implementations;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.implementations.Canonicalizer20010315WithComments;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.TransformSpi;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class TransformC14NWithComments
extends TransformSpi {
    public static final String implementedTransformURI = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";

    protected String engineGetURI() {
        return implementedTransformURI;
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input) throws IOException, CanonicalizationException {
        return this.enginePerformTransform(input, null);
    }

    protected XMLSignatureInput enginePerformTransform(XMLSignatureInput input, OutputStream os) throws IOException, CanonicalizationException {
        try {
            Canonicalizer20010315WithComments c14n = new Canonicalizer20010315WithComments();
            if (os != null) {
                c14n.setWriter(os);
            }
            c14n.set_includeComments(!input.isExcludeComments());
            byte[] result = null;
            if (input.isOctetStream()) {
                result = c14n.engineCanonicalize(input.getBytes());
            } else if (input.isElement()) {
                Node excl = input.getExcludeNode();
                result = c14n.engineCanonicalizeSubTree(input.getSubNode(), excl);
            } else {
                Set set = input.getNodeSet(true);
                result = c14n.engineCanonicalizeXPathNodeSet(set);
            }
            XMLSignatureInput output = new XMLSignatureInput(result);
            if (os != null) {
                output.setOutputStream(os);
            }
            return output;
        }
        catch (ParserConfigurationException ex) {
            Object[] exArgs = new Object[]{ex.getMessage()};
            CanonicalizationException cex = new CanonicalizationException("c14n.Canonicalizer.ParserConfigurationException", exArgs);
            throw cex;
        }
        catch (SAXException ex) {
            Object[] exArgs = new Object[]{ex.toString()};
            CanonicalizationException cex = new CanonicalizationException("c14n.Canonicalizer.SAXException", exArgs);
            throw cex;
        }
    }
}

