/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.transforms;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.AlgorithmAlreadyRegisteredException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.transforms.InvalidTransformException;
import org.apache.xml.security.transforms.TransformSpi;
import org.apache.xml.security.transforms.TransformationException;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Transform
extends SignatureElementProxy {
    static Log log = LogFactory.getLog((String)Transform.class.getName());
    static boolean _alreadyInitialized = false;
    static HashMap _transformHash = null;
    protected TransformSpi transformSpi = null;

    public Transform(Document doc, String algorithmURI, NodeList contextNodes) throws InvalidTransformException {
        super(doc);
        try {
            this._constructionElement.setAttributeNS(null, "Algorithm", algorithmURI);
            Class implementingClass = Transform.getImplementingClass(algorithmURI);
            if (implementingClass == null) {
                Object[] exArgs = new Object[]{algorithmURI};
                throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create URI \"" + algorithmURI + "\" class \"" + implementingClass + "\""));
                log.debug((Object)("The NodeList is " + contextNodes));
            }
            this.transformSpi = (TransformSpi)implementingClass.newInstance();
            this.transformSpi.setTransform(this);
            if (contextNodes != null) {
                for (int i = 0; i < contextNodes.getLength(); ++i) {
                    this._constructionElement.appendChild(contextNodes.item(i).cloneNode(true));
                }
            }
        }
        catch (IllegalAccessException ex) {
            Object[] exArgs = new Object[]{algorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs, ex);
        }
        catch (InstantiationException ex) {
            Object[] exArgs = new Object[]{algorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs, ex);
        }
    }

    public Transform(Element element, String BaseURI) throws InvalidTransformException, TransformationException, XMLSecurityException {
        super(element, BaseURI);
        String AlgorithmURI = element.getAttributeNS(null, "Algorithm");
        if (AlgorithmURI == null || AlgorithmURI.length() == 0) {
            Object[] exArgs = new Object[]{"Algorithm", "Transform"};
            throw new TransformationException("xml.WrongContent", exArgs);
        }
        try {
            Class implementingClass = (Class)_transformHash.get(AlgorithmURI);
            this.transformSpi = (TransformSpi)implementingClass.newInstance();
            this.transformSpi.setTransform(this);
        }
        catch (IllegalAccessException e) {
            Object[] exArgs = new Object[]{AlgorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs);
        }
        catch (InstantiationException e) {
            Object[] exArgs = new Object[]{AlgorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs);
        }
        catch (NullPointerException e) {
            Object[] exArgs = new Object[]{AlgorithmURI};
            throw new InvalidTransformException("signature.Transform.UnknownTransform", exArgs);
        }
    }

    public static final Transform getInstance(Document doc, String algorithmURI) throws InvalidTransformException {
        return Transform.getInstance(doc, algorithmURI, (NodeList)null);
    }

    public static final Transform getInstance(Document doc, String algorithmURI, Element contextChild) throws InvalidTransformException {
        HelperNodeList contextNodes = new HelperNodeList();
        contextNodes.appendChild(doc.createTextNode("\n"));
        contextNodes.appendChild(contextChild);
        contextNodes.appendChild(doc.createTextNode("\n"));
        return Transform.getInstance(doc, algorithmURI, contextNodes);
    }

    public static final Transform getInstance(Document doc, String algorithmURI, NodeList contextNodes) throws InvalidTransformException {
        return new Transform(doc, algorithmURI, contextNodes);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            _transformHash = new HashMap(10);
            _alreadyInitialized = true;
        }
    }

    public static void register(String algorithmURI, String implementingClass) throws AlgorithmAlreadyRegisteredException {
        Class registeredClass = Transform.getImplementingClass(algorithmURI);
        if (registeredClass != null) {
            Object[] exArgs = new Object[]{algorithmURI, registeredClass};
            throw new AlgorithmAlreadyRegisteredException("algorithm.alreadyRegistered", exArgs);
        }
        try {
            _transformHash.put(algorithmURI, Class.forName(implementingClass));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public final String getURI() {
        return this._constructionElement.getAttributeNS(null, "Algorithm");
    }

    public XMLSignatureInput performTransform(XMLSignatureInput input) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput result = null;
        try {
            result = this.transformSpi.enginePerformTransform(input);
        }
        catch (ParserConfigurationException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        catch (SAXException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        return result;
    }

    public XMLSignatureInput performTransform(XMLSignatureInput input, OutputStream os) throws IOException, CanonicalizationException, InvalidCanonicalizerException, TransformationException {
        XMLSignatureInput result = null;
        try {
            result = this.transformSpi.enginePerformTransform(input, os);
        }
        catch (ParserConfigurationException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "ParserConfigurationException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        catch (SAXException ex) {
            Object[] exArgs = new Object[]{this.getURI(), "SAXException"};
            throw new CanonicalizationException("signature.Transform.ErrorDuringTransform", exArgs, ex);
        }
        return result;
    }

    private static Class getImplementingClass(String URI2) {
        return (Class)_transformHash.get(URI2);
    }

    public String getBaseLocalName() {
        return "Transform";
    }
}

