/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.sfs.authentication;

import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.request.handler.sfs.authentication.ASelectAPIHandler;
import org.aselect.server.request.handler.sfs.authentication.ASelectBrowserHandler;
import org.aselect.server.request.handler.sfs.authentication.ApplicationAPIHandler;
import org.aselect.server.request.handler.sfs.authentication.ApplicationBrowserHandler;
import org.aselect.server.request.handler.sfs.authentication.AuthSPAPIHandler;
import org.aselect.server.request.handler.sfs.authentication.AuthSPBrowserHandler;
import org.aselect.server.request.handler.sfs.authentication.IRequestHandler;
import org.aselect.server.request.handler.sfs.authentication.RequestParser;
import org.aselect.system.exception.ASelectCommunicationException;

public class RequestHandlerFactory {
    private final String MODULE = "RequestHandlerFactory";
    private ASelectSystemLogger _systemLogger;
    private String _sMyServerId = null;
    private String _sMyOrg = null;
    private static RequestHandlerFactory _instance;

    public static RequestHandlerFactory getHandle() {
        if (_instance == null) {
            _instance = new RequestHandlerFactory();
        }
        return _instance;
    }

    public void init(String string, String string2) {
        this._sMyServerId = string;
        this._sMyOrg = string2;
        this._systemLogger = ASelectSystemLogger.getHandle();
    }

    public IRequestHandler createRequestHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectCommunicationException {
        String string = "createRequestHandler()";
        IRequestHandler iRequestHandler = null;
        RequestParser requestParser = new RequestParser(httpServletRequest);
        switch (requestParser.getRequestOrigin()) {
            case 0: {
                if (requestParser.getRequestType() == 0) {
                    iRequestHandler = new ApplicationAPIHandler(requestParser, httpServletRequest, httpServletResponse, this._sMyServerId, this._sMyOrg);
                    break;
                }
                iRequestHandler = new ApplicationBrowserHandler(httpServletRequest, httpServletResponse, this._sMyServerId, this._sMyOrg);
                break;
            }
            case 2: {
                if (requestParser.getRequestType() == 0) {
                    iRequestHandler = new ASelectAPIHandler(requestParser, httpServletRequest, httpServletResponse, this._sMyServerId, this._sMyOrg);
                    break;
                }
                iRequestHandler = new ASelectBrowserHandler(httpServletRequest, httpServletResponse, this._sMyServerId, this._sMyOrg);
                break;
            }
            case 1: {
                if (requestParser.getRequestType() == 0) {
                    iRequestHandler = new AuthSPAPIHandler(requestParser, httpServletRequest, httpServletResponse, this._sMyServerId, this._sMyOrg);
                    break;
                }
                iRequestHandler = new AuthSPBrowserHandler(httpServletRequest, httpServletResponse, this._sMyServerId, this._sMyOrg);
                break;
            }
            case 3: {
                if (requestParser.getRequestType() == 0) {
                    throw new ASelectCommunicationException("0030");
                }
                iRequestHandler = new ApplicationBrowserHandler(httpServletRequest, httpServletResponse, this._sMyServerId, this._sMyOrg);
                break;
            }
            default: {
                this._systemLogger.log(Level.WARNING, "RequestHandlerFactory", string, "Invalid request received.");
                throw new ASelectCommunicationException("0030");
            }
        }
        return iRequestHandler;
    }

    private RequestHandlerFactory() {
    }
}

