/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.sfs;

import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.cross.CrossASelectManager;
import org.aselect.server.request.RequestState;
import org.aselect.server.request.handler.AbstractRequestHandler;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Utils;

public class SFSIdpQueryHandler
extends AbstractRequestHandler {
    private static final String MODULE = "SFSIdpQueryHandler";
    private CrossASelectManager _crossASelectManager;
    private String _sMySharedSecret = null;
    private Hashtable _htSFSOrganizations = null;
    private String _sOrganizationId = null;

    public void init(ServletConfig servletConfig, Object object) throws ASelectException {
        block14: {
            String string = "init()";
            this._htSFSOrganizations = new Hashtable();
            super.init(servletConfig, object);
            try {
                Object object2;
                Object object3;
                try {
                    this._sMySharedSecret = this._configManager.getParam(object, "shared_secret");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._sMySharedSecret = null;
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "No 'shared_secret' configured");
                }
                try {
                    object3 = this._configManager.getSection(null, "aselect");
                    this._sOrganizationId = this._configManager.getParam(object3, "organization");
                    object2 = this._configManager.getParam(object3, "organization_friendly_name");
                    this._htSFSOrganizations.put(object2, this._sOrganizationId);
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._sMySharedSecret = null;
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "No extra sfs configuration found, skipping.");
                    throw aSelectConfigException;
                }
                object3 = null;
                try {
                    object3 = this._configManager.getSection(null, "sfs");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.CONFIG, MODULE, string, "No extra sfs configuration found, skipping.");
                }
                if (object3 == null) break block14;
                object2 = null;
                try {
                    object2 = this._configManager.getSection(object3, "idp");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.INFO, MODULE, string, "No \"idp\" entries configured in \"sfs\" section.");
                    object2 = null;
                }
                while (object2 != null) {
                    String string2 = this._configManager.getParam(object2, "friendly_name");
                    String string3 = this._configManager.getParam(object2, "organization");
                    this._htSFSOrganizations.put(string2, string3);
                    object2 = this._configManager.getNextSection(object2);
                }
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "initialization failed", (Throwable)aSelectException);
                throw aSelectException;
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "Unexpected runtime error occured: ", (Throwable)exception);
                throw new ASelectException("0001", (Throwable)exception);
            }
        }
        this._crossASelectManager = CrossASelectManager.getHandle();
    }

    public RequestState process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectException {
        boolean bl = true;
        String string = "process()";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            Object object;
            StringBuffer stringBuffer = null;
            if (!this._crossASelectManager.isCrossSelectorEnabled() || !this._crossASelectManager.remoteServersEnabled()) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "cross is disabled or there are no remote servers configured.");
                stringBuffer = new StringBuffer("result_code=").append("0030");
            } else {
                if (!(this._sMySharedSecret == null || (object = httpServletRequest.getParameter("shared_secret")) != null && ((String)object).equals(this._sMySharedSecret))) {
                    this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid 'shared_secret' provided.");
                    stringBuffer = new StringBuffer("result_code=").append("0030");
                    bl = false;
                }
                if (bl) {
                    String string2;
                    String string3;
                    object = this._crossASelectManager.getRemoteServers();
                    Enumeration enumeration = ((Hashtable)object).keys();
                    while (enumeration.hasMoreElements()) {
                        string3 = (String)enumeration.nextElement();
                        string2 = (String)((Hashtable)object).get(string3);
                        if (!hashtable.contains(string2)) {
                            String string4 = this._crossASelectManager.getRemoteParam(string3, "display");
                            if (string4 != null && !string4.equalsIgnoreCase("true")) continue;
                            hashtable.put(string2, string3);
                            continue;
                        }
                        this._systemLogger.log(Level.WARNING, MODULE, string, "Unable to add '" + string2 + "', value already exists.");
                    }
                    enumeration = this._htSFSOrganizations.keys();
                    while (enumeration.hasMoreElements()) {
                        string3 = (String)enumeration.nextElement();
                        string2 = (String)this._htSFSOrganizations.get(string3);
                        hashtable.put(string3, string2);
                    }
                    string3 = Utils.hashtable2CGIMessage(hashtable);
                    string2 = URLEncoder.encode(string3, "UTF-8");
                    stringBuffer = new StringBuffer("result_code=").append("0000").append("&result=").append(string2);
                }
            }
            object = httpServletResponse.getWriter();
            ((PrintWriter)object).print(stringBuffer.toString());
            if (object != null) {
                ((PrintWriter)object).close();
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not process request", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return new RequestState(null);
    }

    public void destroy() {
    }
}

