/*
 * Decompiled with CFR 0.152.
 */
package cryptix.jce.provider.rsa;

import cryptix.jce.provider.asn.AsnBitString;
import cryptix.jce.provider.asn.AsnInteger;
import cryptix.jce.provider.asn.AsnObject;
import cryptix.jce.provider.asn.AsnObjectId;
import cryptix.jce.provider.asn.AsnOutputStream;
import cryptix.jce.provider.asn.AsnSequence;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.RSAPublicKey;

final class RSAPublicKeyX509
implements RSAPublicKey {
    private final BigInteger n;
    private final BigInteger e;

    public BigInteger getModulus() {
        return this.n;
    }

    public BigInteger getPublicExponent() {
        return this.e;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public String getFormat() {
        return "X.509";
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getEncoded() {
        void spkBytes;
        AsnObject[] spkData = new AsnObject[]{new AsnInteger(this.n), new AsnInteger(this.e)};
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AsnOutputStream dos = new AsnOutputStream(baos);
            dos.write(new AsnSequence(spkData));
            dos.flush();
            dos.close();
            byte[] byArray = baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("PANIC");
        }
        AsnBitString subjectPublicKey = new AsnBitString((byte[])spkBytes);
        AsnObject[] algData = new AsnObject[]{AsnObjectId.OID_rsaEncryption};
        AsnSequence algorithm = new AsnSequence(algData);
        AsnObject[] spkiData = new AsnObject[]{algorithm, subjectPublicKey};
        AsnSequence subjectPublicKeyInfo = new AsnSequence(spkiData);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            AsnOutputStream dos = new AsnOutputStream(baos);
            dos.write(subjectPublicKeyInfo);
            dos.flush();
            dos.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("PANIC");
        }
    }

    RSAPublicKeyX509(BigInteger n, BigInteger e) {
        this.n = n;
        this.e = e;
    }
}

