/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.storagemanager.handler;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectStorageException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMAgent;
import org.aselect.system.storagemanager.IStorageHandler;

public class MemoryStorageHandler
implements IStorageHandler {
    public static final String MODULE = "MemoryStorageHandler";
    private Hashtable _htStorage;
    private SystemLogger _systemLogger;

    public void init(Object object, ConfigManager configManager, SystemLogger systemLogger, SAMAgent sAMAgent) throws ASelectStorageException {
        this._systemLogger = systemLogger;
        this._htStorage = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) throws ASelectStorageException {
        String string = "get()";
        Object var3_3 = null;
        try {
            Hashtable hashtable = this._htStorage;
            synchronized (hashtable) {
                Hashtable hashtable2 = (Hashtable)this._htStorage.get(object);
                var3_3 = hashtable2.get("contents");
            }
        }
        catch (NullPointerException nullPointerException) {
            this._systemLogger.log(Level.FINE, MODULE, string, "Empty (null) key-object was supplied.");
            throw new ASelectStorageException("6002", nullPointerException);
        }
        if (var3_3 == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "The supplied key is not mapped to any value, cause: 6003");
            throw new ASelectStorageException("6003");
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimestamp(Object object) throws ASelectStorageException {
        String string = "getTimestamp()";
        long l = 0L;
        try {
            Hashtable hashtable = this._htStorage;
            synchronized (hashtable) {
                Hashtable hashtable2 = (Hashtable)this._htStorage.get(object);
                Long l2 = (Long)hashtable2.get("timestamp");
                l = l2;
            }
        }
        catch (NullPointerException nullPointerException) {
            StringBuffer stringBuffer = new StringBuffer("MemoryStorageHandler.getTimestamp() -> ");
            stringBuffer.append("Empty (null) key-object was supplied");
            this._systemLogger.log(Level.FINE, MODULE, string, "Empty (null) key-object was supplied.");
            throw new ASelectStorageException("6002", nullPointerException);
        }
        if (l == 0L) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "The supplied key is not mapped to any value,cause: 6003");
            throw new ASelectStorageException("6003");
        }
        return l;
    }

    public long getCount() throws ASelectStorageException {
        return this._htStorage.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getAll() throws ASelectStorageException {
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = this._htStorage;
        synchronized (hashtable2) {
            Enumeration enumeration = this._htStorage.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Hashtable hashtable3 = (Hashtable)this._htStorage.get(k);
                Object v = hashtable3.get("contents");
                hashtable.put(k, v);
            }
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object, Object object2, Long l) throws ASelectStorageException {
        String string = "put";
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        try {
            hashtable.put("timestamp", l);
            hashtable.put("contents", object2);
        }
        catch (NullPointerException nullPointerException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "The supplied value was null", nullPointerException);
            throw new ASelectStorageException("6004", nullPointerException);
        }
        try {
            Hashtable hashtable2 = this._htStorage;
            synchronized (hashtable2) {
                this._htStorage.put(object, hashtable);
            }
        }
        catch (NullPointerException nullPointerException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Empty (null) key-object supplied", nullPointerException);
            throw new ASelectStorageException("6004", nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object object) throws ASelectStorageException {
        String string = "remove()";
        try {
            Hashtable hashtable = this._htStorage;
            synchronized (hashtable) {
                if (this._htStorage.remove(object) == null) {
                    StringBuffer stringBuffer = new StringBuffer("Could not remove object: ");
                    stringBuffer.append(object);
                    this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
                    throw new ASelectStorageException("6003");
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Empty (null) key-object supplied", nullPointerException);
            throw new ASelectStorageException("6005", nullPointerException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() throws ASelectStorageException {
        Hashtable hashtable = this._htStorage;
        synchronized (hashtable) {
            this._htStorage.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(Long l) throws ASelectStorageException {
        Hashtable hashtable = this._htStorage;
        synchronized (hashtable) {
            Enumeration enumeration = this._htStorage.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Hashtable hashtable2 = (Hashtable)this._htStorage.get(k);
                Long l2 = (Long)hashtable2.get("timestamp");
                if (l < l2) continue;
                this._htStorage.remove(k);
            }
        }
    }

    public void destroy() {
        if (this._htStorage != null) {
            this._htStorage.clear();
            this._htStorage = null;
        }
    }

    public boolean isMaximum(long l) throws ASelectStorageException {
        return (long)this._htStorage.size() == l;
    }

    public boolean containsKey(Object object) throws ASelectStorageException {
        return this._htStorage.containsKey(object);
    }
}

