/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.aselect.system.exception.ASelectDatabaseException;
import org.aselect.system.logging.SystemLogger;

public class SQLDatabaseConnector {
    private Connection _oConn = null;
    private String _sSQLURL;
    private String _sSQLUser;
    private String _sSQLPassword;
    private int _iConnCount = 0;
    private SystemLogger _systemLogger = null;
    private static final String MODULE = "SQLDatabaseConnector";

    public SQLDatabaseConnector(String string, String string2, String string3, String string4, SystemLogger systemLogger) throws ASelectDatabaseException {
        String string5 = "SQLDatabaseConnector()";
        this._systemLogger = systemLogger;
        this._sSQLUser = string2;
        this._sSQLPassword = string3;
        this._sSQLURL = string4;
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            StringBuffer stringBuffer = new StringBuffer("Database initialisation failed, driver unknown: ");
            stringBuffer.append(classNotFoundException);
            stringBuffer.append(" errorcode: ");
            stringBuffer.append("5001");
            this._systemLogger.log(Level.WARNING, MODULE, string5, stringBuffer.toString(), classNotFoundException);
            throw new ASelectDatabaseException("5001", classNotFoundException);
        }
    }

    public synchronized void updateCount(boolean bl) {
        this._iConnCount = bl ? ++this._iConnCount : --this._iConnCount;
    }

    public synchronized Statement connect() {
        String string = "connect()";
        Statement statement = null;
        try {
            if (this._oConn == null || this._oConn.isClosed()) {
                this._oConn = DriverManager.getConnection(this._sSQLURL, this._sSQLUser, this._sSQLPassword);
            }
            statement = this._oConn.createStatement();
            this.updateCount(true);
        }
        catch (SQLException sQLException) {
            statement = null;
            this._systemLogger.log(Level.WARNING, MODULE, string, "Database connection failed", sQLException);
        }
        catch (Exception exception) {
            statement = null;
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Database connection failed", exception);
        }
        return statement;
    }

    public synchronized boolean disconnect(Statement statement) {
        String string = "disconnect()";
        boolean bl = false;
        try {
            if (statement != null) {
                statement.close();
            }
            statement = null;
            this.updateCount(false);
            if (this._iConnCount < 1) {
                if (this._oConn != null) {
                    this._oConn.close();
                }
                this._oConn = null;
            }
            bl = true;
        }
        catch (SQLException sQLException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Disconnect failed", sQLException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Disconnect failed", exception);
        }
        return bl;
    }

    public ResultSet executeQuery(Statement statement, String string) throws ASelectDatabaseException {
        String string2 = "executeQuery()";
        ResultSet resultSet = null;
        try {
            if (statement == null) {
                StringBuffer stringBuffer = new StringBuffer("No database connection available, ");
                stringBuffer.append("5003");
                this._systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
                throw new ASelectDatabaseException("5003");
            }
            resultSet = statement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Error executing query", sQLException);
            throw new ASelectDatabaseException("5003", sQLException);
        }
        return resultSet;
    }

    public int executeUpdate(Statement statement, String string) throws ASelectDatabaseException {
        String string2 = "executeUpdate()";
        int n = -1;
        try {
            if (statement == null) {
                StringBuffer stringBuffer = new StringBuffer("No database connection available, ");
                stringBuffer.append("cause: ");
                stringBuffer.append("5004");
                this._systemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString());
                throw new ASelectDatabaseException("5004");
            }
            n = statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Error executing update query", sQLException);
            throw new ASelectDatabaseException("5004", sQLException);
        }
        return n;
    }

    public void startTransaction(Statement statement) throws ASelectDatabaseException {
        String string = "startTransaction()";
        try {
            if (statement == null) {
                StringBuffer stringBuffer = new StringBuffer("No database connection available, ");
                stringBuffer.append("cause: ");
                stringBuffer.append("5004");
                this._systemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString());
                throw new ASelectDatabaseException("5004");
            }
            statement.execute("BEGIN");
        }
        catch (SQLException sQLException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Error executing 'BEGIN'", sQLException);
            throw new ASelectDatabaseException("5004", sQLException);
        }
    }

    public void rollbackTransaction(Statement statement) throws ASelectDatabaseException {
        String string = "rollbackTransaction()";
        try {
            if (statement == null) {
                StringBuffer stringBuffer = new StringBuffer("No database connection available, ");
                stringBuffer.append("cause: ");
                stringBuffer.append("5004");
                this._systemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString());
                throw new ASelectDatabaseException("5004");
            }
            statement.execute("ROLLBACK");
        }
        catch (SQLException sQLException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Error executing 'ROLLBACK'", sQLException);
            throw new ASelectDatabaseException("5004", sQLException);
        }
    }

    public void commitTransaction(Statement statement) throws ASelectDatabaseException {
        String string = "commitTransaction()";
        try {
            if (statement == null) {
                StringBuffer stringBuffer = new StringBuffer("No database connection available, ");
                stringBuffer.append("cause: ");
                stringBuffer.append("5004");
                this._systemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString());
                throw new ASelectDatabaseException("5004");
            }
            statement.execute("COMMIT");
        }
        catch (SQLException sQLException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Error executing 'COMMIT'", sQLException);
            throw new ASelectDatabaseException("5004", sQLException);
        }
    }

    public String getDatabaseUrl() {
        return this._sSQLURL;
    }
}

