/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.communication.server.soap12;

import java.io.IOException;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.aselect.system.communication.server.IMessageCreatorInterface;
import org.aselect.system.communication.server.IProtocolRequest;
import org.aselect.system.communication.server.IProtocolResponse;
import org.aselect.system.communication.server.soap12.ASOAPException;
import org.aselect.system.communication.server.soap12.SOAP12ErrorHandler;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.logging.SystemLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SOAP12MessageCreator
implements IMessageCreatorInterface {
    private static final String MODULE = "SOAP12MessageCreator";
    private SystemLogger _systemLogger;
    private Document _oInputMessage;
    private Element _elInputBody;
    private Element _elInputRPCBody;
    private Document _oOutputMessage;
    private Element _elOutputHeader;
    private Element _elOutputBody;
    private Element _elOutputRPCBody;
    private String _sMethodEnv;
    private String _sMethodName;
    private IProtocolRequest _oRequest;
    private IProtocolResponse _oResponse;

    public SOAP12MessageCreator(String string, String string2, SystemLogger systemLogger) {
        this._sMethodEnv = string;
        this._sMethodName = string2;
        this._oInputMessage = null;
        this._elInputBody = null;
        this._elInputRPCBody = null;
        this._oOutputMessage = null;
        this._elOutputHeader = null;
        this._elOutputBody = null;
        this._elOutputRPCBody = null;
        this._systemLogger = systemLogger;
    }

    public boolean init(IProtocolRequest iProtocolRequest, IProtocolResponse iProtocolResponse) throws ASelectCommunicationException {
        String string = "init()";
        this._oRequest = iProtocolRequest;
        this._oResponse = iProtocolResponse;
        this.createOutputMessage();
        try {
            this.createInputMessage();
        }
        catch (ASOAPException aSOAPException) {
            int n = aSOAPException.getCode();
            String string2 = aSOAPException.getReason();
            String string3 = aSOAPException.getMessage();
            String string4 = "";
            switch (n) {
                case 1: {
                    string4 = "VersionMismatch";
                    this._oResponse.setProperty("Status", "500");
                    this.createFault(string4, string2, string3);
                    break;
                }
                case 2: {
                    string4 = "MustUnderstand";
                    this._oResponse.setProperty("Status", "500");
                    this.createFault(string4, string2, string3);
                    break;
                }
                case 5: {
                    string4 = "DataEncodingUnknown";
                    this._oResponse.setProperty("Status", "500");
                    this.createFault(string4, string2, string3);
                    break;
                }
                case 8: {
                    string4 = "VersionMismatch";
                    this._oResponse.setProperty("Status", "500");
                    this.createSOAP11UpdateFault(string4, string2);
                    break;
                }
                case 3: {
                    string4 = "Sender";
                    this._oResponse.setProperty("Status", "400");
                    this.createFault(string4, string2, string3);
                    break;
                }
                case 4: {
                    string4 = "Receiver";
                    this._oResponse.setProperty("Status", "500");
                    this.createFault(string4, string2, string3);
                    break;
                }
                default: {
                    string4 = "Receiver";
                    this._oResponse.setProperty("Status", "500");
                    this.createFault(string4, string2, string3);
                }
            }
            this.send();
            this._oInputMessage = null;
            StringBuffer stringBuffer = new StringBuffer("Could not parse inputmessage. errorcode: ");
            stringBuffer.append("4007");
            this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
            this._systemLogger.log(Level.FINE, MODULE, string, "Received SOAP inputmessage:\n" + this._oRequest.getMessage());
            this._systemLogger.log(Level.WARNING, MODULE, string, "SOAP fault sent: " + string4 + ", " + string2 + ", " + string3);
            throw new ASelectCommunicationException("4007");
        }
        return true;
    }

    public String getParam(String string) throws ASelectCommunicationException {
        String string2 = "getParam()";
        if (this._oInputMessage == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No input message available, cause: 4007");
            throw new ASelectCommunicationException("4007");
        }
        NodeList nodeList = this._elInputRPCBody.getElementsByTagNameNS(this._sMethodEnv, string);
        String string3 = "";
        if (nodeList.getLength() == 1) {
            Element element = (Element)nodeList.item(0);
            NodeList nodeList2 = element.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Object object;
                Node node = nodeList2.item(i);
                if (node.getNodeType() == 3) {
                    object = (Text)node;
                    String string4 = object.getData();
                    if (string4.equals("")) continue;
                    string3 = string3 + string4;
                    continue;
                }
                object = new StringBuffer("Invalid parameter in input message: ");
                ((StringBuffer)object).append(node.getNodeName());
                ((StringBuffer)object).append(",cause: ");
                ((StringBuffer)object).append("4007");
                this._systemLogger.log(Level.WARNING, MODULE, string2, ((StringBuffer)object).toString());
                throw new ASelectCommunicationException("4007");
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nodeList.getLength());
            stringBuffer.append(" number of parameters in input message with name ");
            stringBuffer.append(string);
            stringBuffer.append(",cause: ");
            stringBuffer.append("4007");
            this._systemLogger.log(Level.FINE, MODULE, string2, stringBuffer.toString());
            throw new ASelectCommunicationException("4007");
        }
        return string3.trim();
    }

    public String[] getArray(String string) throws ASelectCommunicationException {
        String string2 = "getArray()";
        if (this._elInputRPCBody == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No input message available, cause: 4007");
            throw new ASelectCommunicationException("4007");
        }
        String[] stringArray = null;
        NodeList nodeList = this._elInputRPCBody.getElementsByTagNameNS(this._sMethodEnv, string);
        if (nodeList.getLength() != 1) {
            StringBuffer stringBuffer = new StringBuffer("SOAP Message contains multiple params with the same name: ");
            stringBuffer.append(string);
            stringBuffer.append(",cause: ");
            stringBuffer.append("4007");
            this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
            throw new ASelectCommunicationException("4007");
        }
        stringArray = this.resolveArray((Element)nodeList.item(0));
        return stringArray;
    }

    public boolean setParam(String string, String string2) throws ASelectCommunicationException {
        String string3 = "setParam()";
        if (this._oOutputMessage == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string3, "No output message available, cause: 4007");
            throw new ASelectCommunicationException("4007");
        }
        if (this._elOutputRPCBody == null) {
            this._elOutputRPCBody = this.createRPCBody();
            this._elOutputBody.appendChild(this._elOutputRPCBody);
        }
        Text text = this._oOutputMessage.createTextNode(string2);
        NodeList nodeList = this._elOutputRPCBody.getElementsByTagNameNS(this._sMethodEnv, string);
        if (nodeList.getLength() != 1) {
            Element element = null;
            element = this._oOutputMessage.createElementNS(this._sMethodEnv, "m:" + string);
            element.appendChild(text);
            this._elOutputRPCBody.appendChild(element);
        } else {
            Element element = (Element)nodeList.item(0);
            Node node = element.getFirstChild();
            element.replaceChild(text, node);
        }
        return true;
    }

    public boolean setParam(String string, String[] stringArray) throws ASelectCommunicationException {
        String string2 = "setParam()";
        if (this._oOutputMessage == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No output message available, cause: 4007");
            throw new ASelectCommunicationException("4007");
        }
        Element element = this.arrayToXML(string, stringArray);
        NodeList nodeList = this._elOutputRPCBody.getElementsByTagNameNS("http://www.w3.org/2003/05/soap-encoding", string);
        if (nodeList.getLength() != 1) {
            this._elOutputRPCBody.appendChild(element);
        } else {
            this._elOutputRPCBody.replaceChild(element, nodeList.item(0));
        }
        return true;
    }

    public boolean send() throws ASelectCommunicationException {
        String string = "send()";
        if (this._oOutputMessage == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Message is already sent, there is no output message, cause: 4007");
            throw new ASelectCommunicationException("4007");
        }
        try {
            OutputFormat outputFormat = new OutputFormat(this._oOutputMessage);
            outputFormat.setLineSeparator("\n");
            outputFormat.setIndenting(true);
            outputFormat.setLineWidth(80);
            XMLSerializer xMLSerializer = new XMLSerializer(this._oResponse.getOutputStream(), outputFormat);
            xMLSerializer.setNamespaces(true);
            xMLSerializer.serialize(this._oOutputMessage.getDocumentElement());
            this._oOutputMessage = null;
            this._elOutputBody = null;
            this._elOutputRPCBody = null;
            this._elOutputHeader = null;
            return true;
        }
        catch (IOException iOException) {
            StringBuffer stringBuffer = new StringBuffer("DOM object could not be serialized: ");
            stringBuffer.append(iOException.getMessage());
            stringBuffer.append(", cause: ");
            stringBuffer.append("4006");
            this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), iOException);
            throw new ASelectCommunicationException("4006");
        }
    }

    private void createInputMessage() throws ASOAPException {
        Object object;
        Object object2;
        try {
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setNamespaceAware(true);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            ((DocumentBuilder)object).setErrorHandler(new SOAP12ErrorHandler());
            this._oInputMessage = ((DocumentBuilder)object).parse(this._oRequest.getInputStream());
        }
        catch (SAXParseException sAXParseException) {
            throw new ASOAPException(3, "Bad request", sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new ASOAPException(3, "Bad request", sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new ASOAPException(4, "Internal server error", iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ASOAPException(4, "Internal server error", parserConfigurationException.getMessage());
        }
        object2 = this._oInputMessage.getDocumentElement();
        object = object2.getNamespaceURI();
        if (((String)object).equals("http://www.w3.org/2003/05/soap-envelope")) {
            if (!this.validEnvelope((Element)object2)) {
                String string = null;
                throw new ASOAPException(1, "Version Mismatch", string);
            }
            this._elInputBody = this.getChildElement((Element)object2, "Body", "http://www.w3.org/2003/05/soap-envelope");
            if (this._elInputBody == null) {
                throw new ASOAPException(3, "Bad request", "SOAP message must contain mandatory Body element.");
            }
            this._elInputRPCBody = this.getChildElement(this._elInputBody, this._sMethodName, this._sMethodEnv);
            if (this._elInputRPCBody == null) {
                throw new ASOAPException(3, "Bad request", "Unsupported request received, invalid RPC body.");
            }
            if (!this.validEncoding(this._elInputRPCBody)) {
                throw new ASOAPException(5, "Internal server error", "Unsupported data encoding received.");
            }
        } else {
            if (((String)object).equals("http://www.w3.org/2001/12/soap-envelope")) {
                String string = null;
                throw new ASOAPException(8, "Version Mismatch", string);
            }
            String string = null;
            throw new ASOAPException(1, "Version Mismatch", string);
        }
    }

    private void createOutputMessage() {
        this._oResponse.setProperty("Content-Type", "application/soap+xml; charset=utf-8");
        this._oOutputMessage = new DocumentImpl();
        Element element = this._oOutputMessage.createElementNS("http://www.w3.org/2003/05/soap-envelope", "env:Envelope");
        element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        this._oOutputMessage.appendChild(element);
        this._elOutputBody = this._oOutputMessage.createElementNS("http://www.w3.org/2003/05/soap-envelope", "env:Body");
        element.appendChild(this._elOutputBody);
    }

    private Element createRPCBody() {
        Element element = this._oOutputMessage.createElementNS(this._sMethodEnv, "m:" + this._sMethodName + "Response");
        element.setAttributeNS("http://www.w3.org/2003/05/soap-envelope", "env:encodingStyle", "http://www.w3.org/2003/05/soap-encoding");
        return element;
    }

    private void createFault(String string, String string2, String string3) {
        Node node;
        Element element;
        Element element2 = this._oOutputMessage.getDocumentElement();
        if (this._elOutputRPCBody != null) {
            this._elOutputBody.removeChild(this._elOutputRPCBody);
        }
        Element element3 = this._oOutputMessage.createElementNS("http://www.w3.org/2003/05/soap-envelope", "env:Fault");
        this._elOutputBody.appendChild(element3);
        Element element4 = this._oOutputMessage.createElementNS("http://www.w3.org/2003/05/soap-envelope", "env:Code");
        element3.appendChild(element4);
        Element element5 = this._oOutputMessage.createElementNS("http://www.w3.org/2003/05/soap-envelope", "env:Value");
        Text text = this._oOutputMessage.createTextNode("env:" + string);
        element5.appendChild(text);
        element4.appendChild(element5);
        Element element6 = this._oOutputMessage.createElementNS("http://www.w3.org/2003/05/soap-envelope", "env:Reason");
        element3.appendChild(element6);
        Element element7 = this._oOutputMessage.createElementNS("http://www.w3.org/2003/05/soap-envelope", "env:Text");
        element7.setAttribute("xml:lang", "en-us");
        Text text2 = this._oOutputMessage.createTextNode(string2);
        element7.appendChild(text2);
        element6.appendChild(element7);
        if (string3 != null) {
            element = this._oOutputMessage.createElementNS("http://www.w3.org/2003/05/soap-envelope", "env:Detail");
            element3.appendChild(element);
            node = this._oOutputMessage.createTextNode(string3);
            element.appendChild(node);
        }
        if (string.equals("VersionMismatch")) {
            if (this._elOutputHeader == null) {
                this._elOutputHeader = this._oOutputMessage.createElementNS("http://www.w3.org/2003/05/soap-envelope", "env:Header");
                element2.insertBefore(this._elOutputHeader, this._elOutputBody);
            }
            element = this._oOutputMessage.createElementNS("http://www.w3.org/2003/05/soap-envelope", "env:Upgrade");
            this._elOutputHeader.appendChild(element);
            node = this._oOutputMessage.createElementNS("http://www.w3.org/2003/05/soap-envelope", "env:SupportedEnvelope");
            node.setAttribute("qname", "ns1:Envelope");
            node.setAttribute("xmlns:ns1", "http://www.w3.org/2003/05/soap-envelope");
            element.appendChild(node);
        }
    }

    private void createSOAP11UpdateFault(String string, String string2) {
        this._oResponse.setProperty("Content-Type", "text/xml; charset=utf-8");
        this._oOutputMessage = new DocumentImpl();
        Element element = this._oOutputMessage.createElementNS("http://www.w3.org/2001/12/soap-envelope", "env:Envelope");
        this._oOutputMessage.appendChild(element);
        this._elOutputHeader = this._oOutputMessage.createElementNS("http://www.w3.org/2001/12/soap-envelope", "env:Header");
        element.appendChild(this._elOutputHeader);
        Element element2 = this._oOutputMessage.createElementNS("http://www.w3.org/2001/12/soap-envelope", "env:Upgrade");
        this._elOutputHeader.appendChild(element2);
        Element element3 = this._oOutputMessage.createElementNS("http://www.w3.org/2001/12/soap-envelope", "env:SupportedEnvelope");
        element3.setAttribute("qname", "ns1:Envelope");
        element3.setAttribute("xmlns:ns1", "http://www.w3.org/2003/05/soap-envelope");
        element2.appendChild(element3);
        this._elOutputBody = this._oOutputMessage.createElementNS("http://www.w3.org/2001/12/soap-envelope", "env:Body");
        element.appendChild(this._elOutputBody);
        Element element4 = this._oOutputMessage.createElementNS("http://www.w3.org/2001/12/soap-envelope", "env:Fault");
        this._elOutputBody.appendChild(element4);
        Element element5 = this._oOutputMessage.createElement("faultcode");
        Text text = this._oOutputMessage.createTextNode("env:" + string);
        element5.appendChild(text);
        element4.appendChild(element5);
        Element element6 = this._oOutputMessage.createElement("faultstring");
        Text text2 = this._oOutputMessage.createTextNode(string2);
        element6.appendChild(text2);
        element4.appendChild(element6);
    }

    private boolean validEnvelope(Element element) {
        String string = element.getLocalName();
        return string.equals("Envelope");
    }

    private boolean validEncoding(Element element) {
        String string = element.getAttributeNS("http://www.w3.org/2003/05/soap-envelope", "encodingStyle");
        return string.equals("http://www.w3.org/2003/05/soap-encoding");
    }

    private Element getChildElement(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagNameNS(string2, string);
        if (nodeList.getLength() == 1) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private String[] resolveArray(Element element) throws ASelectCommunicationException {
        String[] stringArray = null;
        String string = null;
        String string2 = "resolveArray()";
        String string3 = element.getAttributeNS("http://www.w3.org/2003/05/soap-encoding", "itemType");
        if (string3.equalsIgnoreCase("xsd:string")) {
            string = element.getAttributeNS("http://www.w3.org/2003/05/soap-encoding", "arraySize");
            try {
                int n = new Integer(string);
                int n2 = 0;
                stringArray = new String[n];
                NodeList nodeList = element.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node;
                    if (nodeList.item(i).getNodeType() != 1 || (node = nodeList.item(i).getFirstChild()).getNodeType() != 3 || n2 >= n) continue;
                    stringArray[n2++] = node.getNodeValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                StringBuffer stringBuffer = new StringBuffer("Error during resolving array (invalid 'arraySize'): ");
                stringBuffer.append(numberFormatException.getMessage());
                stringBuffer.append(", cause: ");
                stringBuffer.append("4008");
                this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString(), numberFormatException);
                throw new ASelectCommunicationException("4008");
            }
        }
        if (stringArray == null) {
            StringBuffer stringBuffer = new StringBuffer("Could not resolve array. Resolved array length: ");
            stringBuffer.append(string);
            stringBuffer.append(", cause: ");
            stringBuffer.append("0001");
            this._systemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
            throw new ASelectCommunicationException("0001");
        }
        return stringArray;
    }

    private Element arrayToXML(String string, String[] stringArray) {
        Element element = this._oOutputMessage.createElementNS(this._sMethodEnv, "m:" + string);
        element.setAttributeNS("http://www.w3.org/2003/05/soap-encoding", "enc:itemType", "xsd:string");
        element.setAttributeNS("http://www.w3.org/2003/05/soap-encoding", "enc:arraySize", "" + stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            Element element2 = this._oOutputMessage.createElement("m:item");
            element2.setAttribute("xsi:type", "xsd:string");
            Text text = this._oOutputMessage.createTextNode(stringArray[i]);
            element2.appendChild(text);
            element.appendChild(element2);
        }
        return element;
    }
}

