/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.communication.server.soap11;

import java.io.IOException;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.aselect.system.communication.server.IMessageCreatorInterface;
import org.aselect.system.communication.server.IProtocolRequest;
import org.aselect.system.communication.server.IProtocolResponse;
import org.aselect.system.communication.server.soap11.ASOAPException;
import org.aselect.system.communication.server.soap11.SOAP11ErrorHandler;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.logging.SystemLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SOAP11MessageCreator
implements IMessageCreatorInterface {
    private static final String MODULE = "SOAP11MessageCreator";
    private SystemLogger _systemLogger;
    private Document _oInputMessage;
    private Element _elInputBody;
    private Element _elInputRPCBody;
    private Document _oOutputMessage;
    private Element _elOutputBody;
    private Element _elOutputRPCBody;
    private IProtocolRequest _oRequest;
    private IProtocolResponse _oResponse;
    private String _sInputMessageSchema;
    private String _sMethodEnv;
    private String _sMethodName;

    public SOAP11MessageCreator(String string, String string2, SystemLogger systemLogger) {
        this._sMethodEnv = string;
        this._sMethodName = string2;
        this._systemLogger = systemLogger;
        this._oInputMessage = null;
        this._elInputBody = null;
        this._elInputRPCBody = null;
        this._sInputMessageSchema = "http://www.w3.org/2001/12/soap-envelope";
        this._oOutputMessage = null;
        this._elOutputBody = null;
        this._elOutputRPCBody = null;
    }

    public boolean init(IProtocolRequest iProtocolRequest, IProtocolResponse iProtocolResponse) throws ASelectCommunicationException {
        StringBuffer stringBuffer = null;
        String string = "init()";
        this._oRequest = iProtocolRequest;
        this._oResponse = iProtocolResponse;
        try {
            this._oInputMessage = this.createInputMessage();
        }
        catch (ASOAPException aSOAPException) {
            int n = aSOAPException.getCode();
            String string2 = aSOAPException.getReason();
            String string3 = aSOAPException.getMessage();
            String string4 = "";
            switch (n) {
                case 1: {
                    string4 = "VersionMismatch";
                    break;
                }
                case 2: {
                    string4 = "MustUnderstand";
                    break;
                }
                case 3: {
                    string4 = "Client";
                    break;
                }
                case 4: {
                    string4 = "Server";
                    break;
                }
                default: {
                    string4 = "Server";
                }
            }
            stringBuffer = new StringBuffer("Could not parse inputmessage, cause: ");
            stringBuffer.append("4007");
            this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
            this._systemLogger.log(Level.FINE, MODULE, string, "Received SOAP inputmessage:\n" + this._oRequest.getMessage());
            iProtocolResponse.setProperty("Status", "500");
            this._oOutputMessage = this.createOutputMessage();
            this._elOutputBody.appendChild(this.createFault(string4, string2, string3));
            this.send();
            this._systemLogger.log(Level.WARNING, MODULE, string, "SOAP fault sent: " + string4 + ", " + string2 + ", " + string3);
            throw new ASelectCommunicationException("4007");
        }
        this._oOutputMessage = this.createOutputMessage();
        this._elOutputRPCBody = this._oOutputMessage.createElementNS(this._sMethodEnv, "m:" + this._sMethodName + "Response");
        this._elOutputBody.appendChild(this._elOutputRPCBody);
        return true;
    }

    public String getParam(String string) throws ASelectCommunicationException {
        String string2 = "getParam()";
        if (this._oInputMessage == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No input message available, cause: 4007");
            throw new ASelectCommunicationException("4007");
        }
        NodeList nodeList = this._elInputRPCBody.getElementsByTagNameNS(this._sMethodEnv, string);
        String string3 = "";
        if (nodeList.getLength() == 1) {
            Element element = (Element)nodeList.item(0);
            NodeList nodeList2 = element.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Object object;
                Node node = nodeList2.item(i);
                if (node.getNodeType() == 3) {
                    object = (Text)node;
                    String string4 = object.getData();
                    if (string4.equals("")) continue;
                    string3 = string3 + string4;
                    continue;
                }
                object = new StringBuffer("Invalid parameter in input message: ");
                ((StringBuffer)object).append(node.getNodeName());
                ((StringBuffer)object).append(", cause: ");
                ((StringBuffer)object).append("4007");
                this._systemLogger.log(Level.WARNING, MODULE, string2, ((StringBuffer)object).toString());
                throw new ASelectCommunicationException("4007");
            }
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(nodeList.getLength());
            stringBuffer.append(" number of parameters in input message with name ");
            stringBuffer.append(string);
            stringBuffer.append(", cause: ");
            stringBuffer.append("4007");
            this._systemLogger.log(Level.FINE, MODULE, string2, stringBuffer.toString());
            throw new ASelectCommunicationException("4007");
        }
        return string3.trim();
    }

    public String[] getArray(String string) throws ASelectCommunicationException {
        String string2 = "getArray()";
        if (this._oInputMessage == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No input message available, cause: 4007");
            throw new ASelectCommunicationException("4007");
        }
        String[] stringArray = null;
        NodeList nodeList = this._elInputRPCBody.getElementsByTagNameNS(this._sMethodEnv, string);
        if (nodeList.getLength() != 1) {
            StringBuffer stringBuffer = new StringBuffer("SOAP Message contains multiple params with the same name: ");
            stringBuffer.append(string);
            stringBuffer.append(", cause: ");
            stringBuffer.append("4007");
            this._systemLogger.log(Level.FINE, MODULE, string2, stringBuffer.toString());
            throw new ASelectCommunicationException("4007");
        }
        stringArray = this.resolveArray((Element)nodeList.item(0));
        return stringArray;
    }

    public boolean setParam(String string, String string2) throws ASelectCommunicationException {
        String string3 = "setParam()";
        if (this._oOutputMessage == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string3, "No output message available, cause: 4007");
            throw new ASelectCommunicationException("4007");
        }
        Text text = this._oOutputMessage.createTextNode(string2);
        NodeList nodeList = this._elOutputRPCBody.getElementsByTagNameNS(this._sMethodEnv, string);
        if (nodeList.getLength() != 1) {
            Element element = this._oOutputMessage.createElementNS(this._sMethodEnv, "m:" + string);
            element.appendChild(text);
            this._elOutputRPCBody.appendChild(element);
        } else {
            this._systemLogger.log(Level.INFO, MODULE, string3, "Updating parameter: " + string);
            Element element = (Element)nodeList.item(0);
            Node node = element.getFirstChild();
            element.replaceChild(text, node);
        }
        return true;
    }

    public boolean setParam(String string, String[] stringArray) throws ASelectCommunicationException {
        String string2 = "setParam()";
        if (this._oOutputMessage == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "No output message available, cause: 4007");
            throw new ASelectCommunicationException("4007");
        }
        Element element = this.arrayToXML(string, stringArray);
        NodeList nodeList = this._elOutputRPCBody.getElementsByTagNameNS("http://www.w3.org/2001/12/soap-encoding", string);
        if (nodeList.getLength() != 1) {
            this._elOutputRPCBody.appendChild(element);
        } else {
            this._elOutputRPCBody.replaceChild(element, nodeList.item(0));
        }
        return true;
    }

    public boolean send() throws ASelectCommunicationException {
        String string = "send()";
        if (this._oOutputMessage == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Message is already sent, there is no output message, cause: 4007");
            throw new ASelectCommunicationException("4007");
        }
        try {
            OutputFormat outputFormat = new OutputFormat(this._oOutputMessage);
            outputFormat.setLineSeparator("\n");
            outputFormat.setIndenting(true);
            outputFormat.setLineWidth(80);
            XMLSerializer xMLSerializer = new XMLSerializer(this._oResponse.getOutputStream(), outputFormat);
            xMLSerializer.setNamespaces(true);
            xMLSerializer.serialize(this._oOutputMessage.getDocumentElement());
            this._oOutputMessage = null;
            this._elOutputBody = null;
            this._elOutputRPCBody = null;
            this._oInputMessage = null;
            return true;
        }
        catch (IOException iOException) {
            StringBuffer stringBuffer = new StringBuffer("DOM object could not be serialized: ");
            stringBuffer.append(iOException.getMessage());
            stringBuffer.append(", cause: ");
            stringBuffer.append("4006");
            this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), iOException);
            throw new ASelectCommunicationException("4006", iOException);
        }
    }

    private Element arrayToXML(String string, String[] stringArray) {
        Element element = this._oOutputMessage.createElementNS(this._sMethodEnv, "m:" + string);
        element.setAttributeNS(this._sMethodEnv, "arrayType", "xsd:string[" + stringArray.length + "]");
        for (int i = 0; i < stringArray.length; ++i) {
            Element element2 = this._oOutputMessage.createElementNS(this._sMethodEnv, "m:item");
            Text text = this._oOutputMessage.createTextNode(stringArray[i]);
            element2.appendChild(text);
            element.appendChild(element2);
        }
        return element;
    }

    private String[] resolveArray(Element element) throws ASelectCommunicationException {
        Object object;
        int n;
        String string = "resolveArray()";
        String[] stringArray = null;
        String string2 = null;
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (n = 0; n < namedNodeMap.getLength(); ++n) {
            object = namedNodeMap.item(0);
            if (!object.getLocalName().equalsIgnoreCase("arrayType")) continue;
            string2 = (String)object.getNodeValue().subSequence(object.getNodeValue().lastIndexOf("[") + 1, object.getNodeValue().lastIndexOf("]"));
        }
        try {
            n = new Integer(string2);
            int n2 = 0;
            stringArray = new String[n];
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node;
                if (nodeList.item(i).getNodeType() != 1 || (node = nodeList.item(i).getFirstChild()).getNodeType() != 3 || n2 >= n) continue;
                stringArray[n2++] = node.getNodeValue();
            }
            if (stringArray == null) {
                StringBuffer stringBuffer = new StringBuffer("Could not resolve array. Resolved array length: ");
                stringBuffer.append(string2);
                stringBuffer.append(", cause: ");
                stringBuffer.append("0001");
                this._systemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
                throw new ASelectCommunicationException("0001");
            }
        }
        catch (NumberFormatException numberFormatException) {
            object = new StringBuffer("Error during resolving array (invalid 'arraySize'): ");
            ((StringBuffer)object).append(numberFormatException.getMessage());
            ((StringBuffer)object).append(", cause: ");
            ((StringBuffer)object).append("4008");
            this._systemLogger.log(Level.WARNING, MODULE, string, ((StringBuffer)object).toString(), numberFormatException);
            throw new ASelectCommunicationException("4008", numberFormatException);
        }
        return stringArray;
    }

    private Document createInputMessage() throws ASOAPException {
        Object object;
        Object object2;
        String string = "createInputMessage()";
        Document document = null;
        try {
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setNamespaceAware(true);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            ((DocumentBuilder)object).setErrorHandler(new SOAP11ErrorHandler());
            document = ((DocumentBuilder)object).parse(this._oRequest.getInputStream());
        }
        catch (SAXParseException sAXParseException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Bad request, could not parse request.", sAXParseException);
            throw new ASOAPException(3, "Bad request", sAXParseException.getMessage());
        }
        catch (SAXException sAXException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Bad request, could not parse request.", sAXException);
            throw new ASOAPException(3, "Bad request", sAXException.getMessage());
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Internal server error, could not open soap request.", iOException);
            throw new ASOAPException(4, "Internal server error", iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Internal server error", parserConfigurationException);
            throw new ASOAPException(4, "Internal server error", parserConfigurationException.getMessage());
        }
        object2 = document.getDocumentElement();
        object = object2.getLocalName();
        if (!((String)object).equals("Envelope")) {
            this._systemLogger.log(Level.WARNING, MODULE, string, "Version Mismatch, invalid envelope tag name.");
            String string2 = null;
            throw new ASOAPException(1, "Version Mismatch", string2);
        }
        String string3 = object2.getNamespaceURI();
        if (string3 != null) {
            this._sInputMessageSchema = string3;
            this._elInputBody = this.getChildElementNS((Element)object2, "Body", this._sInputMessageSchema);
        } else {
            this._elInputBody = this.getChildElement((Element)object2, "Body");
        }
        if (this._elInputBody == null) {
            this._systemLogger.log(Level.INFO, MODULE, string, "Bad request, No Body element found.");
            throw new ASOAPException(3, "Bad request", "SOAP message must contain mandatory Body element.");
        }
        this._elInputRPCBody = this.getChildElementNS(this._elInputBody, this._sMethodName, this._sMethodEnv);
        if (this._elInputRPCBody == null) {
            this._systemLogger.log(Level.INFO, MODULE, string, "Bad request, No correct RPC Body found while looking for: " + this._sMethodName);
            throw new ASOAPException(3, "Bad request", "Unsupported request received, invalid RPC body.");
        }
        return document;
    }

    private Document createOutputMessage() {
        this._oResponse.setProperty("Content-Type", "text/xml; charset=utf-8");
        DocumentImpl documentImpl = new DocumentImpl();
        Element element = documentImpl.createElementNS(this._sInputMessageSchema, "env:Envelope");
        element.setAttributeNS(this._sInputMessageSchema, "env:encodingStyle", "http://www.w3.org/2001/12/soap-encoding");
        documentImpl.appendChild(element);
        this._elOutputBody = documentImpl.createElementNS(this._sInputMessageSchema, "env:Body");
        element.appendChild(this._elOutputBody);
        return documentImpl;
    }

    private Element createFault(String string, String string2, String string3) {
        Element element = this._oOutputMessage.createElementNS(this._sInputMessageSchema, "env:Fault");
        Element element2 = this._oOutputMessage.createElementNS(this._sInputMessageSchema, "env:Code");
        element.appendChild(element2);
        Element element3 = this._oOutputMessage.createElementNS(this._sInputMessageSchema, "env:Value");
        Text text = this._oOutputMessage.createTextNode("env:" + string);
        element3.appendChild(text);
        element2.appendChild(element3);
        Element element4 = this._oOutputMessage.createElementNS(this._sInputMessageSchema, "env:Reason");
        element.appendChild(element4);
        Element element5 = this._oOutputMessage.createElementNS(this._sInputMessageSchema, "env:Text");
        element5.setAttribute("xml:lang", "en-us");
        Text text2 = this._oOutputMessage.createTextNode(string2);
        element5.appendChild(text2);
        element4.appendChild(element5);
        if (string3 != null) {
            Element element6 = this._oOutputMessage.createElementNS(this._sInputMessageSchema, "env:Detail");
            element.appendChild(element6);
            Text text3 = this._oOutputMessage.createTextNode(string3);
            element6.appendChild(text3);
        }
        return element;
    }

    private Element getChildElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList.getLength() == 1) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private Element getChildElementNS(Element element, String string, String string2) {
        NodeList nodeList = element.getElementsByTagNameNS(string2, string);
        if (nodeList.getLength() == 1) {
            return (Element)nodeList.item(0);
        }
        return null;
    }
}

