/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.udb.sasdb;

import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.udb.IUDBConnector;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectUDBException;

public class SASDBConnector
implements IUDBConnector {
    private static final String MODULE = "SASDBConnector";
    private ASelectSystemLogger _oASelectSystemLogger;
    private ASelectAuthenticationLogger _oASelectAuthenticationLogger;
    private IUDBConnector _oIUDBConnector;
    private Hashtable _htFilters;
    private Vector _vAuthSPs;

    public void init(Object object) throws ASelectUDBException {
        String string = "init()";
        ASelectConfigManager aSelectConfigManager = null;
        Object object2 = null;
        String string2 = null;
        Object object3 = null;
        Object object4 = null;
        String string3 = null;
        Object object5 = null;
        Object object6 = null;
        Object object7 = null;
        try {
            String string4;
            Object object8;
            aSelectConfigManager = ASelectConfigManager.getHandle();
            this._oASelectSystemLogger = ASelectSystemLogger.getHandle();
            this._oASelectAuthenticationLogger = ASelectAuthenticationLogger.getHandle();
            try {
                object2 = aSelectConfigManager.getSection(object, "udb_storage");
            }
            catch (Exception exception) {
                object2 = null;
                this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, "No valid 'udb_storage' config section found in 'connector', disabling secondary user database.", (Throwable)exception);
            }
            if (object2 != null) {
                try {
                    string2 = aSelectConfigManager.getParam(object2, "connector");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, "No valid 'connector' config section found in 'udb_storage'", (Throwable)aSelectConfigException);
                    throw new ASelectUDBException("4009", (Throwable)aSelectConfigException);
                }
                try {
                    object5 = aSelectConfigManager.getSection(null, "udb");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, "No valid 'udb' config section found in A-Select config", (Throwable)aSelectConfigException);
                    throw new ASelectUDBException("4009", (Throwable)aSelectConfigException);
                }
                try {
                    object6 = aSelectConfigManager.getSection(object5, "connector", "id=" + string2);
                }
                catch (ASelectConfigException aSelectConfigException) {
                    StringBuffer stringBuffer = new StringBuffer("No valid 'connector' config section with id='");
                    stringBuffer.append(string2);
                    stringBuffer.append("' in 'udb' config section, as configured as 'udb_storage'");
                    this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, stringBuffer.toString(), (Throwable)aSelectConfigException);
                    throw new ASelectUDBException("4009", (Throwable)aSelectConfigException);
                }
                try {
                    string3 = aSelectConfigManager.getParam(object6, "class");
                }
                catch (Exception exception) {
                    StringBuffer stringBuffer = new StringBuffer("No valid 'class' config section found in 'connector' section with id='");
                    stringBuffer.append(string2);
                    stringBuffer.append("'");
                    this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, stringBuffer.toString(), (Throwable)exception);
                    throw new ASelectUDBException("4009", (Throwable)exception);
                }
                try {
                    object8 = Class.forName(string3);
                    this._oIUDBConnector = (IUDBConnector)((Class)object8).newInstance();
                }
                catch (Exception exception) {
                    StringBuffer stringBuffer = new StringBuffer("Invalid 'class' config item isn't a valid class: ");
                    stringBuffer.append(string3);
                    this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, stringBuffer.toString(), (Throwable)exception);
                    throw new ASelectUDBException("4009", (Throwable)exception);
                }
                try {
                    this._oIUDBConnector.init(object6);
                }
                catch (Exception exception) {
                    StringBuffer stringBuffer = new StringBuffer("Could not initialize the configured UDB Connector: ");
                    stringBuffer.append(string3);
                    this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, stringBuffer.toString(), (Throwable)exception);
                    throw new ASelectUDBException("4009", (Throwable)exception);
                }
            }
            this._htFilters = new Hashtable();
            try {
                object3 = aSelectConfigManager.getSection(object, "filters");
            }
            catch (Exception exception) {
                object3 = null;
                this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, "No valid 'filters' config section found in 'connector' section", (Throwable)exception);
                throw new ASelectUDBException("4009", (Throwable)exception);
            }
            try {
                object7 = aSelectConfigManager.getSection(object3, "filter");
            }
            catch (Exception exception) {
                object7 = null;
                this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, "No valid 'filter' config section found in 'filters' section, disabling filters", (Throwable)exception);
            }
            while (object7 != null) {
                object8 = null;
                string4 = null;
                try {
                    object8 = aSelectConfigManager.getParam(object7, "id");
                }
                catch (Exception exception) {
                    this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, "No valid 'id' config item found in 'filter' config section", (Throwable)exception);
                    throw new ASelectUDBException("4009", (Throwable)exception);
                }
                try {
                    Integer.parseInt((String)object8);
                }
                catch (Exception exception) {
                    StringBuffer stringBuffer = new StringBuffer("'id' config item is not an integer value: ");
                    stringBuffer.append((String)object8);
                    this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, stringBuffer.toString(), (Throwable)exception);
                    throw new ASelectUDBException("4009", (Throwable)exception);
                }
                if (this._htFilters.containsKey(object8)) {
                    StringBuffer stringBuffer = new StringBuffer("'id' config item already exists: ");
                    stringBuffer.append((String)object8);
                    this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, stringBuffer.toString());
                    throw new ASelectUDBException("4009");
                }
                try {
                    string4 = aSelectConfigManager.getParam(object7, "pattern");
                }
                catch (Exception exception) {
                    this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, "No valid 'pattern' config item found in 'filter' config section", (Throwable)exception);
                    throw new ASelectUDBException("4009", (Throwable)exception);
                }
                if (!string4.startsWith("uid=") && !string4.startsWith("uid!=")) {
                    StringBuffer stringBuffer = new StringBuffer("No valid 'pattern' config item found in 'filter' config section: ");
                    stringBuffer.append(string4);
                    this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, stringBuffer.toString());
                    throw new ASelectUDBException("4009");
                }
                this._htFilters.put(object8, string4);
                object7 = aSelectConfigManager.getNextSection(object7);
            }
            this._vAuthSPs = new Vector();
            try {
                object4 = aSelectConfigManager.getSection(object, "authsps");
            }
            catch (Exception exception) {
                object4 = null;
                this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, "No valid 'authsps' config section found in 'connector' section", (Throwable)exception);
                throw new ASelectUDBException("4009", (Throwable)exception);
            }
            object8 = null;
            try {
                object8 = aSelectConfigManager.getSection(object4, "authsp");
            }
            catch (Exception exception) {
                object7 = null;
                this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, "No valid 'authsp' config section found in 'authsps' config section within 'connector' config section", (Throwable)exception);
                throw new ASelectUDBException("4009", (Throwable)exception);
            }
            while (object8 != null) {
                string4 = null;
                try {
                    string4 = aSelectConfigManager.getParam(object8, "id");
                }
                catch (Exception exception) {
                    this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string, "No valid 'id' config item found in 'authsp' config section", (Throwable)exception);
                    throw new ASelectUDBException("4009", (Throwable)exception);
                }
                this._vAuthSPs.add(string4);
                object8 = aSelectConfigManager.getNextSection(object8);
            }
        }
        catch (ASelectUDBException aSelectUDBException) {
            throw aSelectUDBException;
        }
        catch (Exception exception) {
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize SASDB connector", (Throwable)exception);
            throw new ASelectUDBException("0001", (Throwable)exception);
        }
    }

    public Hashtable getUserProfile(String string) {
        String string2 = "getUserProfile()";
        Hashtable hashtable = new Hashtable();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        try {
            Hashtable hashtable3;
            String string3;
            if (this._oIUDBConnector != null && (string3 = (String)(hashtable3 = this._oIUDBConnector.getUserProfile(string)).get("result_code")).equals("0000")) {
                hashtable = hashtable3;
            }
            if (hashtable.isEmpty()) {
                CharSequence charSequence;
                int n = this._htFilters.size();
                boolean bl = false;
                for (int i = 1; i <= n; ++i) {
                    charSequence = (String)this._htFilters.get("" + i);
                    if (charSequence == null) {
                        StringBuffer stringBuffer = new StringBuffer("SASDB filters are not configured in a following order.");
                        this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string2, stringBuffer.toString());
                        break;
                    }
                    if (((String)charSequence).startsWith("uid=")) {
                        bl = this.matchFilter(string, ((String)charSequence).substring(4));
                    } else if (((String)charSequence).startsWith("uid!=")) {
                        boolean bl2 = bl = !this.matchFilter(string, ((String)charSequence).substring(5));
                    }
                    if (bl) continue;
                    StringBuffer stringBuffer = new StringBuffer("User is not allowed to use the SASDBHandler: ");
                    stringBuffer.append(string);
                    this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer.toString());
                    this.logAuthentication(string, "0002", "User unknown");
                    throw new ASelectUDBException("0002");
                }
                Enumeration enumeration = this._vAuthSPs.elements();
                while (enumeration.hasMoreElements()) {
                    charSequence = (String)enumeration.nextElement();
                    hashtable2.put((String)charSequence, string);
                }
                if (hashtable2.isEmpty()) {
                    charSequence = new StringBuffer("No user attributes found for user: ");
                    ((StringBuffer)charSequence).append(string);
                    this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, ((StringBuffer)charSequence).toString());
                    throw new ASelectUDBException("0003");
                }
                hashtable.put("result_code", "0000");
                hashtable.put("user_authsps", hashtable2);
            }
        }
        catch (ASelectUDBException aSelectUDBException) {
            hashtable.put("result_code", aSelectUDBException.getMessage());
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Failed to fetch profile of user ");
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append(exception.getMessage());
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer.toString(), (Throwable)exception);
            hashtable.put("result_code", "0060");
        }
        return hashtable;
    }

    public String getUserAttributes(String string, String string2) throws ASelectUDBException {
        String string3 = "getUserAttributes()";
        String string4 = null;
        if (this._oIUDBConnector != null) {
            string4 = this._oIUDBConnector.getUserAttributes(string, string2);
        }
        if (string4 == null) {
            int n = this._htFilters.size();
            boolean bl = false;
            for (int i = 1; i <= n; ++i) {
                String string5 = (String)this._htFilters.get("" + i);
                if (string5 == null) {
                    StringBuffer stringBuffer = new StringBuffer("SASDB filters are not configured in a following order.");
                    this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string3, stringBuffer.toString());
                    break;
                }
                if (string5.startsWith("uid=")) {
                    bl = this.matchFilter(string, string5.substring(4));
                } else if (string5.startsWith("uid!=")) {
                    boolean bl2 = bl = !this.matchFilter(string, string5.substring(5));
                }
                if (bl) continue;
                i = n;
            }
            if (!bl) {
                StringBuffer stringBuffer = new StringBuffer("User is not allowed to use the SASDBHandler: ");
                stringBuffer.append(string);
                this._oASelectSystemLogger.log(Level.FINE, MODULE, string3, stringBuffer.toString());
            } else {
                string4 = string;
            }
        }
        return string4;
    }

    public boolean isUserEnabled(String string) throws ASelectUDBException {
        String string2 = "isUserEnabled()";
        boolean bl = false;
        if (this._oIUDBConnector != null) {
            bl = this._oIUDBConnector.isUserEnabled(string);
        }
        if (!bl) {
            int n = this._htFilters.size();
            boolean bl2 = false;
            for (int i = 1; i <= n; ++i) {
                String string3 = (String)this._htFilters.get("" + i);
                if (string3 == null) {
                    StringBuffer stringBuffer = new StringBuffer("SASDB filters are not configured in a following order.");
                    this._oASelectSystemLogger.log(Level.CONFIG, MODULE, string2, stringBuffer.toString());
                    break;
                }
                if (string3.startsWith("uid=")) {
                    bl2 = this.matchFilter(string, string3.substring(4));
                } else if (string3.startsWith("uid!=")) {
                    boolean bl3 = bl2 = !this.matchFilter(string, string3.substring(5));
                }
                if (bl2) continue;
                i = n;
            }
            if (!(bl = bl2)) {
                StringBuffer stringBuffer = new StringBuffer("User is not allowed to use the SASDBHandler: '");
                stringBuffer.append(string).append("'");
                this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer.toString());
            }
        }
        return bl;
    }

    private boolean matchFilter(String string, String string2) {
        char c = '\u0000';
        int n = 0;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string2);
        c = stringCharacterIterator.first();
        while (c != '\uffff' && n < string.length()) {
            if (c == '?') {
                ++n;
            } else {
                if (c == '*') {
                    int n2 = stringCharacterIterator.getIndex() + 1;
                    if (n2 >= string2.length()) {
                        return true;
                    }
                    String string3 = string2.substring(n2);
                    while (n < string.length()) {
                        if (this.matchFilter(string.substring(n), string3)) {
                            return true;
                        }
                        ++n;
                    }
                    return false;
                }
                if (c == string.charAt(n)) {
                    ++n;
                } else {
                    return false;
                }
            }
            c = stringCharacterIterator.next();
        }
        return n == string.length();
    }

    private void logAuthentication(String string, String string2, String string3) {
        this._oASelectAuthenticationLogger.log(new Object[]{MODULE, string, null, null, null, string3, string2});
    }
}

