/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.authsp.pki.crl.handler.ldap;

import java.io.ByteArrayInputStream;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import org.aselect.authspserver.authsp.pki.crl.handler.ICRLHandler;
import org.aselect.authspserver.authsp.pki.crl.handler.ldap.LDAPURL;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.system.exception.ASelectException;

public class LDAPCRLHandler
implements ICRLHandler {
    public static final String MODULE = "HttpCRLHandler";
    private AuthSPSystemLogger _systemLogger;

    public void init(AuthSPSystemLogger authSPSystemLogger) {
        this._systemLogger = authSPSystemLogger;
    }

    public CRL getCRL(String string) throws ASelectException {
        String string2 = "getCRL()";
        CRL cRL = null;
        CertificateFactory certificateFactory = null;
        LDAPURL lDAPURL = null;
        Hashtable<String, Object> hashtable = null;
        InitialDirContext initialDirContext = null;
        NamingEnumeration<? extends Attribute> namingEnumeration = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException certificateException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Internal error occured by creating instance of CertificateFactory", (Throwable)certificateException);
            throw new ASelectException("010");
        }
        lDAPURL = new LDAPURL(string);
        hashtable = new Hashtable<String, Object>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", lDAPURL.getServerUrl());
        String[] stringArray = new String[]{lDAPURL.getAttributes()};
        String string3 = lDAPURL.getDn();
        try {
            initialDirContext = new InitialDirContext(hashtable);
            Attributes attributes = initialDirContext.getAttributes(string3, stringArray);
            namingEnumeration = attributes.getAll();
            Attribute attribute = namingEnumeration.next();
            Object object = attribute.get();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            cRL = certificateFactory.generateCRL(byteArrayInputStream);
        }
        catch (NamingException namingException) {
            this._systemLogger.log(Level.INFO, MODULE, string2, "Failed to retrieve attributes from LDAP Server: " + string, (Throwable)namingException);
            throw new ASelectException("108");
        }
        catch (CRLException cRLException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not generate CRL: " + string, (Throwable)cRLException);
            throw new ASelectException("108");
        }
        finally {
            try {
                if (namingEnumeration != null) {
                    namingEnumeration.close();
                }
                if (initialDirContext != null) {
                    initialDirContext.close();
                }
            }
            catch (Exception exception) {}
        }
        return cRL;
    }
}

