/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.authsp.pki.crl.handler.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.logging.Level;
import org.aselect.authspserver.authsp.pki.crl.handler.ICRLHandler;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.system.exception.ASelectException;

public class FileCRLHandler
implements ICRLHandler {
    public static final String MODULE = "FileCRLHandler";
    private AuthSPSystemLogger _systemLogger;

    public void init(AuthSPSystemLogger authSPSystemLogger) {
        this._systemLogger = authSPSystemLogger;
    }

    public CRL getCRL(String string) throws ASelectException {
        String string2 = "getCRL()";
        CertificateFactory certificateFactory = null;
        FileInputStream fileInputStream = null;
        CRL cRL = null;
        Object var6_6 = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X509");
        }
        catch (CertificateException certificateException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Internal error occured by creating instance of CertificateFactory", (Throwable)certificateException);
            throw new ASelectException("010");
        }
        try {
            String string3 = string.substring(7);
            File file = new File(string3);
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this._systemLogger.log(Level.INFO, MODULE, string2, string, (Throwable)fileNotFoundException);
            throw new ASelectException("101");
        }
        try {
            cRL = certificateFactory.generateCRL(fileInputStream);
        }
        catch (CRLException cRLException) {
            this._systemLogger.log(Level.WARNING, MODULE, string2, "Could not generate CRL: " + string, (Throwable)cRLException);
            throw new ASelectException("108");
        }
        return cRL;
    }
}

