/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.authspserver.authsp.pki;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.authspserver.authsp.pki.PKIManager;
import org.aselect.authspserver.authsp.pki.cert.handler.ldap.LDAPCertificateHandler;
import org.aselect.authspserver.config.AuthSPConfigManager;
import org.aselect.authspserver.crypto.CryptoEngine;
import org.aselect.authspserver.log.AuthSPAuthenticationLogger;
import org.aselect.authspserver.log.AuthSPSystemLogger;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Utils;

public class PKIAuthSP
extends HttpServlet {
    public static final String MODULE = "PKIAuthSP";
    private String _sVersion = "1.0";
    private String _sErrorHtmlTemplate = "";
    private String _sTFHtmlTemplate = "";
    private String _sFriendlyName = null;
    private String _sWorkingDir = null;
    private String _sLoggingDir = null;
    private CryptoEngine _oCryptoEngine = null;
    private AuthSPAuthenticationLogger _authenticationLogger;
    private AuthSPSystemLogger _systemLogger;
    private AuthSPConfigManager _oConfigManager = null;
    private Object _oAuthSpConfig = null;
    private PKIManager _oPkiManager = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        String string = "init()";
        Object var3_3 = null;
        try {
            super.init(servletConfig);
            ServletContext servletContext = servletConfig.getServletContext();
            try {
                this._systemLogger = AuthSPSystemLogger.getHandle();
                this._authenticationLogger = AuthSPAuthenticationLogger.getHandle();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                throw new ServletException("Error occured by init SystemLogger");
            }
            this._sWorkingDir = (String)servletContext.getAttribute("working_dir");
            if (this._sWorkingDir == null) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "working_dir attribute not found");
                throw new ServletException("working_dir attribute not found");
            }
            this._oConfigManager = AuthSPConfigManager.getHandle();
            String string2 = servletConfig.getInitParameter("config_id");
            if (string2 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "No 'config_id' found as init-parameter in web.xml.");
                throw new ASelectException("010");
            }
            try {
                this._oAuthSpConfig = this._oConfigManager.getSection(null, "authsp", "id=" + string2);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, aSelectConfigException.getMessage(), (Throwable)aSelectConfigException);
                throw new ServletException("Error occured by init PKI AuthSP, see the PKI AuthSP log files for more information");
            }
            this._oCryptoEngine = (CryptoEngine)servletContext.getAttribute("CryptoEngine");
            if (this._oCryptoEngine == null) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "CryptoEngine not found");
                throw new ServletException("CryptoEngine not found");
            }
            this._sFriendlyName = (String)servletContext.getAttribute("friendly_name");
            if (this._sFriendlyName == null) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "friendly_name attribute not found");
                throw new ServletException("friendly_name attribute not found");
            }
            this.initHtmlTemplates();
            try {
                Object object = this._oConfigManager.getSection(this._oAuthSpConfig, "ca_validation");
                this._oPkiManager = new PKIManager();
                this._oPkiManager.init(object, this._systemLogger);
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Failed to read 'ca_validation' configuration", (Throwable)aSelectConfigException);
                throw aSelectConfigException;
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Failed to initialize PKIManager", (Throwable)aSelectException);
                throw aSelectException;
            }
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Initializing failed", (Throwable)exception);
            throw new ServletException("Initializing failed");
        }
        this._systemLogger.log(Level.INFO, MODULE, string, "PKI AuthSP successfully initialized.");
    }

    public void destroy() {
        this._oPkiManager.destroy();
        super.destroy();
    }

    public void initHtmlTemplates() throws ServletException {
        String string = "initHtmlTemplates()";
        String string2 = null;
        try {
            StringBuffer stringBuffer = new StringBuffer(this._sWorkingDir);
            stringBuffer.append(File.separator).append("conf").append(File.separator);
            stringBuffer.append("pki").append(File.separator).append("html");
            stringBuffer.append(File.separator).append("error.html");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(stringBuffer.toString())));
            while ((string2 = bufferedReader.readLine()) != null) {
                this._sErrorHtmlTemplate = this._sErrorHtmlTemplate + string2;
            }
            this._sErrorHtmlTemplate = Utils.replaceString((String)this._sErrorHtmlTemplate, (String)"[version]", (String)this._sVersion);
            this._sErrorHtmlTemplate = Utils.replaceString((String)this._sErrorHtmlTemplate, (String)"[organization_friendly]", (String)this._sFriendlyName);
            stringBuffer = new StringBuffer(this._sWorkingDir);
            stringBuffer.append(File.separator).append("conf").append(File.separator);
            stringBuffer.append("pki").append(File.separator).append("html");
            stringBuffer.append(File.separator).append("twofactor.html");
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(stringBuffer.toString())));
            while ((string2 = bufferedReader.readLine()) != null) {
                this._sTFHtmlTemplate = this._sTFHtmlTemplate + string2 + "\r";
            }
            this._sTFHtmlTemplate = Utils.replaceString((String)this._sTFHtmlTemplate, (String)"[version]", (String)this._sVersion);
            this._sTFHtmlTemplate = Utils.replaceString((String)this._sTFHtmlTemplate, (String)"[organization_friendly]", (String)this._sFriendlyName);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
            throw new ServletException("Error occured by init PKI AuthSP, see the PKI AuthSP log files for more information");
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, iOException.getMessage(), (Throwable)iOException);
            throw new ServletException("Error occured by init PKI AuthSP, see the PKI AuthSP log files for more information");
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = "doPost()";
        StringBuffer stringBuffer = null;
        try {
            String string2 = httpServletRequest.getParameter("as_url");
            String string3 = httpServletRequest.getParameter("rid");
            String string4 = httpServletRequest.getParameter("user_attribute");
            String string5 = httpServletRequest.getParameter("a-select-server");
            String string6 = httpServletRequest.getParameter("password");
            String string7 = httpServletRequest.getParameter("tf_authsp");
            String string8 = httpServletRequest.getParameter("tf_url");
            String string9 = httpServletRequest.getParameter("tf_uid");
            String string10 = httpServletRequest.getParameter("tf_retries");
            String string11 = httpServletRequest.getRequestURL().toString();
            String string12 = httpServletRequest.getParameter("signature");
            stringBuffer = new StringBuffer(string3).append(string2).append(string4).append(string5).append(string7).append(string8).append(string9).append(string10).append(string11);
            String string13 = this._oCryptoEngine.generateSignature(stringBuffer.toString());
            if (!string13.equals(string12)) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "Invalid signature");
                throw new ASelectException("009");
            }
            boolean bl = this.verifyTFAuthentication(string3, string8, string9, string6);
            if (!bl) {
                int n = new Integer(string10);
                if (--n <= 0) {
                    this._systemLogger.log(Level.SEVERE, MODULE, string, "No retries for 2-factor authentication left");
                    throw new ASelectException("008");
                }
                String string14 = "invalid password";
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("as_url", string2);
                hashtable.put("rid", string3);
                hashtable.put("user_attribute", string4);
                hashtable.put("a-select-server", string5);
                hashtable.put("tf_authsp", string7);
                hashtable.put("tf_url", string8);
                hashtable.put("tf_uid", string9);
                hashtable.put("tf_retries", "" + n);
                hashtable.put("error_msg", string14);
                this.handleTFAuthenticationRequest(httpServletRequest, httpServletResponse, string3, hashtable);
            } else {
                this.handleAuthenticate(httpServletRequest, httpServletResponse);
            }
        }
        catch (ASelectException aSelectException) {
            this.handleResult(httpServletRequest, httpServletResponse, aSelectException.getMessage());
        }
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        String string = "doGet()";
        try {
            String string2 = httpServletRequest.getParameter("as_url");
            String string3 = httpServletRequest.getParameter("rid");
            String string4 = httpServletRequest.getParameter("user_attribute");
            String string5 = httpServletRequest.getParameter("a-select-server");
            String string6 = httpServletRequest.getParameter("tf_authsp");
            String string7 = httpServletRequest.getParameter("tf_url");
            String string8 = httpServletRequest.getParameter("tf_retries");
            String string9 = httpServletRequest.getParameter("tf_uid");
            String string10 = httpServletRequest.getParameter("signature");
            boolean bl = this.verifySignature(string3, string2, string4, string5, string6, string7, string8, string9, string10);
            if (!bl) {
                this._systemLogger.log(Level.SEVERE, MODULE, string, "Invalid signature");
                throw new ASelectException("009");
            }
            if (string6 != null) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("as_url", string2);
                hashtable.put("rid", string3);
                hashtable.put("user_attribute", string4);
                hashtable.put("a-select-server", string5);
                hashtable.put("tf_authsp", string6);
                hashtable.put("tf_url", string7);
                hashtable.put("tf_retries", string8);
                hashtable.put("tf_uid", string9);
                this.handleTFAuthenticationRequest(httpServletRequest, httpServletResponse, string3, hashtable);
            } else {
                this.handleAuthenticate(httpServletRequest, httpServletResponse);
            }
        }
        catch (ASelectException aSelectException) {
            this.handleResult(httpServletRequest, httpServletResponse, aSelectException.getMessage());
        }
    }

    public void handleAuthenticate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        String string = "000";
        String string2 = "handleAuthenticate()";
        try {
            Object object;
            X509Certificate[] x509CertificateArray = null;
            X509Certificate x509Certificate = null;
            String string3 = null;
            String string4 = "true";
            String string5 = "true";
            String string6 = "true";
            String string7 = "false";
            String string8 = httpServletRequest.getParameter("user_attribute");
            Object object2 = this._oConfigManager.getSection(this._oAuthSpConfig, "date_validation");
            string4 = this._oConfigManager.getParam(object2, "enabled");
            Object object3 = this._oConfigManager.getSection(this._oAuthSpConfig, "ca_validation");
            string5 = this._oConfigManager.getParam(object3, "enabled");
            x509CertificateArray = (X509Certificate[])httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
            if (x509CertificateArray == null || x509CertificateArray.length <= 0) {
                this._systemLogger.log(Level.FINE, MODULE, string2, "No Client Certificate Provided");
                throw new ASelectException("001");
            }
            x509Certificate = x509CertificateArray[0];
            if (!string4.equalsIgnoreCase("false")) {
                this._oPkiManager.validateCertificateDate(x509Certificate);
            }
            if (!string5.equalsIgnoreCase("false")) {
                object = this._oPkiManager.getTrustedCACertificate(x509Certificate);
                string3 = (String)((Hashtable)object).get("caAlias");
                X509Certificate x509Certificate2 = (X509Certificate)((Hashtable)object).get("caCert");
                try {
                    this._oPkiManager.validateCertificateDate(x509Certificate2);
                }
                catch (ASelectException aSelectException) {
                    this._systemLogger.log(Level.WARNING, MODULE, string2, "CA cert: " + string3 + " is expired.");
                    throw new ASelectException("109");
                }
                Object object4 = this._oConfigManager.getSection(object3, "ca", "alias=" + string3);
                Object object5 = this._oConfigManager.getSection(object4, "crl_check");
                string6 = this._oConfigManager.getParam(object5, "enabled");
                if (!string6.equalsIgnoreCase("false") && this._oPkiManager.isClientCertRevoked(string3, x509Certificate)) {
                    this._systemLogger.log(Level.WARNING, MODULE, string2, "Client Certifcate is Revoked.");
                    throw new ASelectException("005");
                }
                Object object6 = this._oConfigManager.getSection(object4, "binary_blob_check");
                string7 = this._oConfigManager.getParam(object6, "enabled");
                if (string7.equalsIgnoreCase("true") && !this.validateBinaryBlob(object6, string8, x509Certificate)) {
                    this._systemLogger.log(Level.WARNING, MODULE, string2, "Client Certifcate Blob is not valid.");
                    throw new ASelectException("006");
                }
            }
            if (string7.equalsIgnoreCase("false")) {
                object = ((Object)x509Certificate.getSubjectDN()).toString().trim();
                if (!string8.trim().equalsIgnoreCase((String)object)) {
                    StringBuffer stringBuffer = new StringBuffer("Subject DN: '").append((String)object).append("' is different from the one provided in the ASelect UDB: '").append(string8).append("'");
                    this._systemLogger.log(Level.INFO, MODULE, string2, stringBuffer.toString());
                    throw new ASelectException("007");
                }
            }
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, aSelectConfigException.getMessage(), (Throwable)aSelectConfigException);
            string = "010";
        }
        catch (ASelectException aSelectException) {
            string = aSelectException.getMessage();
        }
        this.handleResult(httpServletRequest, httpServletResponse, string);
    }

    public boolean validateBinaryBlob(Object object, String string, X509Certificate x509Certificate) throws ASelectException {
        String string2 = "validateBinaryBlob()";
        Object var5_5 = null;
        boolean bl = false;
        KeyStore keyStore = null;
        LDAPCertificateHandler lDAPCertificateHandler = new LDAPCertificateHandler();
        try {
            Object object2 = this._oConfigManager.getSection(object, "backend");
            lDAPCertificateHandler.init(this._systemLogger, object2);
            keyStore = lDAPCertificateHandler.getCertificates(string);
            int n = x509Certificate.hashCode();
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements() && !bl) {
                String string3 = enumeration.nextElement();
                X509Certificate x509Certificate2 = (X509Certificate)keyStore.getCertificate(string3);
                if (n != x509Certificate2.hashCode()) continue;
                bl = true;
            }
        }
        catch (KeyStoreException keyStoreException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not find retrieve certificates", (Throwable)keyStoreException);
            throw new ASelectException("010");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Could not find 'backend' configuration", (Throwable)aSelectConfigException);
            throw new ASelectException("101");
        }
        return bl;
    }

    private void handleResult(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws ServletException {
        String string2 = "handleResult()";
        StringBuffer stringBuffer = null;
        String string3 = httpServletRequest.getParameter("rid");
        String string4 = httpServletRequest.getParameter("as_url");
        String string5 = httpServletRequest.getParameter("a-select-server");
        String string6 = httpServletRequest.getParameter("uid");
        if (string3 == null || string4 == null || string5 == null) {
            String string7 = "009";
            String string8 = "Invalid Request";
            String string9 = new String(this._sErrorHtmlTemplate);
            string9 = Utils.replaceString((String)string9, (String)"[error]", (String)string7);
            string9 = Utils.replaceString((String)string9, (String)"[error_message]", (String)string8);
            try {
                this.sendPage(string9, httpServletRequest, httpServletResponse);
            }
            catch (IOException iOException) {
                this._systemLogger.log(Level.SEVERE, MODULE, string2, "Failed to show error message", (Throwable)iOException);
                throw new ServletException("Failed to show error message");
            }
            return;
        }
        stringBuffer = new StringBuffer(string3);
        stringBuffer.append(string4);
        stringBuffer.append(string);
        stringBuffer.append(string5);
        String string10 = null;
        try {
            string10 = this._oCryptoEngine.generateSignature(stringBuffer.toString());
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Error occured during creating signature");
            throw new ServletException("Error occured during creating signature");
        }
        if (string10 == null) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Error occured during creating signature");
            throw new ServletException("Error occured during creating signature");
        }
        try {
            string10 = URLEncoder.encode(string10, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
            throw new ServletException("Error by sending response\n See the PKI Authsp log files for more information ");
        }
        stringBuffer = new StringBuffer(string4);
        stringBuffer.append("&rid=").append(string3);
        stringBuffer.append("&result_code=").append(string);
        stringBuffer.append("&a-select-server=").append(string5);
        stringBuffer.append("&signature=").append(string10);
        try {
            httpServletResponse.sendRedirect(stringBuffer.toString());
            if (string.equals("000")) {
                this._authenticationLogger.log(new Object[]{MODULE, string6, httpServletRequest.getRemoteAddr(), string5, "granted"});
            } else {
                this._authenticationLogger.log(new Object[]{MODULE, string6, httpServletRequest.getRemoteAddr(), string5, "denied: " + string});
            }
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, iOException.getMessage(), (Throwable)iOException);
            throw new ServletException("Error by sending response. See the PKI Authsp log files for more information ");
        }
    }

    private boolean verifySignature(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws ASelectException {
        String string10 = "verifySignature()";
        boolean bl = false;
        if (string == null || string2 == null || string3 == null || string4 == null || string9 == null) {
            this._systemLogger.log(Level.WARNING, MODULE, string10, "not all parameters are provided");
            throw new ASelectException("009");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(string2);
        stringBuffer.append(string3);
        stringBuffer.append(string4);
        if (string5 != null && string6 != null && string7 != null && string8 != null) {
            stringBuffer.append(string5);
            stringBuffer.append(string6);
            stringBuffer.append(string7);
            stringBuffer.append(string8);
        }
        bl = this._oCryptoEngine.verifySignature(string4, stringBuffer.toString(), string9);
        return bl;
    }

    private void handleTFAuthenticationRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Hashtable hashtable) throws ASelectException {
        String string2 = "handleTFAuthenticationRequest()";
        String string3 = this._sTFHtmlTemplate;
        String string4 = (String)hashtable.get("as_url");
        String string5 = (String)hashtable.get("user_attribute");
        String string6 = (String)hashtable.get("a-select-server");
        String string7 = (String)hashtable.get("tf_authsp");
        String string8 = (String)hashtable.get("tf_url");
        String string9 = (String)hashtable.get("tf_retries");
        String string10 = (String)hashtable.get("tf_uid");
        String string11 = httpServletRequest.getRequestURL().toString();
        String string12 = (String)hashtable.get("error_msg");
        if (string12 == null) {
            string12 = "";
        }
        StringBuffer stringBuffer = new StringBuffer(string).append(string4).append(string5).append(string6).append(string7).append(string8).append(string10).append(string9).append(string11);
        String string13 = this._oCryptoEngine.generateSignature(stringBuffer.toString());
        string3 = Utils.replaceString((String)string3, (String)"[server]", (String)string11);
        string3 = Utils.replaceString((String)string3, (String)"[rid]", (String)string);
        string3 = Utils.replaceString((String)string3, (String)"[as_url]", (String)string4);
        string3 = Utils.replaceString((String)string3, (String)"[user_attribute]", (String)string5);
        string3 = Utils.replaceString((String)string3, (String)"[a-select-server]", (String)string6);
        string3 = Utils.replaceString((String)string3, (String)"[tf_authsp]", (String)string7);
        string3 = Utils.replaceString((String)string3, (String)"[tf_url]", (String)string8);
        string3 = Utils.replaceString((String)string3, (String)"[tf_uid]", (String)string10);
        string3 = Utils.replaceString((String)string3, (String)"[tf_retries]", (String)string9);
        string3 = Utils.replaceString((String)string3, (String)"[signature]", (String)string13);
        string3 = Utils.replaceString((String)string3, (String)"[error_msg]", (String)string12);
        try {
            this.sendPage(string3, httpServletRequest, httpServletResponse);
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.SEVERE, MODULE, string2, "Error by Sending 2-factor authentication page", (Throwable)iOException);
            throw new ASelectException("010", (Throwable)iOException);
        }
    }

    private boolean verifyTFAuthentication(String string, String string2, String string3, String string4) throws ASelectException {
        String string5 = "verifyTFAuthentication()";
        boolean bl = false;
        try {
            string3 = URLEncoder.encode(string3, "UTF-8");
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.append("?request=authenticate");
            stringBuffer.append("&rid=").append(string);
            stringBuffer.append("&user=").append(string3);
            stringBuffer.append("&password=").append(string4);
            stringBuffer.append("&as_url=").append("DUMMY");
            stringBuffer.append("&uid=").append("DUMMY");
            stringBuffer.append("&a-select-server=").append("DUMMY");
            stringBuffer.append("&retry_counter=").append("DUMMY");
            stringBuffer.append("&signature=").append("DUMMY");
            String string6 = this.send(stringBuffer.toString());
            Hashtable hashtable = Utils.convertCGIMessage((String)string6);
            String string7 = (String)hashtable.get("status");
            if (string7 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string5, "invalid response from 2-Factor AuthSP");
                throw new ASelectException("010");
            }
            string7.trim();
            if (string7.equals("000")) {
                bl = true;
            } else {
                this._systemLogger.log(Level.WARNING, MODULE, string5, "Error from 2-Factor AuthSP: " + string7);
            }
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, MODULE, string5, "Error by sending request to the 2-Factor AuthSP" + iOException);
            throw new ASelectException("010", (Throwable)iOException);
        }
        return bl;
    }

    private String send(String string) throws IOException {
        URL uRL = new URL(string.toString());
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()), 16000);
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        return string2;
    }

    private void sendPage(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        if (httpServletRequest.getProtocol().equals("HTTP/1.1")) {
            httpServletResponse.setHeader("Cache-Control", "no-cache, must-revalidate");
        } else {
            httpServletResponse.setHeader("Pragma", "no-cache");
        }
        httpServletResponse.setHeader("Expires", "0");
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setContentLength(string.length());
        httpServletResponse.getWriter().write(string);
    }
}

