/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.aselect.authentication;

import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.processor.IProcessor;
import org.aselect.server.request.handler.aselect.authentication.ASelectAPIHandler;
import org.aselect.server.request.handler.aselect.authentication.ASelectBrowserHandler;
import org.aselect.server.request.handler.aselect.authentication.ApplicationAPIHandler;
import org.aselect.server.request.handler.aselect.authentication.ApplicationBrowserHandler;
import org.aselect.server.request.handler.aselect.authentication.AuthSPAPIHandler;
import org.aselect.server.request.handler.aselect.authentication.AuthSPBrowserHandler;
import org.aselect.server.request.handler.aselect.authentication.IRequestHandler;
import org.aselect.server.request.handler.aselect.authentication.RequestParser;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;

public class RequestHandlerFactory {
    private final String MODULE = "RequestHandlerFactory";
    private ASelectSystemLogger _systemLogger;
    private String _sMyServerId = null;
    private String _sMyOrg = null;
    private IProcessor _processorASelectBrowser;
    private static RequestHandlerFactory _instance;

    public static RequestHandlerFactory getHandle() {
        if (_instance == null) {
            _instance = new RequestHandlerFactory();
        }
        return _instance;
    }

    public void init(Object object, String string, String string2) throws ASelectException {
        this._sMyServerId = string;
        this._sMyOrg = string2;
        this._systemLogger = ASelectSystemLogger.getHandle();
        ASelectConfigManager aSelectConfigManager = ASelectConfigManager.getHandle();
        this._processorASelectBrowser = this.createProcessor(aSelectConfigManager, object, "aselect_browser");
    }

    public IRequestHandler createRequestHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectCommunicationException {
        String string = "createRequestHandler()";
        IRequestHandler iRequestHandler = null;
        RequestParser requestParser = new RequestParser(httpServletRequest);
        switch (requestParser.getRequestOrigin()) {
            case 0: {
                if (requestParser.getRequestType() == 0) {
                    iRequestHandler = new ApplicationAPIHandler(requestParser, httpServletRequest, httpServletResponse, this._sMyServerId, this._sMyOrg);
                    break;
                }
                iRequestHandler = new ApplicationBrowserHandler(httpServletRequest, httpServletResponse, this._sMyServerId, this._sMyOrg);
                break;
            }
            case 2: {
                if (requestParser.getRequestType() == 0) {
                    iRequestHandler = new ASelectAPIHandler(requestParser, httpServletRequest, httpServletResponse, this._sMyServerId, this._sMyOrg);
                    break;
                }
                iRequestHandler = new ASelectBrowserHandler(httpServletRequest, httpServletResponse, this._sMyServerId, this._sMyOrg, this._processorASelectBrowser);
                break;
            }
            case 1: {
                if (requestParser.getRequestType() == 0) {
                    iRequestHandler = new AuthSPAPIHandler(requestParser, httpServletRequest, httpServletResponse, this._sMyServerId, this._sMyOrg);
                    break;
                }
                iRequestHandler = new AuthSPBrowserHandler(httpServletRequest, httpServletResponse, this._sMyServerId, this._sMyOrg);
                break;
            }
            case 3: {
                if (requestParser.getRequestType() == 0) {
                    throw new ASelectCommunicationException("0030");
                }
                iRequestHandler = new ApplicationBrowserHandler(httpServletRequest, httpServletResponse, this._sMyServerId, this._sMyOrg);
                break;
            }
            default: {
                this._systemLogger.log(Level.WARNING, "RequestHandlerFactory", string, "Invalid request received.");
                throw new ASelectCommunicationException("0030");
            }
        }
        return iRequestHandler;
    }

    private RequestHandlerFactory() {
    }

    private IProcessor createProcessor(ASelectConfigManager aSelectConfigManager, Object object, String string) throws ASelectException {
        String string2 = "createProcessor()";
        IProcessor iProcessor = null;
        Object object2 = null;
        try {
            object2 = aSelectConfigManager.getSection(object, "processor", "id=" + string);
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.INFO, "RequestHandlerFactory", string2, "No optional 'processor' section found in configuration with id: " + string);
        }
        if (object2 != null) {
            String string3 = null;
            try {
                string3 = aSelectConfigManager.getParam(object2, "class");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.WARNING, "RequestHandlerFactory", string2, "No 'class' item in 'processor' section found in configuration", (Throwable)aSelectConfigException);
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this._systemLogger.log(Level.WARNING, "RequestHandlerFactory", string2, "Configured 'class' item in 'processor' section not found: " + string3, (Throwable)classNotFoundException);
                throw new ASelectException("4009");
            }
            Object var9_12 = null;
            try {
                var9_12 = clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                this._systemLogger.log(Level.WARNING, "RequestHandlerFactory", string2, "Could not instantiate: " + string3, (Throwable)instantiationException);
                throw new ASelectException("4009");
            }
            catch (IllegalAccessException illegalAccessException) {
                this._systemLogger.log(Level.WARNING, "RequestHandlerFactory", string2, "Could not access: " + string3, (Throwable)illegalAccessException);
                throw new ASelectException("4009");
            }
            try {
                iProcessor = var9_12;
            }
            catch (ClassCastException classCastException) {
                this._systemLogger.log(Level.WARNING, "RequestHandlerFactory", string2, "Configured class is not of type IProcessor: " + string3, (Throwable)classCastException);
                throw new ASelectException("4009");
            }
            try {
                iProcessor.init(aSelectConfigManager, object2);
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, "RequestHandlerFactory", string2, "Could not initialize: " + string3, (Throwable)aSelectException);
                throw new ASelectException("4009");
            }
            this._systemLogger.log(Level.INFO, "RequestHandlerFactory", string2, "Processor initialized: " + string3);
        }
        return iProcessor;
    }
}

