/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.aselect.authentication;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.application.ApplicationManager;
import org.aselect.server.attributes.AttributeGatherer;
import org.aselect.server.authspprotocol.handler.AuthSPHandlerManager;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.crypto.CryptoEngine;
import org.aselect.server.request.handler.aselect.authentication.AbstractAPIRequestHandler;
import org.aselect.server.request.handler.aselect.authentication.RequestParser;
import org.aselect.server.session.SessionManager;
import org.aselect.server.tgt.TGTManager;
import org.aselect.system.communication.server.IInputMessage;
import org.aselect.system.communication.server.IOutputMessage;
import org.aselect.system.communication.server.IProtocolRequest;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.exception.ASelectStorageException;
import org.aselect.system.utils.Utils;

public class ApplicationAPIHandler
extends AbstractAPIRequestHandler {
    private ASelectConfigManager _configManager;
    private TGTManager _oTGTManager;
    private SessionManager _sessionManager;
    private ApplicationManager _applicationManager;
    private AuthSPHandlerManager _authSPManagerManager;
    private CryptoEngine _cryptoEngine;

    public ApplicationAPIHandler(RequestParser requestParser, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws ASelectCommunicationException {
        super(requestParser, httpServletRequest, httpServletResponse, string, string2);
        this._sModule = "ApplicationAPIHandler";
        this._configManager = ASelectConfigManager.getHandle();
        this._oTGTManager = TGTManager.getHandle();
        this._sessionManager = SessionManager.getHandle();
        this._applicationManager = ApplicationManager.getHandle();
        this._authSPManagerManager = AuthSPHandlerManager.getHandle();
        this._cryptoEngine = CryptoEngine.getHandle();
    }

    protected void processAPIRequest(IProtocolRequest iProtocolRequest, IInputMessage iInputMessage, IOutputMessage iOutputMessage) throws ASelectException {
        String string = "processAPIRequest";
        String string2 = null;
        try {
            string2 = iInputMessage.getParam("request");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Unsupported API call", (Throwable)aSelectCommunicationException);
            throw new ASelectCommunicationException("0030");
        }
        if (string2.equals("authenticate")) {
            this.handleAuthenticateRequest(iProtocolRequest, iInputMessage, iOutputMessage);
        } else if (string2.equals("verify_credentials")) {
            this.handleVerifyCredentialsRequest(iInputMessage, iOutputMessage);
        } else if (string2.equals("get_app_level")) {
            this.handleGetAppLevelRequest(iInputMessage, iOutputMessage);
        } else if (string2.equals("kill_tgt")) {
            this.handleKillTGTRequest(iInputMessage, iOutputMessage);
        } else {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Unsupported API Call: " + string2);
            throw new ASelectCommunicationException("0030");
        }
    }

    private void handleAuthenticateRequest(IProtocolRequest iProtocolRequest, IInputMessage iInputMessage, IOutputMessage iOutputMessage) throws ASelectException {
        Serializable serializable;
        String string = "handleAuthenticateRequest()";
        String string2 = null;
        Integer n = null;
        Integer n2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Hashtable<String, Object> hashtable = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        if (!this._applicationManager.hasApplicationsConfigured()) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Invalid request since no applications are configured.");
            throw new ASelectException("0030");
        }
        try {
            string4 = iInputMessage.getParam("app_id");
            string3 = iInputMessage.getParam("app_url");
            string5 = iInputMessage.getParam("a-select-server");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Missing required parameters", (Throwable)aSelectCommunicationException);
            throw new ASelectCommunicationException("0030");
        }
        try {
            string6 = iInputMessage.getParam("uid");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.FINE, this._sModule, string, "No optional 'uid' parameter found.", (Throwable)aSelectCommunicationException);
        }
        try {
            string7 = iInputMessage.getParam("remote_organization");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.FINE, this._sModule, string, "No optional 'remote_organization' parameter found.", (Throwable)aSelectCommunicationException);
        }
        try {
            string9 = iInputMessage.getParam("country");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.FINE, this._sModule, string, "No optional 'country' parameter found.", (Throwable)aSelectCommunicationException);
        }
        try {
            string10 = iInputMessage.getParam("language");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.FINE, this._sModule, string, "No optional 'language' parameter found.", (Throwable)aSelectCommunicationException);
        }
        Boolean bl = null;
        try {
            string8 = iInputMessage.getParam("forced_logon");
            bl = new Boolean(string8);
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            bl = new Boolean(false);
            this._systemLogger.log(Level.FINE, this._sModule, string, "No optional 'forced_logon' parameter found.", (Throwable)aSelectCommunicationException);
        }
        if (this._applicationManager.isSigningRequired()) {
            serializable = new StringBuffer(string5);
            ((StringBuffer)serializable).append(string4).append(string3);
            if (string9 != null) {
                ((StringBuffer)serializable).append(string9);
            }
            if (string8 != null) {
                ((StringBuffer)serializable).append(string8);
            }
            if (string10 != null) {
                ((StringBuffer)serializable).append(string10);
            }
            if (string7 != null) {
                ((StringBuffer)serializable).append(string7);
            }
            if (string6 != null) {
                ((StringBuffer)serializable).append(string6);
            }
            this.verifyApplicationSignature(iInputMessage, ((StringBuffer)serializable).toString(), string4);
        }
        if (!this._applicationManager.isApplication(string4)) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Unknown application ID");
            throw new ASelectCommunicationException("0031");
        }
        n = this._applicationManager.getRequiredLevel(string4);
        if (n == null) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "No level specified for application with ID: '" + string4 + "'");
            throw new ASelectException("0035");
        }
        n2 = this._applicationManager.getMaxLevel(string4);
        hashtable = new Hashtable<String, Object>();
        hashtable.put("app_id", string4);
        hashtable.put("app_url", string3);
        hashtable.put("level", n);
        if (n2 != null) {
            hashtable.put("max_level", n2);
        }
        hashtable.put("organization", this._sMyOrg);
        if (string7 != null) {
            hashtable.put("forced_organization", string7);
        }
        if (string6 != null) {
            hashtable.put("forced_uid", string6);
        }
        if (!bl.booleanValue() && this._applicationManager.isForcedAuthenticateEnabled(string4)) {
            bl = new Boolean(true);
        }
        hashtable.put("forced_authenticate", bl);
        if (this._configManager.isSingleSignOn() && (serializable = this._applicationManager.getSSOGroups(string4)) != null) {
            hashtable.put("sso_groups", serializable);
        }
        if (string9 != null && string9.trim().length() > 0) {
            hashtable.put("country", string9);
        }
        if (string10 != null && string10.trim().length() > 0) {
            hashtable.put("language", string10);
        }
        serializable = new StringBuffer();
        String string11 = this._configManager.getRedirectURL();
        if (string11 != null) {
            ((StringBuffer)serializable).append(string11);
        } else {
            ((StringBuffer)serializable).append(iProtocolRequest.getTarget());
        }
        Vector vector = this._authSPManagerManager.getConfiguredAuthSPs(n, n2);
        if (vector.size() == 1 && this._authSPManagerManager.isDirectAuthSP((String)vector.get(0))) {
            ((StringBuffer)serializable).append("?request=direct_login1");
            hashtable.put("direct_authsp", vector.get(0));
        } else {
            ((StringBuffer)serializable).append("?request=login1");
        }
        string2 = this._sessionManager.createSession(hashtable);
        if (string2 == null) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Unable to create session");
            throw new ASelectCommunicationException("0003");
        }
        try {
            String string12 = ((StringBuffer)serializable).toString();
            iOutputMessage.setParam("rid", string2);
            iOutputMessage.setParam("as_url", string12);
            iOutputMessage.setParam("result_code", "0000");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Could not set response parameter", (Throwable)aSelectCommunicationException);
            throw new ASelectCommunicationException("0001", (Throwable)aSelectCommunicationException);
        }
    }

    private void handleGetAppLevelRequest(IInputMessage iInputMessage, IOutputMessage iOutputMessage) throws ASelectException {
        Comparable<Integer> comparable;
        String string = "handleGetAppLevelRequest()";
        String string2 = null;
        String string3 = null;
        try {
            string2 = iInputMessage.getParam("app_id");
            string3 = iInputMessage.getParam("a-select-server");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Missing required parameters");
            throw new ASelectCommunicationException("0030");
        }
        if (this._applicationManager.isSigningRequired()) {
            comparable = new StringBuffer(string3).append(string2);
            this.verifyApplicationSignature(iInputMessage, ((StringBuffer)comparable).toString(), string2);
        }
        if ((comparable = this._applicationManager.getRequiredLevel(string2)) == null) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Unknown application ID");
            throw new ASelectCommunicationException("0031");
        }
        try {
            iOutputMessage.setParam("app_level", ((Integer)comparable).toString());
            iOutputMessage.setParam("result_code", "0000");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Could not set response parameter", (Throwable)aSelectCommunicationException);
            throw new ASelectCommunicationException("0001", (Throwable)aSelectCommunicationException);
        }
    }

    private void handleKillTGTRequest(IInputMessage iInputMessage, IOutputMessage iOutputMessage) throws ASelectException {
        Object object;
        String string = "handleKillTGTRequest()";
        String string2 = null;
        String string3 = null;
        try {
            string2 = iInputMessage.getParam("tgt_blob");
            string3 = iInputMessage.getParam("a-select-server");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Missing required parameters");
            throw new ASelectCommunicationException("0030");
        }
        String string4 = null;
        try {
            object = CryptoEngine.getHandle().decryptTGT(string2);
            string4 = Utils.toHexString((byte[])object);
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Could not decrypt TGT", (Throwable)aSelectException);
            throw new ASelectCommunicationException("0004", (Throwable)aSelectException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Could not decrypt TGT", (Throwable)illegalArgumentException);
            throw new ASelectCommunicationException("0004", (Throwable)illegalArgumentException);
        }
        object = this._oTGTManager.getTGT(string4);
        if (object == null) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Unknown TGT");
            throw new ASelectCommunicationException("0007");
        }
        if (this._applicationManager.isSigningRequired()) {
            String string5 = (String)((Hashtable)object).get("app_id");
            StringBuffer stringBuffer = new StringBuffer(string3).append(string2);
            this.verifyApplicationSignature(iInputMessage, stringBuffer.toString(), string5);
        }
        this._oTGTManager.remove((Object)string4);
        try {
            iOutputMessage.setParam("result_code", "0000");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Could not set response parameter", (Throwable)aSelectCommunicationException);
            throw new ASelectCommunicationException("0001", (Throwable)aSelectCommunicationException);
        }
    }

    private void handleVerifyCredentialsRequest(IInputMessage iInputMessage, IOutputMessage iOutputMessage) throws ASelectException {
        CharSequence charSequence;
        Object object;
        String string = "handleVerifyCredentialsRequest()";
        Hashtable hashtable = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        try {
            string5 = iInputMessage.getParam("aselect_credentials");
            string6 = iInputMessage.getParam("a-select-server");
            string2 = iInputMessage.getParam("rid");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Missing required parameters");
            throw new ASelectCommunicationException("0030");
        }
        try {
            object = CryptoEngine.getHandle().decryptTGT(string5);
            string7 = Utils.toHexString((byte[])object);
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "could not decrypt TGT", (Throwable)aSelectException);
            throw new ASelectCommunicationException("0004", (Throwable)aSelectException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "could not decrypt TGT", (Throwable)exception);
            throw new ASelectCommunicationException("0004", (Throwable)exception);
        }
        hashtable = this._oTGTManager.getTGT(string7);
        if (hashtable == null) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Unknown TGT");
            throw new ASelectCommunicationException("0007");
        }
        if (!string2.equalsIgnoreCase((String)hashtable.get("rid"))) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Invalid RID");
            object = new StringBuffer("RID is other than expected. Received ");
            ((StringBuffer)object).append(string2);
            ((StringBuffer)object).append(" but expected ");
            ((StringBuffer)object).append((String)hashtable.get("rid"));
            this._systemLogger.log(Level.FINE, this._sModule, string, ((StringBuffer)object).toString());
            throw new ASelectCommunicationException("0004");
        }
        object = (String)hashtable.get("app_id");
        if (object == null) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "invalid Application ID");
            throw new ASelectCommunicationException("0030");
        }
        if (this._applicationManager.isSigningRequired()) {
            charSequence = new StringBuffer(string6).append(string5).append(string2);
            this.verifyApplicationSignature(iInputMessage, charSequence.toString(), (String)object);
        }
        try {
            iOutputMessage.setParam("rid", string2);
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Could not set 'rid' response parameter", (Throwable)aSelectCommunicationException);
            throw new ASelectCommunicationException("0001", (Throwable)aSelectCommunicationException);
        }
        string4 = (String)hashtable.get("result_code");
        if (string4 != null && string4 != "0000") {
            this._oTGTManager.remove((Object)string7);
            throw new ASelectCommunicationException(string4);
        }
        string3 = (String)hashtable.get("uid");
        charSequence = (String)hashtable.get("authsp_level");
        String string8 = (String)hashtable.get("authsp");
        long l = 0L;
        try {
            l = this._oTGTManager.getExpirationTime((Object)string7);
        }
        catch (ASelectStorageException aSelectStorageException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Could not fetch TGT timeout", (Throwable)aSelectStorageException);
            throw new ASelectCommunicationException("0004");
        }
        AttributeGatherer attributeGatherer = AttributeGatherer.getHandle();
        Hashtable hashtable2 = attributeGatherer.gatherAttributes(hashtable);
        String string9 = this.serializeAttributes(hashtable2);
        try {
            iOutputMessage.setParam("app_id", (String)object);
            iOutputMessage.setParam("organization", (String)hashtable.get("organization"));
            iOutputMessage.setParam("app_level", (String)hashtable.get("app_level"));
            iOutputMessage.setParam("asp_level", (String)charSequence);
            iOutputMessage.setParam("asp", string8);
            iOutputMessage.setParam("authsp_level", (String)charSequence);
            iOutputMessage.setParam("authsp", string8);
            if (this._applicationManager.isUseOpaqueUid((String)object)) {
                MessageDigest messageDigest = null;
                try {
                    messageDigest = MessageDigest.getInstance("SHA1");
                    messageDigest.update(string3.getBytes("UTF-8"));
                    string3 = Utils.toHexString((byte[])messageDigest.digest());
                }
                catch (Exception exception) {
                    this._systemLogger.log(Level.WARNING, this._sModule, string, "Unable to generate SHA1 hash from UID", (Throwable)exception);
                    throw new ASelectException("0001", (Throwable)exception);
                }
            }
            iOutputMessage.setParam("uid", string3);
            iOutputMessage.setParam("tgt_exp_time", new Long(l).toString());
            if (string9 != null) {
                iOutputMessage.setParam("attributes", string9);
            }
            iOutputMessage.setParam("result_code", "0000");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "Could not set response parameters", (Throwable)aSelectCommunicationException);
            throw new ASelectCommunicationException("0001", (Throwable)aSelectCommunicationException);
        }
        if (!this._configManager.isSingleSignOn()) {
            this._oTGTManager.remove((Object)string7);
        }
    }

    private void verifyApplicationSignature(IInputMessage iInputMessage, String string, String string2) throws ASelectException {
        String string3 = "verifyApplicationSignature()";
        String string4 = null;
        try {
            string4 = iInputMessage.getParam("signature");
        }
        catch (ASelectCommunicationException aSelectCommunicationException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string3, "Missing required 'signature' parameter", (Throwable)aSelectCommunicationException);
            throw new ASelectCommunicationException("0030");
        }
        PublicKey publicKey = null;
        try {
            publicKey = this._applicationManager.getSigningKey(string2);
        }
        catch (ASelectException aSelectException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string3, "Invalid application ID: \"" + string2 + "\". Could not find signing key for application.", (Throwable)aSelectException);
            throw new ASelectCommunicationException("0030");
        }
        if (!this._cryptoEngine.verifyApplicationSignature(publicKey, string, string4)) {
            this._systemLogger.log(Level.WARNING, this._sModule, string3, "Invalid signature");
            throw new ASelectCommunicationException("0030");
        }
    }
}

