/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.aselect.authentication;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.request.handler.aselect.authentication.IRequestHandler;
import org.aselect.server.session.SessionManager;
import org.aselect.server.tgt.TGTManager;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Utils;

public abstract class AbstractBrowserRequestHandler
implements IRequestHandler {
    protected String _sModule = "AbstractBrowserRequestHandler";
    protected ASelectSystemLogger _systemLogger;
    protected ASelectConfigManager _configManager = ASelectConfigManager.getHandle();
    protected SessionManager _sessionManager = SessionManager.getHandle();
    protected TGTManager _tgtManager = TGTManager.getHandle();
    protected HttpServletRequest _servletRequest;
    protected HttpServletResponse _servletResponse;
    protected String _sMyServerId;
    protected String _sMyOrg;

    public AbstractBrowserRequestHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) {
        this._systemLogger = ASelectSystemLogger.getHandle();
        this._sMyServerId = string;
        this._sMyOrg = string2;
        this._servletRequest = httpServletRequest;
        this._servletResponse = httpServletResponse;
    }

    public void processRequest() throws ASelectException {
        String string = "processRequest()";
        PrintWriter printWriter = null;
        Hashtable hashtable = null;
        try {
            printWriter = this._servletResponse.getWriter();
            this._servletResponse.setContentType("text/html");
            hashtable = this.createServiceRequest(this._servletRequest);
            String string2 = (String)hashtable.get("request");
            if (string2 != null) {
                String string3 = (String)hashtable.get("a-select-server");
                if (string3 == null) {
                    this._systemLogger.log(Level.WARNING, this._sModule, string, "Missing required parameter \"a-select-server\"");
                    throw new ASelectCommunicationException("0030");
                }
                if (!string3.equals(this._sMyServerId)) {
                    this._systemLogger.log(Level.WARNING, this._sModule, string, "Invalid \"a-select-server\" parameter: " + string3);
                    throw new ASelectCommunicationException("0033");
                }
            }
            this.processBrowserRequest(hashtable, this._servletResponse, printWriter);
        }
        catch (ASelectException aSelectException) {
            this.showErrorPage(aSelectException.getMessage(), hashtable, printWriter);
        }
        catch (IOException iOException) {
            this._systemLogger.log(Level.WARNING, this._sModule, string, "IO Exception", (Throwable)iOException);
            throw new ASelectCommunicationException("4006", (Throwable)iOException);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, this._sModule, string, "Internal error", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
                printWriter = null;
            }
        }
    }

    protected abstract void processBrowserRequest(Hashtable var1, HttpServletResponse var2, PrintWriter var3) throws ASelectException;

    protected void showErrorPage(String string, Hashtable hashtable, PrintWriter printWriter) {
        String string2 = "showErrorPage()";
        try {
            String string3 = this._configManager.getForm("error");
            string3 = Utils.replaceString((String)string3, (String)"[error]", (String)string);
            string3 = Utils.replaceString((String)string3, (String)"[error_message]", (String)this._configManager.getErrorMessage(string));
            String string4 = (String)hashtable.get("rid");
            if (string4 != null) {
                string3 = this._configManager.updateTemplate(string3, this._sessionManager.getSessionContext(string4));
            }
            Hashtable hashtable2 = null;
            if (string4 != null) {
                hashtable2 = SessionManager.getHandle().getSessionContext(string4);
            }
            string3 = this._configManager.updateTemplate(string3, hashtable2);
            printWriter.println(string3);
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, this._sModule, string2, "Could not show error page with error: " + string, (Throwable)exception);
        }
    }

    protected Hashtable getASelectCredentials(HttpServletRequest httpServletRequest) {
        String string = "getASelectCredentials()";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Cookie[] cookieArray = httpServletRequest.getCookies();
        if (cookieArray == null) {
            return null;
        }
        String string2 = null;
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals("aselect_credentials")) continue;
            string2 = cookieArray[i].getValue();
            this._systemLogger.log(Level.FINER, this._sModule, string, "Cookie 'aselect_credentials' has value: " + string2);
            int n = string2.length();
            if (string2.charAt(0) != '\"' || string2.charAt(n - 1) != '\"') continue;
            string2 = string2.substring(1, n - 1);
        }
        if (string2 == null) {
            return null;
        }
        Hashtable hashtable2 = Utils.convertCGIMessage(string2);
        if (hashtable2 == null) {
            return null;
        }
        String string3 = (String)hashtable2.get("tgt");
        String string4 = (String)hashtable2.get("uid");
        String string5 = (String)hashtable2.get("a-select-server");
        if (string3 == null || string4 == null || string5 == null) {
            return null;
        }
        if (!string5.equals(this._sMyServerId)) {
            return null;
        }
        Hashtable hashtable3 = this._tgtManager.getTGT(string3);
        if (hashtable3 == null) {
            return null;
        }
        if (!string4.equals(hashtable3.get("uid"))) {
            return null;
        }
        hashtable.put("aselect_credentials_tgt", string3);
        hashtable.put("aselect_credentials_uid", string4);
        hashtable.put("aselect_credentials_server_id", string5);
        return hashtable;
    }

    private Hashtable createServiceRequest(HttpServletRequest httpServletRequest) {
        Cookie[] cookieArray;
        Object object;
        Hashtable<Object, Object> hashtable = null;
        if (httpServletRequest.getMethod().equalsIgnoreCase("GET")) {
            hashtable = Utils.convertCGIMessage((String)httpServletRequest.getQueryString());
        } else {
            hashtable = new Hashtable<Object, Object>();
            Enumeration enumeration = httpServletRequest.getParameterNames();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                cookieArray = httpServletRequest.getParameter((String)object);
                if (cookieArray == null) continue;
                hashtable.put(object, cookieArray);
            }
        }
        hashtable.put("my_url", httpServletRequest.getRequestURL().toString());
        hashtable.put("client_ip", httpServletRequest.getRemoteAddr());
        object = this.getASelectCredentials(httpServletRequest);
        if (object != null) {
            hashtable.put("aselect_credentials_tgt", ((Hashtable)object).get("aselect_credentials_tgt"));
            hashtable.put("aselect_credentials_uid", ((Hashtable)object).get("aselect_credentials_uid"));
            hashtable.put("aselect_credentials_server_id", this._sMyServerId);
        }
        if ((cookieArray = httpServletRequest.getCookies()) != null) {
            hashtable.put("aselect_cookies", cookieArray);
        }
        return hashtable;
    }
}

