/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.aselect.authentication;

import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.request.handler.aselect.authentication.IRequestHandler;
import org.aselect.server.request.handler.aselect.authentication.RequestParser;
import org.aselect.system.communication.server.Communicator;
import org.aselect.system.communication.server.IInputMessage;
import org.aselect.system.communication.server.IMessageCreatorInterface;
import org.aselect.system.communication.server.IOutputMessage;
import org.aselect.system.communication.server.IProtocolRequest;
import org.aselect.system.communication.server.IProtocolResponse;
import org.aselect.system.communication.server.ServletRequestWrapper;
import org.aselect.system.communication.server.ServletResponseWrapper;
import org.aselect.system.communication.server.raw.RawMessageCreator;
import org.aselect.system.communication.server.soap11.SOAP11MessageCreator;
import org.aselect.system.communication.server.soap12.SOAP12MessageCreator;
import org.aselect.system.exception.ASelectCommunicationException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.utils.BASE64Encoder;

public abstract class AbstractAPIRequestHandler
implements IRequestHandler {
    protected String _sModule = "AbstractAPIRequestHandler";
    private IMessageCreatorInterface _messageCreator = null;
    protected ASelectSystemLogger _systemLogger;
    private HttpServletRequest _servletRequest;
    private HttpServletResponse _servletResponse;
    protected String _sMyServerId;
    protected String _sMyOrg;

    public AbstractAPIRequestHandler(RequestParser requestParser, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, String string2) throws ASelectCommunicationException {
        String string3 = "AbstractAPIRequestHandler()";
        this._systemLogger = ASelectSystemLogger.getHandle();
        this._servletRequest = httpServletRequest;
        this._servletResponse = httpServletResponse;
        this._sMyServerId = string;
        this._sMyOrg = string2;
        switch (requestParser.getRequestProtocol()) {
            case 1: {
                this._messageCreator = new SOAP11MessageCreator(this._servletRequest.getRequestURL().toString(), "ASelect", (SystemLogger)this._systemLogger);
                break;
            }
            case 2: {
                this._messageCreator = new SOAP12MessageCreator(this._servletRequest.getRequestURL().toString(), "ASelect", (SystemLogger)this._systemLogger);
                break;
            }
            case 0: {
                this._messageCreator = new RawMessageCreator((SystemLogger)this._systemLogger);
                break;
            }
            default: {
                this._systemLogger.log(Level.WARNING, this._sModule, string3, "Invalid request protocol received.");
                throw new ASelectCommunicationException("0030");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest() throws ASelectException {
        block21: {
            String string = "processRequest()";
            ServletRequestWrapper servletRequestWrapper = new ServletRequestWrapper(this._servletRequest);
            ServletResponseWrapper servletResponseWrapper = new ServletResponseWrapper(this._servletResponse);
            Communicator communicator = new Communicator(this._messageCreator);
            try {
                if (communicator.init((IProtocolRequest)servletRequestWrapper, (IProtocolResponse)servletResponseWrapper)) {
                    IInputMessage iInputMessage = communicator.getInputMessage();
                    IOutputMessage iOutputMessage = communicator.getOutputMessage();
                    try {
                        String string2 = null;
                        try {
                            string2 = iInputMessage.getParam("a-select-server");
                        }
                        catch (ASelectException aSelectException) {
                            this._systemLogger.log(Level.WARNING, this._sModule, string, "Missing required parameter \"a-select-server\"");
                            throw new ASelectCommunicationException("0030");
                        }
                        if (!string2.equals(this._sMyServerId)) {
                            this._systemLogger.log(Level.WARNING, this._sModule, string, "Invalid \"a-select-server\" parameter: " + string2);
                            throw new ASelectCommunicationException("0033");
                        }
                        this.processAPIRequest((IProtocolRequest)servletRequestWrapper, iInputMessage, iOutputMessage);
                    }
                    catch (ASelectException aSelectException) {
                        try {
                            iOutputMessage.setParam("result_code", aSelectException.getMessage());
                        }
                        catch (ASelectCommunicationException aSelectCommunicationException) {
                            this._systemLogger.log(Level.WARNING, this._sModule, string, "Error setting 'result_code' in outputmessage", (Throwable)aSelectCommunicationException);
                            throw aSelectCommunicationException;
                        }
                    }
                    finally {
                        try {
                            iOutputMessage.setParam("a-select-server", this._sMyServerId);
                        }
                        catch (ASelectCommunicationException aSelectCommunicationException) {
                            this._systemLogger.log(Level.WARNING, this._sModule, string, "Error setting 'a-select-server' in outputmessage", (Throwable)aSelectCommunicationException);
                            throw aSelectCommunicationException;
                        }
                    }
                    communicator.send();
                    break block21;
                }
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Can't initialize Message Creator object: " + this._messageCreator.getClass().getName());
            }
            catch (ASelectException aSelectException) {
                this._systemLogger.log(Level.WARNING, this._sModule, string, "Error while processing API request", (Throwable)aSelectException);
                throw aSelectException;
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.SEVERE, this._sModule, string, "Internal error while processing API request", (Throwable)exception);
                throw new ASelectException("0001", (Throwable)exception);
            }
        }
    }

    protected abstract void processAPIRequest(IProtocolRequest var1, IInputMessage var2, IOutputMessage var3) throws ASelectException;

    protected String serializeAttributes(Hashtable hashtable) throws ASelectException {
        try {
            if (hashtable == null || hashtable.isEmpty()) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            BASE64Encoder bASE64Encoder = hashtable.keys();
            while (bASE64Encoder.hasMoreElements()) {
                Object object;
                String string = (String)bASE64Encoder.nextElement();
                Object v = hashtable.get(string);
                if (v instanceof Vector) {
                    object = (Vector)v;
                    string = URLEncoder.encode(string + "[]", "UTF-8");
                    Enumeration enumeration = ((Vector)object).elements();
                    while (enumeration.hasMoreElements()) {
                        String string2 = (String)enumeration.nextElement();
                        stringBuffer.append(string);
                        stringBuffer.append("=");
                        stringBuffer.append(URLEncoder.encode(string2, "UTF-8"));
                        if (!enumeration.hasMoreElements()) continue;
                        stringBuffer.append("&");
                    }
                } else if (v instanceof String) {
                    object = (String)v;
                    stringBuffer.append(URLEncoder.encode(string, "UTF-8"));
                    stringBuffer.append("=");
                    stringBuffer.append(URLEncoder.encode((String)object, "UTF-8"));
                }
                if (!bASE64Encoder.hasMoreElements()) continue;
                stringBuffer.append("&");
            }
            bASE64Encoder = new BASE64Encoder();
            return bASE64Encoder.encode(stringBuffer.toString().getBytes("UTF-8"));
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.WARNING, this._sModule, "serializeAttributes()", "Could not serialize attributes", (Throwable)exception);
            throw new ASelectException("0001");
        }
    }
}

