/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.request.handler.aselect;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aselect.server.request.RequestState;
import org.aselect.server.request.handler.AbstractRequestHandler;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.servlet.ASelectHttpServlet;

public class ASelectRestartRequestHandler
extends AbstractRequestHandler {
    private String _sMySharedSecret = null;
    private static final String MODULE = "ASelectRestartRequestHandler";

    public void init(ServletConfig servletConfig, Object object) throws ASelectException {
        String string = "init()";
        try {
            super.init(servletConfig, object);
            try {
                this._sMySharedSecret = this._configManager.getParam(object, "shared_secret");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._sMySharedSecret = null;
                this._systemLogger.log(Level.CONFIG, MODULE, string, "Could not retrieve 'shared_secret' config parameter in aselect config section.", (Throwable)aSelectConfigException);
                throw aSelectConfigException;
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
    }

    public RequestState process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ASelectException {
        String string = "process()";
        try {
            String string2 = httpServletRequest.getParameter("shared_secret");
            if (string2 == null) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Parameter 'shared_secret' not found in restart request from " + httpServletRequest.getRemoteAddr());
                throw new ASelectException("0030");
            }
            if (!string2.equals(this._sMySharedSecret)) {
                this._systemLogger.log(Level.WARNING, MODULE, string, "Invalid 'shared_secret' received from " + httpServletRequest.getRemoteAddr());
                throw new ASelectException("0030");
            }
            String string3 = this.restartServlets() ? "0000" : "0001";
            PrintWriter printWriter = httpServletResponse.getWriter();
            printWriter.print("result_code=" + string3);
            if (printWriter != null) {
                printWriter.close();
            }
        }
        catch (ASelectException aSelectException) {
            throw aSelectException;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, MODULE, string, "Could not process request", (Throwable)exception);
            throw new ASelectException("0001", (Throwable)exception);
        }
        return new RequestState(null);
    }

    public void destroy() {
    }

    private synchronized boolean restartServlets() {
        String string = "restartServlets()";
        boolean bl = true;
        try {
            ServletContext servletContext = this._oServletConfig.getServletContext();
            Hashtable hashtable = (Hashtable)servletContext.getAttribute("restartable_servlets");
            if (hashtable == null) {
                this._systemLogger.log(Level.INFO, MODULE, string, "Restart: no restartable servlets registered");
                return false;
            }
            servletContext.setAttribute("restarting_servlets", (Object)"true");
            StringBuffer stringBuffer = new StringBuffer("Restart: ");
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                ASelectHttpServlet aSelectHttpServlet = (ASelectHttpServlet)hashtable.get(string2);
                boolean bl2 = true;
                try {
                    aSelectHttpServlet.init(aSelectHttpServlet.getServletConfig());
                }
                catch (Exception exception) {
                    bl2 = false;
                }
                bl &= bl2;
                stringBuffer.append(string2).append(" (");
                stringBuffer.append(bl2 ? "OK" : "Failed");
                stringBuffer.append(")");
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(", ");
            }
            this._systemLogger.log(Level.INFO, MODULE, string, stringBuffer.toString());
            servletContext.removeAttribute("restarting_servlets");
        }
        catch (Exception exception) {
            bl = false;
            this._systemLogger.log(Level.INFO, MODULE, string, "Restarting servlets failed", (Throwable)exception);
        }
        return bl;
    }
}

