/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.sam.agent.polling;

import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.system.communication.client.IClientCommunicator;
import org.aselect.system.communication.client.raw.RawCommunicator;
import org.aselect.system.communication.client.soap11.SOAP11Communicator;
import org.aselect.system.communication.client.soap12.SOAP12Communicator;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.ISAMPollingMethod;

public class SAMAPIPollingMethod
implements ISAMPollingMethod {
    private static final String MODULE = "SAMAPIPollingMethod";
    private static final String OID_OPERATIONAL = "1.3.6.1.4.1.15396.10.10.2.1.3";
    private static final String OID_ALL = "1.3.6.1.4.1.15396.10.10.2.";
    private String _sUrl;
    private SystemLogger _oSystemLogger;
    private IClientCommunicator _oClientCommunicator;
    private ConfigManager _oConfigManager;

    public void init(Object object, Object object2, ConfigManager configManager, SystemLogger systemLogger) throws ASelectSAMException {
        StringBuffer stringBuffer = new StringBuffer(MODULE);
        String string = "init()";
        this._oSystemLogger = systemLogger;
        this._oConfigManager = configManager;
        try {
            this._sUrl = this._oConfigManager.getParam(object2, "url");
        }
        catch (ASelectConfigException aSelectConfigException) {
            stringBuffer.append("Config item 'url' is missing.");
            this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString(), aSelectConfigException);
            throw new ASelectSAMException("4009", aSelectConfigException);
        }
        this._oClientCommunicator = this.getCommunicator(object2);
    }

    public boolean poll() {
        StringBuffer stringBuffer = new StringBuffer(MODULE);
        String string = "poll()";
        boolean bl = false;
        try {
            Hashtable hashtable = this.communicate();
            String string2 = (String)hashtable.get(OID_OPERATIONAL);
            if (string2 != null && string2.equals("1")) {
                bl = true;
            }
        }
        catch (Exception exception) {
            stringBuffer.append("Could not poll the resource");
            this._oSystemLogger.log(Level.FINE, MODULE, string, stringBuffer.toString(), exception);
        }
        return bl;
    }

    private Hashtable communicate() throws ASelectSAMException {
        String string = "communicate()";
        StringBuffer stringBuffer = new StringBuffer();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        String[] stringArray = new String[1];
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n = -1;
        stringArray[0] = OID_ALL;
        hashtable.put("samversion", "1.0");
        hashtable.put("get", stringArray);
        try {
            Hashtable hashtable3 = this._oClientCommunicator.sendMessage(hashtable, this._sUrl);
            String[] stringArray2 = (String[])hashtable3.get("get");
            for (int i = 0; i < stringArray2.length; ++i) {
                string2 = stringArray2[i];
                n = string2.indexOf("=");
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
                hashtable2.put(string3, string4);
            }
            if (hashtable2.isEmpty()) {
                stringBuffer.append("No response from SAM Service: \"");
                stringBuffer.append(this._sUrl);
                stringBuffer.append("\"");
                this._oSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
                throw new ASelectSAMException("7001");
            }
        }
        catch (ASelectSAMException aSelectSAMException) {
            throw aSelectSAMException;
        }
        catch (Exception exception) {
            stringBuffer.append("Error in communicating with: \"");
            stringBuffer.append(this._sUrl);
            stringBuffer.append("\"");
            this._oSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString(), exception);
            throw new ASelectSAMException("7001");
        }
        return hashtable2;
    }

    private IClientCommunicator getCommunicator(Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "getCommunicator()";
        IClientCommunicator iClientCommunicator = null;
        String string2 = null;
        try {
            string2 = this._oConfigManager.getParam(object, "transferprotocol");
        }
        catch (Exception exception) {
            stringBuffer.append("Could not find config item 'transferprotocol', using Raw communication.");
            this._oSystemLogger.log(Level.CONFIG, MODULE, string, stringBuffer.toString());
            string2 = "raw";
        }
        if (string2 == null) {
            string2 = "";
        }
        iClientCommunicator = string2.equalsIgnoreCase("soap11") ? new SOAP11Communicator("Status", this._oSystemLogger) : (string2.equalsIgnoreCase("soap12") ? new SOAP12Communicator("Status", this._oSystemLogger) : new RawCommunicator(this._oSystemLogger));
        return iClientCommunicator;
    }
}

