/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.sam.agent;

import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMResource;

public class SAMResourceGroup
extends Thread {
    private static final String MODULE = "SAMResourceGroup";
    private boolean _bRunThread;
    private Vector _vResources;
    private Vector _vActive;
    private SystemLogger _oSystemLogger;
    private final long DEFAULT_UPDATE_INTERVAL = 50L;
    private long _lInterval;

    public void init(Object object, ConfigManager configManager, SystemLogger systemLogger) throws ASelectSAMException {
        StringBuffer stringBuffer = new StringBuffer(MODULE);
        String string = "init()";
        this._vResources = new Vector();
        this._vActive = new Vector();
        this._oSystemLogger = systemLogger;
        Object object2 = null;
        String string2 = null;
        try {
            try {
                string2 = configManager.getParam(object, "id");
            }
            catch (Exception exception) {
                stringBuffer.append("Could not find config item 'id' in config section 'resourcegroup'.");
                this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString(), exception);
                throw new ASelectSAMException("4009", exception);
            }
            try {
                this._lInterval = new Long(configManager.getParam(object, "interval"));
            }
            catch (Exception exception) {
                this._lInterval = 50L;
                StringBuffer stringBuffer2 = new StringBuffer(stringBuffer.toString());
                stringBuffer2.append("Could not find config item 'interval' in config section 'resourcegroup' with id=");
                stringBuffer2.append(string2);
                stringBuffer2.append(". Setting interval to default value: '");
                stringBuffer2.append(50L);
                stringBuffer2.append("'");
                this._oSystemLogger.log(Level.CONFIG, MODULE, string, stringBuffer2.toString(), exception);
            }
            try {
                object2 = configManager.getSection(object, "resource");
            }
            catch (Exception exception) {
                stringBuffer.append("Could not find config section 'resource' in config section 'resourcegroup' with id=");
                stringBuffer.append(string2);
                this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString(), exception);
                throw new ASelectSAMException("4009", exception);
            }
            SAMResource sAMResource = new SAMResource();
            sAMResource.init(object2, configManager, systemLogger);
            this._vResources.addElement(sAMResource);
            while ((object2 = configManager.getNextSection(object2)) != null) {
                sAMResource = new SAMResource();
                sAMResource.init(object2, configManager, this._oSystemLogger);
                this._vResources.addElement(sAMResource);
            }
            this.updateStatus();
            this._bRunThread = true;
        }
        catch (ASelectSAMException aSelectSAMException) {
            throw aSelectSAMException;
        }
        catch (Exception exception) {
            stringBuffer.append("Could not initialize: ");
            stringBuffer.append(exception.getMessage());
            this._oSystemLogger.log(Level.SEVERE, MODULE, string, stringBuffer.toString(), exception);
            throw new ASelectSAMException("4009", exception);
        }
    }

    public SAMResource getActiveResource() throws ASelectSAMException {
        StringBuffer stringBuffer = new StringBuffer(MODULE);
        String string = "getActiveResource()";
        if (this._vActive.isEmpty()) {
            stringBuffer.append("There were no resources found to be active.");
            this._oSystemLogger.log(Level.WARNING, MODULE, string, stringBuffer.toString());
            throw new ASelectSAMException("7002");
        }
        return (SAMResource)this._vActive.firstElement();
    }

    public void run() {
        while (this._bRunThread) {
            try {
                this.updateStatus();
                SAMResourceGroup.sleep(this._lInterval);
            }
            catch (Exception exception) {}
        }
    }

    public void destroy() {
        Enumeration enumeration = this._vResources.elements();
        while (enumeration.hasMoreElements()) {
            SAMResource sAMResource = (SAMResource)enumeration.nextElement();
            sAMResource.destroy();
        }
        this._bRunThread = false;
    }

    private void updateStatus() {
        Vector<SAMResource> vector = new Vector<SAMResource>();
        Enumeration enumeration = this._vResources.elements();
        while (enumeration.hasMoreElements()) {
            SAMResource sAMResource = (SAMResource)enumeration.nextElement();
            if (!sAMResource.live()) continue;
            vector.add(sAMResource);
        }
        this._vActive = vector;
    }
}

