/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.system.sam.agent;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import org.aselect.system.configmanager.ConfigManager;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.logging.SystemLogger;
import org.aselect.system.sam.agent.SAMResource;
import org.aselect.system.sam.agent.SAMResourceGroup;

public class SAMAgent {
    private static final String MODULE = "SAMAgent";
    private Hashtable _htResourceGroups = null;
    private SystemLogger _oSystemLogger;

    public void init(ConfigManager configManager, SystemLogger systemLogger) throws ASelectSAMException {
        String string = "init()";
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        try {
            this._oSystemLogger = systemLogger;
            try {
                object = configManager.getSection(null, "sam");
            }
            catch (Exception exception) {
                this._oSystemLogger.log(Level.WARNING, MODULE, string, "Could not find the 'sam' config section", exception);
                throw new ASelectSAMException("4009", exception);
            }
            try {
                object2 = configManager.getSection(object, "agent");
            }
            catch (Exception exception) {
                this._oSystemLogger.log(Level.WARNING, MODULE, string, "Could not find the 'agent' config section inside the 'sam' section", exception);
                throw new ASelectSAMException("4009", exception);
            }
            try {
                object3 = configManager.getSection(object2, "resourcegroup");
            }
            catch (Exception exception) {
                this._oSystemLogger.log(Level.WARNING, MODULE, string, "Could not find the 'resourcegroup' config section with the 'agent' section", exception);
                throw new ASelectSAMException("4009", exception);
            }
            this.destroy();
            SAMResourceGroup sAMResourceGroup = new SAMResourceGroup();
            sAMResourceGroup.init(object3, configManager, this._oSystemLogger);
            sAMResourceGroup.start();
            this._htResourceGroups = new Hashtable();
            this._htResourceGroups.put(configManager.getParam(object3, "id"), sAMResourceGroup);
            while ((object3 = configManager.getNextSection(object3)) != null) {
                sAMResourceGroup = new SAMResourceGroup();
                sAMResourceGroup.init(object3, configManager, this._oSystemLogger);
                sAMResourceGroup.start();
                this._htResourceGroups.put(configManager.getParam(object3, "id"), sAMResourceGroup);
            }
        }
        catch (ASelectSAMException aSelectSAMException) {
            throw aSelectSAMException;
        }
        catch (Exception exception) {
            this._oSystemLogger.log(Level.SEVERE, MODULE, string, "Could not initialize SAMLAgent", exception);
            throw new ASelectSAMException("0001", exception);
        }
    }

    public SAMResource getActiveResource(String string) throws ASelectSAMException {
        String string2 = "getActiveResource()";
        SAMResource sAMResource = null;
        SAMResourceGroup sAMResourceGroup = (SAMResourceGroup)this._htResourceGroups.get(string);
        if (sAMResourceGroup == null) {
            StringBuffer stringBuffer = new StringBuffer("Resourcegroup with name '");
            stringBuffer.append(string);
            stringBuffer.append("' does not exist");
            this._oSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer.toString());
            throw new ASelectSAMException("7001");
        }
        sAMResource = sAMResourceGroup.getActiveResource();
        return sAMResource;
    }

    public void destroy() {
        if (this._htResourceGroups != null) {
            try {
                Enumeration enumeration = this._htResourceGroups.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    SAMResourceGroup sAMResourceGroup = (SAMResourceGroup)this._htResourceGroups.get(string);
                    sAMResourceGroup.destroy();
                    sAMResourceGroup.interrupt();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

