/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.udb.flatfile;

import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import org.aselect.server.config.ASelectConfigManager;
import org.aselect.server.log.ASelectAuthenticationLogger;
import org.aselect.server.log.ASelectSystemLogger;
import org.aselect.server.sam.ASelectSAMAgent;
import org.aselect.server.udb.IUDBConnector;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectSAMException;
import org.aselect.system.exception.ASelectUDBException;
import org.aselect.system.sam.agent.SAMResource;

public class FlatFileConnector
implements IUDBConnector {
    private static final String MODULE = "FlatFileConnector";
    private ASelectConfigManager _oASelectConfigManager;
    private ASelectSystemLogger _oASelectSystemLogger;
    private ASelectAuthenticationLogger _oASelectAuthenticationLogger;
    private Properties _propFlatFile;

    public void init(Object object) throws ASelectUDBException {
        String string = null;
        String string2 = null;
        String string3 = "init()";
        try {
            this._oASelectConfigManager = ASelectConfigManager.getHandle();
            this._oASelectSystemLogger = ASelectSystemLogger.getHandle();
            this._oASelectAuthenticationLogger = ASelectAuthenticationLogger.getHandle();
            ASelectSAMAgent aSelectSAMAgent = ASelectSAMAgent.getHandle();
            try {
                string2 = this._oASelectConfigManager.getParam(object, "resourcegroup");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string3, "No 'resourcegroup' config item found in udb 'connector' config section.", (Throwable)aSelectConfigException);
                throw new ASelectUDBException("4009", (Throwable)aSelectConfigException);
            }
            SAMResource sAMResource = null;
            try {
                sAMResource = aSelectSAMAgent.getActiveResource(string2);
            }
            catch (ASelectSAMException aSelectSAMException) {
                StringBuffer stringBuffer = new StringBuffer("No active resource found in udb resourcegroup: ");
                stringBuffer.append(string2);
                this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string3, stringBuffer.toString(), (Throwable)aSelectSAMException);
                throw new ASelectUDBException("4009", (Throwable)aSelectSAMException);
            }
            Object object2 = sAMResource.getAttributes();
            try {
                string = this._oASelectConfigManager.getParam(object2, "file");
            }
            catch (Exception exception) {
                this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string3, "No config item 'file' found in flatfile resource.", (Throwable)exception);
                throw new ASelectUDBException("4009", (Throwable)exception);
            }
            File file = new File(string);
            if (!file.exists()) {
                StringBuffer stringBuffer = new StringBuffer("Can't access UDB file: ");
                stringBuffer.append(string);
                this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string3, stringBuffer.toString());
                throw new ASelectUDBException("4009");
            }
            this._propFlatFile = new Properties();
            this._propFlatFile.load(new FileInputStream(file));
        }
        catch (ASelectUDBException aSelectUDBException) {
            throw aSelectUDBException;
        }
        catch (Exception exception) {
            StringBuffer stringBuffer = new StringBuffer("Could not initialize the flatfile UDB connector: ");
            stringBuffer.append(exception.getMessage());
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string3, stringBuffer.toString(), (Throwable)exception);
            throw new ASelectUDBException("4009", (Throwable)exception);
        }
    }

    public Hashtable getUserProfile(String string) {
        String string2 = "getUserProfile()";
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Object object = null;
        Object object2 = null;
        String string3 = null;
        String string4 = string.replace(' ', '+');
        StringBuffer stringBuffer = new StringBuffer("user.");
        stringBuffer.append(string4);
        stringBuffer.append(".accountenabled");
        try {
            StringBuffer stringBuffer2;
            hashtable.put("result_code", "0003");
            if (!this._propFlatFile.containsKey(stringBuffer.toString())) {
                this.logAuthentication(string4, "0002", "denied");
                throw new ASelectUDBException("0002");
            }
            String string5 = (String)this._propFlatFile.get(stringBuffer.toString());
            if (!string5.equalsIgnoreCase("true")) {
                this.logAuthentication(string4, "0008", "denied");
                throw new ASelectUDBException("0008");
            }
            try {
                object = this._oASelectConfigManager.getSection(null, "authsps");
            }
            catch (Exception exception) {
                this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string2, "Config section 'authsps' not found.");
                throw new ASelectUDBException("0001");
            }
            try {
                object2 = this._oASelectConfigManager.getSection(object, "authsp");
            }
            catch (Exception exception) {
                this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string2, "Not even one config section 'authsp' found in config section 'authsps'.");
                throw new ASelectUDBException("0001");
            }
            while (object2 != null) {
                try {
                    string3 = this._oASelectConfigManager.getParam(object2, "id");
                }
                catch (Exception exception) {
                    this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string2, "No config item 'id' found in 'authsp' config section.");
                    throw new ASelectUDBException("0001");
                }
                stringBuffer2 = new StringBuffer("user.");
                stringBuffer2.append(string4);
                stringBuffer2.append(".");
                stringBuffer2.append(string3);
                stringBuffer2.append(".registered");
                String string6 = (String)this._propFlatFile.get(stringBuffer2.toString());
                if (string6 != null && string6.equalsIgnoreCase("true")) {
                    StringBuffer stringBuffer3 = new StringBuffer("user.");
                    stringBuffer3.append(string4);
                    stringBuffer3.append(".");
                    stringBuffer3.append(string3);
                    stringBuffer3.append(".attributes");
                    String string7 = (String)this._propFlatFile.get(stringBuffer3.toString());
                    if (string7 == null) {
                        string7 = "";
                    }
                    hashtable2.put(string3, string7);
                }
                object2 = this._oASelectConfigManager.getNextSection(object2);
            }
            if (hashtable2.size() == 0) {
                stringBuffer2 = new StringBuffer("No user attributes found for user: ");
                stringBuffer2.append(string4);
                this._oASelectSystemLogger.log(Level.WARNING, MODULE, string2, stringBuffer2.toString());
                throw new ASelectUDBException("0003");
            }
            hashtable.put("user_authsps", hashtable2);
            hashtable.put("result_code", "0000");
        }
        catch (ASelectUDBException aSelectUDBException) {
            hashtable.put("result_code", aSelectUDBException.getMessage());
        }
        catch (Exception exception) {
            StringBuffer stringBuffer4 = new StringBuffer("Failed to fetch profile of user ");
            stringBuffer4.append(string4);
            stringBuffer4.append(": ");
            stringBuffer4.append(exception.getMessage());
            this._oASelectSystemLogger.log(Level.SEVERE, MODULE, string2, stringBuffer4.toString(), (Throwable)exception);
            hashtable.put("result_code", "0060");
        }
        return hashtable;
    }

    public boolean isUserEnabled(String string) {
        String string2 = "isUserEnabled()";
        boolean bl = false;
        String string3 = string.replace(' ', '+');
        StringBuffer stringBuffer = new StringBuffer("user.");
        stringBuffer.append(string3);
        stringBuffer.append(".accountenabled");
        if (this._propFlatFile.containsKey(stringBuffer.toString())) {
            String string4 = (String)this._propFlatFile.get(stringBuffer.toString());
            if (string4 != null && string4.equalsIgnoreCase("true")) {
                bl = true;
            } else {
                StringBuffer stringBuffer2 = new StringBuffer("User not A-Select enabled: '");
                stringBuffer2.append(string).append("'");
                this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer2.toString(), (Throwable)new ASelectUDBException("0008"));
            }
        } else {
            StringBuffer stringBuffer3 = new StringBuffer("User not found: '");
            stringBuffer3.append(string).append("'");
            this._oASelectSystemLogger.log(Level.FINE, MODULE, string2, stringBuffer3.toString(), (Throwable)new ASelectUDBException("0002"));
        }
        return bl;
    }

    public String getUserAttributes(String string, String string2) {
        String string3 = "getUserAttributes()";
        String string4 = null;
        String string5 = string.replace(' ', '+');
        StringBuffer stringBuffer = new StringBuffer("user.");
        stringBuffer.append(string5);
        stringBuffer.append(".");
        stringBuffer.append(string2);
        stringBuffer.append(".attributes");
        string4 = (String)this._propFlatFile.get(stringBuffer.toString());
        if (string4 == null) {
            StringBuffer stringBuffer2 = new StringBuffer("User attributes for authsp '");
            stringBuffer2.append(string2).append("' not found for user: '");
            stringBuffer2.append(string).append("'");
            this._oASelectSystemLogger.log(Level.FINE, MODULE, string3, stringBuffer2.toString(), (Throwable)new ASelectUDBException("0002"));
        }
        return string4;
    }

    private void logAuthentication(String string, String string2, String string3) {
        this._oASelectAuthenticationLogger.log(new Object[]{MODULE, string, null, null, null, string3, string2});
    }
}

