/*
 * Decompiled with CFR 0.152.
 */
package org.aselect.server.attributes.requestors.tgt;

import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import org.aselect.server.attributes.requestors.GenericAttributeRequestor;
import org.aselect.system.exception.ASelectAttributesException;
import org.aselect.system.exception.ASelectConfigException;
import org.aselect.system.exception.ASelectException;
import org.aselect.system.utils.Base64;

public class TGTAttributeRequestor
extends GenericAttributeRequestor {
    private final String MODULE = "TGTAttributeRequestor";
    protected Hashtable _htReMapAttributes;
    protected Hashtable _htDuplicate;

    public void init(Object object) throws ASelectException {
        String string = "init()";
        this._htReMapAttributes = new Hashtable();
        this._htDuplicate = new Hashtable();
        Object object2 = null;
        try {
            object2 = this._configManager.getSection(object, "attribute_mapping");
        }
        catch (ASelectConfigException aSelectConfigException) {
            this._systemLogger.log(Level.CONFIG, "TGTAttributeRequestor", string, "No valid 'attribute_mapping' config section found, no mapping used", (Throwable)aSelectConfigException);
        }
        if (object2 != null) {
            Object object3 = null;
            try {
                object3 = this._configManager.getSection(object2, "attribute");
            }
            catch (ASelectConfigException aSelectConfigException) {
                this._systemLogger.log(Level.CONFIG, "TGTAttributeRequestor", string, "Not one valid 'attribute' config section in 'attributes' section found, no mapping used", (Throwable)aSelectConfigException);
            }
            while (object3 != null) {
                boolean bl;
                String string2 = null;
                String string3 = null;
                try {
                    string2 = this._configManager.getParam(object3, "id");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, "TGTAttributeRequestor", string, "No valid 'id' config item in 'attribute' section found", (Throwable)aSelectConfigException);
                    throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
                }
                try {
                    string3 = this._configManager.getParam(object3, "map");
                }
                catch (ASelectConfigException aSelectConfigException) {
                    this._systemLogger.log(Level.WARNING, "TGTAttributeRequestor", string, "No valid 'map' config item in 'attribute' section found", (Throwable)aSelectConfigException);
                    throw new ASelectAttributesException("4009", (Throwable)aSelectConfigException);
                }
                try {
                    String string4 = this._configManager.getParam(object3, "duplicate");
                    bl = new Boolean(string4);
                }
                catch (ASelectConfigException aSelectConfigException) {
                    bl = false;
                    this._systemLogger.log(Level.CONFIG, "TGTAttributeRequestor", string, "No 'duplicate' config item found for attribute '" + string2 + "', using default value 'false'", (Throwable)aSelectConfigException);
                }
                this._htReMapAttributes.put(string3, string2);
                if (bl) {
                    this._htDuplicate.put(string3, string2);
                }
                object3 = this._configManager.getNextSection(object3);
            }
        }
    }

    public Hashtable getAttributes(Hashtable hashtable, Vector vector) throws ASelectAttributesException {
        String string = "getAttributes()";
        Hashtable hashtable2 = new Hashtable();
        try {
            String string2 = (String)hashtable.get("remote_attributes");
            if (string2 != null) {
                hashtable2 = this.deserializeAttributes(string2);
            } else {
                this._systemLogger.log(Level.FINE, "TGTAttributeRequestor", string, "No 'remote_attributes' found in TGT.");
            }
            Hashtable hashtable3 = new Hashtable();
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string3;
                String string4 = string3 = (String)enumeration.nextElement();
                Object v = hashtable2.get(string3);
                if (this._htReMapAttributes.containsKey(string3)) {
                    string4 = (String)this._htReMapAttributes.get(string3);
                }
                hashtable3.put(string4, v);
                if (!this._htDuplicate.containsKey(string3)) continue;
                hashtable3.put(string3, v);
            }
            hashtable2 = hashtable3;
        }
        catch (Exception exception) {
            this._systemLogger.log(Level.SEVERE, "TGTAttributeRequestor", string, "Error retrieving attributes due to internal error", (Throwable)exception);
            throw new ASelectAttributesException("0001");
        }
        return hashtable2;
    }

    public void destroy() {
    }

    private Hashtable deserializeAttributes(String string) throws ASelectException {
        String string2 = "deSerializeAttributes()";
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (string != null) {
            try {
                String string3 = new String(Base64.decode((String)string));
                String[] stringArray = string3.split("&");
                for (int i = 0; i < stringArray.length; ++i) {
                    int n = stringArray[i].indexOf("=");
                    String string4 = "";
                    String string5 = "";
                    Vector<String> vector = null;
                    if (n > 0) {
                        string4 = URLDecoder.decode(stringArray[i].substring(0, n), "UTF-8");
                        string5 = URLDecoder.decode(stringArray[i].substring(n + 1), "UTF-8");
                        if (string4.endsWith("[]")) {
                            vector = (Vector<String>)hashtable.get(string4 = string4.substring(0, string4.length() - 2));
                            if (vector == null) {
                                vector = new Vector<String>();
                            }
                            vector.add(string5);
                        }
                    } else {
                        string4 = URLDecoder.decode(stringArray[i], "UTF-8");
                    }
                    if (vector != null) {
                        hashtable.put(string4, vector);
                        continue;
                    }
                    hashtable.put(string4, string5);
                }
            }
            catch (Exception exception) {
                this._systemLogger.log(Level.WARNING, "TGTAttributeRequestor", string2, "Error during deserialization of attributes", (Throwable)exception);
                throw new ASelectException("0001", (Throwable)exception);
            }
        }
        return hashtable;
    }
}

