<?php

// $Id: client.php 34046 2011-02-25 09:49:30Z wsl $
// $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-php/src/client.php $

function aselect_split($in) {
	$pairs = explode('&', $in);
	$ret = array();
	foreach($pairs as $pair) {
		$keyval = explode('=', $pair, 2);
		if(count($keyval) < 2)
			return null;
		$ret[urldecode($keyval[0])] = urldecode($keyval[1]);
	}
	return $ret;
}

function aselect_join($pairs) {
	$ret = array();
	foreach($pairs as $key => $val) {
		$ret[] = rawurlencode($key).'='.rawurlencode($val);
	}
	return implode('&', $ret);
}

function aselect_decode($base64) {
	$blob = base64_decode($base64, true);
	if($blob === false)
		return null;
	$pairs = explode('&', $blob);
	$ret = array();
	foreach($pairs as $pair) {
		$keyval = explode('=', $pair, 2);
		if(count($keyval) < 2)
			return null;
		$key = urldecode($keyval[0]);
		$val = urldecode($keyval[1]);
		if(array_key_exists($key, $ret)) {
			$ret[$key][] = $val;
		} else {
			$ret[$key] = array($val);
		}
	}
	return $ret;
}

function aselect_valid($a) {
	foreach($a as $key => $val) {
		if(is_null($key) || is_null($val))
			return false;
		if(preg_match('[^ -~]', $key) || preg_match('[^ -~]', $val))
			return false;
	}
	return true;
}

function aselect_comm_io($agent, $msg) {
	if(!socket_connect($agent, '127.0.0.1', 1495))
		return null;
	$r = socket_write($agent, $msg);
//	error_log("aselect-client: send: $msg");
	if($r === false || $r < strlen($msg))
		return null;
	socket_shutdown($agent, 1);
	$ret = socket_read($agent, 65536);
	if($ret === false || $ret == '')
		return null;
//	error_log("aselect-client: recv: $ret");
	$ret = aselect_split($ret);
	if(is_null($ret))
		return null;
	$code = $ret['result_code'];
	if(strcmp($code, '0000'))
		return null;
	unset($ret['result_code']);
	return $ret;
}

function aselect_comm($a) {
	$msg = aselect_join($a);
	$agent = socket_create(AF_INET, SOCK_STREAM, SOL_TCP);
	if(!$agent)
		return null;
	$ret = aselect_comm_io($agent, $msg);
	socket_close($agent);
	return $ret;
}

function aselect_url($url, $a) {
	$sep = strpos($url, '?') === false ? '?' : '&';
	$ret = array($url);
	foreach($a as $key => $val) {
		$ret[] = $sep;
		$ret[] = urlencode($key);
		$ret[] = '=';
		$ret[] = urlencode($val);
		$sep = '&';
	}
	return implode('', $ret);
}

function aselect_defaulturl() {
	$scheme = $_SERVER['HTTPS'] == 'on' ? 'https' : 'http';
	return $scheme.'://'.$_SERVER["HTTP_HOST"].$_SERVER['REQUEST_URI'];
}

function aselect_redirect($url = null) {
	if(empty($url))
		$url = aselect_defaulturl();
	header("Location: $url");
	exit; 
}

function aselect_unknown_parm($q) {
	return !preg_match('^(aselect_credentials|a-select-server|rid)=', $q);
}

function aselect_cleanurl($url = null) {
	if(empty($url))
		$url = aselect_defaulturl();
	$parts = explode('?', $url, 2);
	if(count($parts) < 2)
		return $url;
	$args = explode('&', $parts[1]);
	$newargpart = implode('&', array_filter($args, 'aselect_unknown_parm'));
	if($newargpart == '')
		return $parts[0];
	else
		return $parts[0] . '?' . $newargpart;
}

function aselect_login($app) {
	$info = aselect_verify_ticket($_COOKIE['aselect']);
	if(is_array($info))  
		return $info['uid'];

	$cred = $_REQUEST['aselect_credentials'];
	$rid = $_REQUEST['rid'];
	$ticket = aselect_verify_credentials($rid, $cred);
	if(!is_null($ticket)) {
		setcookie('aselect', $ticket, 0, null, null, $_SERVER['HTTPS'] == 'on');
		aselect_redirect(aselect_cleanurl());
	}

	$sso = aselect_authenticate($app);
	if(empty($sso))
		die("A-Select problem: agent won't give me an SSO redirection URL");
	aselect_redirect($sso);
}


function aselect_authenticate($app_id, $app_url = null) {
	if(is_null($app_url))
		$app_url = aselect_defaulturl();
	$args = array(
			'request' => 'authenticate',
			'app_id' => $app_id,
			'app_url' => $app_url
		);
	$res = aselect_comm($args);
	if(is_null($res))
		return null;
	$as_url = $res['as_url'];
	if(is_null($as_url))
		return null;
	unset($res['as_url']);
	return aselect_url($as_url, $res);
}

function aselect_verify_credentials_raw($rid, $cred) {
	if(empty($rid) || empty($cred))
		return null;
	$args = array(
			'request' => 'verify_credentials',
			'rid' => $rid,
			'aselect_credentials' => $cred
		);
	if(!aselect_valid($args))
		return null;
	return aselect_comm($args);
}

function aselect_verify_credentials_cookie($res) {
	return aselect_join(array(
			'uid' => $res['uid'],
			'organization' => $res['organization'],
			'ticket' => $res['ticket']
		));
}

function aselect_verify_credentials_full($rid, $cred) {
	$res = aselect_verify_credentials_raw($rid, $cred);
	if(is_null($res))
		return null;
	$info = array(
			'res' => $res,
			'cookie' => aselect_verify_credentials_cookie($res)
		);
	if(array_key_exists('attributes', $res))
		$info['attributes'] = aselect_decode($res['attributes']);
	return $info;
}

function aselect_verify_credentials($rid, $cred) {
	$res = aselect_verify_credentials_raw($rid, $cred);
	if(is_null($res))
		return null;
	return aselect_join(array(
			'uid' => $res['uid'],
			'organization' => $res['organization'],
			'ticket' => $res['ticket']
		));
}

function aselect_verify_ticket($cookie) {
	if(empty($cookie))
		return null;
	$res = aselect_split($cookie);
	$args = array(
			'request' => 'verify_ticket',
			'uid' => $res['uid'],
			'organization' => $res['organization'],
			'ticket' => $res['ticket']
		);
	if(!aselect_valid($args))
		return null;
	$res = aselect_comm($args);
	if(is_null($res))
		return null;
	return array(
			'uid' => $args['uid'],
			'organization' => $args['organization'],
			'ticket' => $args['ticket']
		);
}

function aselect_attributes($ticket) {
	$args = aselect_split($ticket);
	$args['request'] = 'attributes';
	if(!aselect_valid($args))
		return null;
	$res = aselect_comm($args);
	if(is_null($res))
		return null;
	return aselect_decode($res['attributes']);
}

?>
