# $Id: GSSAPI.pm 37835 2012-09-14 14:51:14Z wsl $
# $URL: https://svn.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/GSSAPI.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::GSSAPI;

use GSSAPI;

use Clarity -self;

field cfg;

sub checked() {
	my ($name, $status) = @_;
	return if $status;
	return unless defined $status;
	my $generic = $status->generic_message;
	my $specific = $status->specific_message;
	die "[$name] $generic: $specific\n";
}

field principal => sub { shift->cfg->kerberos_principal };

const credentials => sub {
	my $self = shift;

	checked("gss_acquire_cred", GSSAPI::Cred::acquire_cred($self->principal, GSS_C_INDEFINITE, GSS_C_NO_OID_SET, GSS_C_ACCEPT, my $scred, my $stime, undef));

	return $scred;
};

sub authenticate {
	my $blob = shift;

	my $context = new GSSAPI::Context;
	checked("gss_accept_sec_context", $context->accept($self->credentials, $blob, GSS_C_NO_CHANNEL_BINDINGS, my $gss_client_name, my $out_mech, my $gss_output_token, my $out_flags, my $out_time, my $gss_delegated_cred));

	checked($gss_client_name->display(my $tname));

	my ($uid, $org) = split('@', $tname, 2);

	return $org, $uid;
}
