# $Id: Request.pm 36089 2011-11-23 19:23:06Z wsl $
# $URL: https://svn.uvt.nl/its-id/branches/sources/aselect-perl-2/lib/Aselect/UI/Static/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Static::Request;

use Xyzzy::Static;
use Aselect::UI::Error::HTTP;

use Aselect::UI::Request -self;
use Xyzzy::Static::Request -mixin;

sub error {
	my $doc = new Aselect::UI::Error::HTTP(req => $self, number => shift);
	return $doc->response;
}

sub path_components {
	my $path = super;
	my $lang = $self->lang
		or return $path;
	$path = ['index'] unless @$path;
	return [$lang, @$path];
}
