# $Id: Document.pm 35159 2011-07-04 19:24:05Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Status/Document.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Status::Document;

use Xyzzy::Util qw(iso8601);

use Aselect::UI::Document -self;

sub build {
	my $req = $self->req;
	my $cfg = $self->cfg;

	my $root = $self->construct(status =>
		[nonce => $req->create_nonce],
		[warn => $req->new_warn],
		[spnego => $req->new_spnego],
	);
	$self->setDocumentElement($root);

	if(my $uid = $req->uid) {
		my $exp = $req->new_session->expiration;

		my $session = $self->construct(session =>
			[uid => $uid],
			[organization => $cfg->organization],
			[start => iso8601(localtime($exp))],
			[end => iso8601(localtime($exp + $cfg->session_timeout))],
		);

		$root->appendChild($session);

		my $requestors = $cfg->requestors;

		if(my $app_id = $req->app_id) {
			my $requestor = $requestors->{$app_id}
				or die $req->error('app_id', undef, app_id => $app_id);
			$session->appendTextChild('app_id', $app_id);

			my $attributes = $cfg->dir->attributes($uid, $requestor);

			my %attributes;
			while(@$attributes) {
				my $key = shift @$attributes;
				my $val = shift @$attributes;
				push @{$attributes{$key}}, $val;
			}

			my $attrlist = $self->construct('attributes');
			while(my ($key, $values) = each(%attributes)) {
				$attrlist->appendChild($self->construct('attribute',
					[name => $key],
					[values => map {[value => $_]} @$values]
				));
			}
			$session->appendChild($attrlist);
		}

		my @requestors;
		while(my ($key, $val) = each(%$requestors)) {
			my $policy = $val->policy or next;
			push @requestors, $key if %$policy;
		}

		if(@requestors) {
			$session->appendChild($self->construct(requestors =>
				map {[requestor => $_]} @requestors));
		}
	}
}

sub response {
	my $res = super;
	my $req = $self->req;

	if((my $warn = $req->new_warn) ne $req->cur_warn) {
		my $cookie = $self->bakecookie(warn => $warn);
		if($warn eq 'true') {
			$cookie->expire('1y');
		} else {
			$cookie->expire(0);
		}
		$res->setcookie($cookie);
	}

	if((my $spnego = $req->new_spnego) ne $req->cur_spnego) {
		my $cookie = $self->bakecookie(spnego => $spnego);
		if($spnego eq 'auto') {
			$cookie->expire(0);
		} else {
			$cookie->expire('1y');
		}
		$res->setcookie($cookie);
	}

	return $res;
}
