# $Id: Request.pm 35117 2011-06-27 20:15:11Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Logout/Request.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Logout::Request;

use Aselect::UI::Login;
use Aselect::UI::Login::Request -self;

param url => sub { $_ //= shift->script_url . '/' };

use Data::Dumper;

sub uid {
	my $session = $self->cur_session;
	return $session && $session->uid;
}

field new_session => sub {
	my $self = shift;
	return $self->logout_ok
		? $self->create_session
		: $self->SUPER::new_session;
};

sub logout_ok {
	return $self->uid && (!$self->new_warn || $self->nonce);
}

sub confirmation_needed {
	return $self->uid && $self->new_warn && !$self->nonce;
}
