# $Id: Confirm.pm 35117 2011-06-27 20:15:11Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Logout/Confirm.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Logout::Confirm;

use Aselect::UI::Document -self;

sub build {
	my $req = $self->req;

	my $root = $self->construct('confirm-logout' =>
		[nonce => $req->create_nonce]
	);
	$self->setDocumentElement($root);

	if(my $url = $req->bare_url) {
		$root->appendTextChild(url => $url);
	}

	if($req->new_warn) {
		$root->appendTextChild(warn => 'true');
	}
}
