# $Id: Success.pm 35117 2011-06-27 20:15:11Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/UI/Login/Success.pm $

use strict;
use warnings FATAL => 'all';
use utf8;

package Aselect::UI::Login::Success;

use Aselect::UI::Document -self;

sub build {
	my $req = $self->req;

	my $root = $self->construct('login-success' =>
		[nonce => $req->create_nonce],
		[url => $req->bare_url],
		[uid => $req->uid],
	);
	$self->setDocumentElement($root);

	if(my $rid = $req->rid) {
		$root->appendTextChild(rid => $rid);
	}

	if(my $service = $req->service) {
		$root->appendTextChild(service => $service);
	}

	if(my $warn = $req->new_warn) {
		$root->appendTextChild(warn => 'true');
	}
}

sub response {
	my $res = super;

	my $req = $self->req;

	if(!$req->new_warn || $req->nonce) {
		$res->status(302);
		$res->setheader(Location => $req->url);
	}

	return $res;
}
