# $Id: ValidateCAS.pm 34797 2011-05-16 18:00:02Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/ValidateCAS.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::ValidateCASv1::Document;

use Xyzzy::Document -self;

sub response {
	my $req = $self->req;

	my $uid = $req->uid;

	my $answer = defined $uid ? "yes\n$uid\n" : "no\n\n";

	return new Xyzzy::Response(content => $answer);
}

package Aselect::ValidateCASv2::Document;

use Xyzzy::Document -self;

sub build {
	my $req = $self->req;

	my $serviceResponse = $self->createElementNS('http://www.yale.edu/tp/cas', 'cas:serviceResponse');
	$self->setDocumentElement($serviceResponse);

	my $uid = $req->uid;

	my $code = $req->service && $req->ticket
		? 'INVALID_TICKET'
		: 'INVALID_REQUEST';

	my $answer = defined $uid
		? $self->construct('cas:authenticationSuccess' => ['cas:user' => $uid])
		: $self->construct('cas:authenticationFailure' => {code => $code});

	$serviceResponse->appendChild($answer);
}

package Aselect::ValidateCAS::Request;

use Aselect::Request -self;

param service => sub { die shift->error("Required request parameter 'service' not supplied") unless defined };
param ticket => sub { die shift->error("Required request parameter 'ticket' not supplied") unless defined };
param pgtUrl => sub { 'FIXME' };
param renew => sub { 'FIXME' };

const uid => sub {
	my $self = shift;
	my $cfg = $self->cfg;
	my $crypto = $self->crypto;

	my $ticket = $self->ticket;
	my $service = $self->service;

	my (undef, undef, $uid) = eval { $crypto->check_cas_token('ST', $service, $ticket, $cfg->credential_timeout) };
	warn "validate: $@" if $@;
	return $uid;
};

sub error {
	my $status = new Xyzzy::Status(400, shift);
	return $status->response;
}

package Aselect::ValidateCASv1;

use Aselect::Handler -self;

sub handle {
	my $req = new Aselect::ValidateCAS::Request(cfg => $self, ctx => shift);
	my $doc = new Aselect::ValidateCASv1::Document(req => $req);
	return $doc->response;
}

package Aselect::ValidateCASv2;

use Aselect::Handler -self;

sub handle {
	my $req = new Aselect::ValidateCAS::Request(cfg => $self, ctx => shift);
	my $doc = new Aselect::ValidateCASv2::Document(req => $req);
	return $doc->response;
}
