# $Id: Server.pm 34114 2011-03-03 17:25:07Z wsl $
# $URL: https://infix.uvt.nl/its-id/trunk/sources/aselect-perl/lib/Aselect/Server.pm $

use utf8;
use strict;
use warnings FATAL => 'all';

package Aselect::Server::Request;

use Aselect::Request -self;

param request => sub { die "0030 Required request parameter 'request' not supplied\n" unless defined };

package Aselect::Server::Error;

use Aselect::Error;
use Aselect::Responder;

use Aselect::Responder::Request -self;

field code;
field message;

field response => sub {
	my $self = shift;

	my $err = new Aselect::Error($self->code);

	my $message = $self->message;
	$message =~ s/\s+$//;
	if($message) {
		return {result_code => $err->code, message => $message};
	} elsif($message = $err->message) {
		return {result_code => $err->code, message => $message, description => $err->description};
	} else {
		return {result_code => $err->code};
	}
};

package Aselect::Server;

use Aselect::Responder;

use Aselect::Handler -self;

field 'requests';

sub handle {
	my $req = new Aselect::Server::Request(cfg => $self, ctx => shift);
	my $res = eval {
		my $handler = $self->requests->{$req->request}
			or die "0030 Unknown request\n";
		$handler->handle($req);
	};
	if($@) {
		my $exc = $@;
		die $exc if ref $exc || $exc !~ /^(\d\d\d\d)(?: (.*))?$/;
		my $err = new Aselect::Server::Error(cfg => $self, ctx => $req, code => $1, message => $2);
		my $doc = new Aselect::Responder::Document(req => $err);
		die $doc->response;
	}
	return $res;
}
